/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core;

import com.bea.core.repackaged.springframework.core.ControlFlow;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return new Jdk14ControlFlow();
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className)) continue;
                return true;
            }
            return false;
        }

        public boolean under(Class clazz, String methodName) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(methodName, "Method name must not be null");
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className) || !this.stack[i].getMethodName().equals(methodName)) continue;
                return true;
            }
            return false;
        }

        public boolean underToken(String token) {
            if (token == null) {
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            return stackTrace.indexOf(token) != -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Jdk14ControlFlow: ");
            for (int i = 0; i < this.stack.length; ++i) {
                if (i > 0) {
                    sb.append("\n\t@");
                }
                sb.append(this.stack[i]);
            }
            return sb.toString();
        }
    }
}

