/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core;

import com.bea.core.repackaged.springframework.util.Assert;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class DecoratingClassLoader
extends ClassLoader {
    private final Set excludedPackages = new HashSet();
    private final Set excludedClasses = new HashSet();
    private final Object exclusionMonitor = new Object();

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedPackages.add(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedClasses.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExcluded(String className) {
        Object object = this.exclusionMonitor;
        synchronized (object) {
            if (this.excludedClasses.contains(className)) {
                return true;
            }
            Iterator it = this.excludedPackages.iterator();
            while (it.hasNext()) {
                String packageName = (String)it.next();
                if (!className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

