/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core;

import com.bea.core.repackaged.springframework.core.ParameterNameDiscoverer;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodParameter {
    private static final Method methodParameterAnnotationsMethod = ClassUtils.getMethodIfAvailable(Method.class, "getParameterAnnotations", new Class[0]);
    private static final Method constructorParameterAnnotationsMethod = ClassUtils.getMethodIfAvailable(Constructor.class, "getParameterAnnotations", new Class[0]);
    private Method method;
    private Constructor constructor;
    private final int parameterIndex;
    private Class parameterType;
    private Object[] parameterAnnotations;
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private String parameterName;
    private int nestingLevel = 1;
    private Map typeIndexesPerLevel;
    Map typeVariableMap;

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        Assert.notNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(Constructor constructor, int parameterIndex) {
        this(constructor, parameterIndex, 1);
    }

    public MethodParameter(Constructor constructor, int parameterIndex, int nestingLevel) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.constructor = constructor;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(MethodParameter original) {
        Assert.notNull(original, "Original must not be null");
        this.method = original.method;
        this.constructor = original.constructor;
        this.parameterIndex = original.parameterIndex;
        this.parameterType = original.parameterType;
        this.parameterAnnotations = original.parameterAnnotations;
        this.typeVariableMap = original.typeVariableMap;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    void setParameterType(Class parameterType) {
        this.parameterType = parameterType;
    }

    public Class getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = this.method != null ? this.method.getParameterTypes()[this.parameterIndex] : this.constructor.getParameterTypes()[this.parameterIndex];
        }
        return this.parameterType;
    }

    public Object[] getParameterAnnotations() {
        if (this.parameterAnnotations != null) {
            return this.parameterAnnotations;
        }
        if (methodParameterAnnotationsMethod == null) {
            return null;
        }
        Object[][] annotationArray = this.method != null ? (Object[][])ReflectionUtils.invokeMethod(methodParameterAnnotationsMethod, this.method) : (Object[][])ReflectionUtils.invokeMethod(constructorParameterAnnotationsMethod, this.constructor);
        this.parameterAnnotations = annotationArray[this.parameterIndex];
        return this.parameterAnnotations;
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public String getParameterName() {
        if (this.parameterNameDiscoverer != null) {
            String[] parameterNames;
            String[] stringArray = parameterNames = this.method != null ? this.parameterNameDiscoverer.getParameterNames(this.method) : this.parameterNameDiscoverer.getParameterNames(this.constructor);
            if (parameterNames != null) {
                this.parameterName = parameterNames[this.parameterIndex];
            }
            this.parameterNameDiscoverer = null;
        }
        return this.parameterName;
    }

    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(new Integer(this.nestingLevel));
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public void setTypeIndexForCurrentLevel(int typeIndex) {
        this.getTypeIndexesPerLevel().put(new Integer(this.nestingLevel), new Integer(typeIndex));
    }

    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    public Integer getTypeIndexForLevel(int nestingLevel) {
        return (Integer)this.getTypeIndexesPerLevel().get(new Integer(nestingLevel));
    }

    private Map getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap(4);
        }
        return this.typeIndexesPerLevel;
    }

    public static MethodParameter forMethodOrConstructor(Object methodOrConstructor, int parameterIndex) {
        if (methodOrConstructor instanceof Method) {
            return new MethodParameter((Method)methodOrConstructor, parameterIndex);
        }
        if (methodOrConstructor instanceof Constructor) {
            return new MethodParameter((Constructor)methodOrConstructor, parameterIndex);
        }
        throw new IllegalArgumentException("Given object [" + methodOrConstructor + "] is neither a Method nor a Constructor");
    }
}

