/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.task.support;

import com.bea.core.repackaged.springframework.core.task.TaskExecutor;
import com.bea.core.repackaged.springframework.core.task.TaskRejectedException;
import com.bea.core.repackaged.springframework.util.Assert;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class ConcurrentExecutorAdapter
implements Executor {
    private final TaskExecutor taskExecutor;

    public ConcurrentExecutorAdapter(TaskExecutor taskExecutor) {
        Assert.notNull(taskExecutor, "TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public void execute(Runnable command) {
        try {
            this.taskExecutor.execute(command);
        }
        catch (TaskRejectedException ex) {
            throw new RejectedExecutionException(ex.getMessage(), ex);
        }
    }
}

