/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.type;

import com.bea.core.repackaged.springframework.core.annotation.AnnotationUtils;
import com.bea.core.repackaged.springframework.core.type.AnnotationMetadata;
import com.bea.core.repackaged.springframework.core.type.StandardClassMetadata;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    public StandardAnnotationMetadata(Class introspectedClass) {
        super(introspectedClass);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            types.add(anns[i].annotationType().getName());
        }
        return types;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            if (!anns[i].annotationType().getName().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] metaAnns;
            if (!anns[i].annotationType().getName().equals(annotationType)) continue;
            HashSet<String> types = new HashSet<String>();
            for (Annotation meta : metaAnns = anns[i].annotationType().getAnnotations()) {
                types.add(meta.annotationType().getName());
            }
            return types;
        }
        return null;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] metaAnns;
            for (Annotation meta : metaAnns = anns[i].annotationType().getAnnotations()) {
                if (!meta.annotationType().getName().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation ann = anns[i];
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            return AnnotationUtils.getAnnotationAttributes(ann);
        }
        return null;
    }
}

