/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.type.classreading;

import com.bea.core.repackaged.springframework.asm.AnnotationVisitor;
import com.bea.core.repackaged.springframework.asm.Type;
import com.bea.core.repackaged.springframework.asm.commons.EmptyVisitor;
import com.bea.core.repackaged.springframework.core.type.AnnotationMetadata;
import com.bea.core.repackaged.springframework.core.type.classreading.ClassMetadataReadingVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements AnnotationMetadata {
    private final Map<String, Map<String, Object>> attributesMap = new LinkedHashMap<String, Map<String, Object>>();
    private final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>();

    AnnotationMetadataReadingVisitor() {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        final String className = Type.getType(desc).getClassName();
        final LinkedHashMap attributes = new LinkedHashMap();
        return new EmptyVisitor(){

            public void visit(String name, Object value) {
                attributes.put(name, value);
            }

            public void visitEnd() {
                try {
                    Class<?> annotationClass = this.getClass().getClassLoader().loadClass(className);
                    Method[] annotationAttributes = annotationClass.getMethods();
                    for (int i = 0; i < annotationAttributes.length; ++i) {
                        Method annotationAttribute = annotationAttributes[i];
                        String attributeName = annotationAttribute.getName();
                        Object defaultValue = annotationAttribute.getDefaultValue();
                        if (defaultValue == null || attributes.containsKey(attributeName)) continue;
                        attributes.put(attributeName, defaultValue);
                    }
                    Annotation[] metaAnnotations = annotationClass.getAnnotations();
                    HashSet<String> metaAnnotationTypeNames = new HashSet<String>();
                    for (Annotation metaAnnotation : metaAnnotations) {
                        metaAnnotationTypeNames.add(metaAnnotation.annotationType().getName());
                    }
                    AnnotationMetadataReadingVisitor.this.metaAnnotationMap.put(className, metaAnnotationTypeNames);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                AnnotationMetadataReadingVisitor.this.attributesMap.put(className, attributes);
            }
        };
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.attributesMap.keySet();
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        return this.attributesMap.containsKey(annotationType);
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        return this.metaAnnotationMap.get(annotationType);
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        Collection<Set<String>> allMetaTypes = this.metaAnnotationMap.values();
        for (Set<String> metaTypes : allMetaTypes) {
            if (!metaTypes.contains(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.attributesMap.get(annotationType);
    }
}

