/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.type.classreading;

import com.bea.core.repackaged.springframework.asm.commons.EmptyVisitor;
import com.bea.core.repackaged.springframework.core.type.ClassMetadata;
import com.bea.core.repackaged.springframework.util.ClassUtils;

class ClassMetadataReadingVisitor
extends EmptyVisitor
implements ClassMetadata {
    private String className;
    private boolean isInterface;
    private boolean isAbstract;
    private String enclosingClassName;
    private boolean independentInnerClass;
    private String superClassName;
    private String[] interfaces;

    ClassMetadataReadingVisitor() {
    }

    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.className = ClassUtils.convertResourcePathToClassName(name);
        this.isInterface = (access & 0x200) != 0;
        boolean bl = this.isAbstract = (access & 0x400) != 0;
        if (supername != null) {
            this.superClassName = ClassUtils.convertResourcePathToClassName(supername);
        }
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.interfaces[i] = ClassUtils.convertResourcePathToClassName(interfaces[i]);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = ClassUtils.convertResourcePathToClassName(owner);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (outerName != null && this.className.equals(ClassUtils.convertResourcePathToClassName(name))) {
            this.enclosingClassName = ClassUtils.convertResourcePathToClassName(outerName);
            this.independentInnerClass = (access & 8) != 0;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConcrete() {
        return !this.isInterface && !this.isAbstract;
    }

    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    public boolean hasEnclosingClass() {
        return this.enclosingClassName != null;
    }

    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }
}

