/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.type.filter;

import com.bea.core.repackaged.springframework.core.type.AnnotationMetadata;
import com.bea.core.repackaged.springframework.core.type.classreading.MetadataReader;
import com.bea.core.repackaged.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class<? extends Annotation> annotationType;
    private final boolean considerMetaAnnotations;

    public AnnotationTypeFilter(Class<? extends Annotation> annotationType) {
        this(annotationType, true);
    }

    public AnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations) {
        super(annotationType.isAnnotationPresent(Inherited.class), false);
        this.annotationType = annotationType;
        this.considerMetaAnnotations = considerMetaAnnotations;
    }

    @Override
    protected boolean matchSelf(MetadataReader metadataReader) {
        AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
        return metadata.hasAnnotation(this.annotationType.getName()) || this.considerMetaAnnotations && metadata.hasMetaAnnotation(this.annotationType.getName());
    }

    @Override
    protected Boolean matchSuperClass(String superClassName) {
        if (Object.class.getName().equals(superClassName)) {
            return Boolean.FALSE;
        }
        if (superClassName.startsWith("java.")) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(superClassName);
                return clazz.getAnnotation(this.annotationType) != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

