/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.dao.support;

import com.bea.core.repackaged.springframework.dao.DataAccessException;
import com.bea.core.repackaged.springframework.dao.EmptyResultDataAccessException;
import com.bea.core.repackaged.springframework.dao.IncorrectResultSizeDataAccessException;
import com.bea.core.repackaged.springframework.dao.TypeMismatchDataAccessException;
import com.bea.core.repackaged.springframework.dao.support.PersistenceExceptionTranslator;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.CollectionUtils;
import com.bea.core.repackaged.springframework.util.NumberUtils;
import java.util.Collection;

public abstract class DataAccessUtils {
    public static Object singleResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object requiredSingleResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object uniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object requiredUniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object objectResult(Collection results, Class requiredType) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        Object result = DataAccessUtils.requiredUniqueResult(results);
        if (requiredType != null && !requiredType.isInstance(result)) {
            if (String.class.equals(requiredType)) {
                result = result.toString();
            } else if (Number.class.isAssignableFrom(requiredType) && Number.class.isInstance(result)) {
                try {
                    result = NumberUtils.convertNumberToTargetClass((Number)result, requiredType);
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchDataAccessException(ex.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object is of type [" + result.getClass().getName() + "] and could not be converted to required type [" + requiredType.getName() + "]");
            }
        }
        return result;
    }

    public static int intResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(results, Number.class)).intValue();
    }

    public static long longResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(results, Number.class)).longValue();
    }

    public static RuntimeException translateIfNecessary(RuntimeException rawException, PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        DataAccessException dex = pet.translateExceptionIfPossible(rawException);
        return dex != null ? dex : rawException;
    }
}

