/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.ejb.support;

import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.FatalBeanException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryLocator;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryReference;
import com.bea.core.repackaged.springframework.context.access.ContextJndiBeanFactoryLocator;
import com.bea.core.repackaged.springframework.util.WeakReferenceMonitor;
import javax.ejb.EnterpriseBean;

public abstract class AbstractEnterpriseBean
implements EnterpriseBean {
    public static final String BEAN_FACTORY_PATH_ENVIRONMENT_KEY = "java:comp/env/ejb/BeanFactoryPath";
    private BeanFactoryLocator beanFactoryLocator;
    private String beanFactoryLocatorKey;
    private BeanFactoryReference beanFactoryReference;

    public void setBeanFactoryLocator(BeanFactoryLocator beanFactoryLocator) {
        this.beanFactoryLocator = beanFactoryLocator;
    }

    public void setBeanFactoryLocatorKey(String factoryKey) {
        this.beanFactoryLocatorKey = factoryKey;
    }

    void loadBeanFactory() throws BeansException {
        if (this.beanFactoryLocator == null) {
            this.beanFactoryLocator = new ContextJndiBeanFactoryLocator();
        }
        if (this.beanFactoryLocatorKey == null) {
            this.beanFactoryLocatorKey = BEAN_FACTORY_PATH_ENVIRONMENT_KEY;
        }
        this.beanFactoryReference = this.beanFactoryLocator.useBeanFactory(this.beanFactoryLocatorKey);
        WeakReferenceMonitor.monitor(this, new BeanFactoryReferenceReleaseListener(this.beanFactoryReference));
    }

    void unloadBeanFactory() throws FatalBeanException {
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactoryReference.getFactory();
    }

    public void ejbRemove() {
        this.onEjbRemove();
        this.unloadBeanFactory();
    }

    protected void onEjbRemove() {
    }

    private static class BeanFactoryReferenceReleaseListener
    implements WeakReferenceMonitor.ReleaseListener {
        private final BeanFactoryReference beanFactoryReference;

        public BeanFactoryReferenceReleaseListener(BeanFactoryReference beanFactoryReference) {
            this.beanFactoryReference = beanFactoryReference;
        }

        public void released() {
            this.beanFactoryReference.release();
        }
    }
}

