/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.instrument.classloading.glassfish;

import com.bea.core.repackaged.springframework.instrument.classloading.LoadTimeWeaver;
import com.bea.core.repackaged.springframework.instrument.classloading.glassfish.ClassTransformerAdapter;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import java.lang.instrument.ClassFileTransformer;
import javax.persistence.spi.ClassTransformer;

public class GlassFishLoadTimeWeaver
implements LoadTimeWeaver {
    private final InstrumentableClassLoader classLoader;

    public GlassFishLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public GlassFishLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        InstrumentableClassLoader icl = this.determineClassLoader(classLoader);
        if (icl == null) {
            throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: " + "An [" + InstrumentableClassLoader.class.getName() + "] implementation is required.");
        }
        this.classLoader = icl;
    }

    protected InstrumentableClassLoader determineClassLoader(ClassLoader classLoader) {
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            if (!(cl instanceof InstrumentableClassLoader)) continue;
            return (InstrumentableClassLoader)cl;
        }
        return null;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer((ClassTransformer)new ClassTransformerAdapter(transformer));
    }

    public ClassLoader getInstrumentableClassLoader() {
        return (ClassLoader)this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.copy();
    }
}

