/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.instrument.classloading.weblogic;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Hashtable;

class WebLogicClassPreProcessorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;
    private final ClassLoader loader;

    public WebLogicClassPreProcessorAdapter(ClassFileTransformer transformer, ClassLoader loader) {
        this.transformer = transformer;
        this.loader = loader;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            return proxy == args[0];
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("initialize".equals(method.getName())) {
            this.initialize((Hashtable)args[0]);
            return null;
        }
        if ("preProcess".equals(method.getName())) {
            return this.preProcess((String)args[0], (byte[])args[1]);
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public void initialize(Hashtable params) {
    }

    public byte[] preProcess(String className, byte[] classBytes) {
        try {
            byte[] result = this.transformer.transform(this.loader, className, null, null, classBytes);
            return result != null ? result : classBytes;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException("Cannot transform due to illegal class format", ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

