/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.export.assembler;

import com.bea.core.repackaged.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import com.bea.core.repackaged.springframework.jmx.export.metadata.JmxMetadataUtils;
import com.bea.core.repackaged.springframework.jmx.export.metadata.ManagedNotification;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.modelmbean.ModelMBeanNotificationInfo;

public abstract class AbstractConfigurableMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler {
    private ModelMBeanNotificationInfo[] notificationInfos;
    private final Map notificationInfoMappings = new HashMap();

    public void setNotificationInfos(ManagedNotification[] notificationInfos) {
        ModelMBeanNotificationInfo[] infos = new ModelMBeanNotificationInfo[notificationInfos.length];
        for (int i = 0; i < notificationInfos.length; ++i) {
            ManagedNotification notificationInfo = notificationInfos[i];
            infos[i] = JmxMetadataUtils.convertToModelMBeanNotificationInfo(notificationInfo);
        }
        this.notificationInfos = infos;
    }

    public void setNotificationInfoMappings(Map notificationInfoMappings) {
        Iterator entries = notificationInfoMappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Property [notificationInfoMappings] only accepts Strings for Map keys");
            }
            this.notificationInfoMappings.put(entry.getKey(), this.extractNotificationMetadata(entry.getValue()));
        }
    }

    protected ModelMBeanNotificationInfo[] getNotificationInfo(Object managedBean, String beanKey) {
        ModelMBeanNotificationInfo[] result = null;
        if (StringUtils.hasText(beanKey)) {
            result = (ModelMBeanNotificationInfo[])this.notificationInfoMappings.get(beanKey);
        }
        if (result == null) {
            result = this.notificationInfos;
        }
        return result == null ? new ModelMBeanNotificationInfo[]{} : result;
    }

    private ModelMBeanNotificationInfo[] extractNotificationMetadata(Object mapValue) {
        if (mapValue instanceof ManagedNotification) {
            ManagedNotification mn = (ManagedNotification)mapValue;
            return new ModelMBeanNotificationInfo[]{JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn)};
        }
        if (mapValue instanceof Collection) {
            Collection col = (Collection)mapValue;
            ArrayList<ModelMBeanNotificationInfo> result = new ArrayList<ModelMBeanNotificationInfo>();
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                Object colValue = iterator.next();
                if (!(colValue instanceof ManagedNotification)) {
                    throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
                }
                ManagedNotification mn = (ManagedNotification)colValue;
                result.add(JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn));
            }
            return result.toArray(new ModelMBeanNotificationInfo[result.size()]);
        }
        throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
    }
}

