/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.support;

import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.jmx.MBeanServerNotFoundException;
import com.bea.core.repackaged.springframework.jndi.JndiLocatorSupport;
import java.lang.reflect.InvocationTargetException;
import javax.management.MBeanServer;
import javax.naming.NamingException;

public class WebLogicJndiMBeanServerFactoryBean
extends JndiLocatorSupport
implements FactoryBean,
InitializingBean {
    private static final String WEBLOGIC_MBEAN_HOME_CLASS = "weblogic.management.MBeanHome";
    private static final String LOCAL_JNDI_NAME_FIELD = "LOCAL_JNDI_NAME";
    private static final String GET_MBEAN_SERVER_METHOD = "getMBeanServer";
    private String mbeanHomeName;
    private MBeanServer mbeanServer;

    public void setMbeanHomeName(String mbeanHomeName) {
        this.mbeanHomeName = mbeanHomeName;
    }

    public void afterPropertiesSet() throws MBeanServerNotFoundException {
        try {
            String jndiName = this.mbeanHomeName;
            if (jndiName == null) {
                Class<?> mbeanHomeClass = this.getClass().getClassLoader().loadClass(WEBLOGIC_MBEAN_HOME_CLASS);
                jndiName = (String)mbeanHomeClass.getField(LOCAL_JNDI_NAME_FIELD).get(null);
            }
            Object mbeanHome = this.lookup(jndiName);
            this.mbeanServer = (MBeanServer)mbeanHome.getClass().getMethod(GET_MBEAN_SERVER_METHOD, null).invoke(mbeanHome, null);
        }
        catch (NamingException ex) {
            throw new MBeanServerNotFoundException("Could not find WebLogic's MBeanHome object in JNDI", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MBeanServerNotFoundException("Could not find WebLogic's MBeanHome class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new MBeanServerNotFoundException("WebLogic's MBeanHome.getMBeanServer method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new MBeanServerNotFoundException("Could not access WebLogic's MBeanHome/getMBeanServer method", ex);
        }
    }

    public Object getObject() {
        return this.mbeanServer;
    }

    public Class getObjectType() {
        return this.mbeanServer != null ? this.mbeanServer.getClass() : MBeanServer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

