/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jndi;

import com.bea.core.repackaged.springframework.aop.framework.ProxyFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanClassLoaderAware;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.jndi.JndiObjectLocator;
import com.bea.core.repackaged.springframework.jndi.JndiObjectTargetSource;
import com.bea.core.repackaged.springframework.jndi.TypeMismatchNamingException;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import javax.naming.NamingException;

public class JndiObjectFactoryBean
extends JndiObjectLocator
implements FactoryBean,
BeanClassLoaderAware {
    private Class[] proxyInterfaces;
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object defaultObject;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object jndiObject;

    public void setProxyInterface(Class proxyInterface) {
        this.proxyInterfaces = new Class[]{proxyInterface};
    }

    public void setProxyInterfaces(Class[] proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setDefaultObject(Object defaultObject) {
        this.defaultObject = defaultObject;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        super.afterPropertiesSet();
        if (!this.lookupOnStartup || !this.cache) {
            Class expectedType;
            if (this.proxyInterfaces == null && (expectedType = this.getExpectedType()) != null) {
                this.proxyInterfaces = ClassUtils.getAllInterfacesForClass(expectedType, this.beanClassLoader);
            }
            if (this.proxyInterfaces == null) {
                throw new IllegalArgumentException("Cannot deactivate 'lookupOnStartup' or 'cache' without specifying a 'proxyInterface'");
            }
        }
        if (this.proxyInterfaces != null) {
            if (this.defaultObject != null) {
                throw new IllegalArgumentException("'defaultObject' is not supported in combination with 'proxyInterface'");
            }
            this.jndiObject = JndiObjectProxyFactory.createJndiObjectProxy(this);
        } else {
            if (this.defaultObject != null && this.getExpectedType() != null && !this.getExpectedType().isInstance(this.defaultObject)) {
                throw new IllegalArgumentException("Default object [" + this.defaultObject + "] of type [" + this.defaultObject.getClass().getName() + "] is not of expected type [" + this.getExpectedType().getName() + "]");
            }
            this.jndiObject = this.lookupWithFallback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object lookupWithFallback() throws NamingException {
        ClassLoader originalClassLoader = ClassUtils.overrideThreadContextClassLoader(this.beanClassLoader);
        try {
            try {
                Object object = this.lookup();
                Object var5_5 = null;
                if (originalClassLoader == null) return object;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                return object;
            }
            catch (TypeMismatchNamingException ex) {
                throw ex;
            }
            catch (NamingException ex) {
                if (this.defaultObject == null) throw ex;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"JNDI lookup failed - returning specified default object instead", (Throwable)ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("JNDI lookup failed - returning specified default object instead: " + ex));
                }
                Object object = this.defaultObject;
                Object var5_6 = null;
                if (originalClassLoader == null) return object;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (originalClassLoader == null) throw throwable;
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            throw throwable;
        }
    }

    public Object getObject() {
        return this.jndiObject;
    }

    public Class getObjectType() {
        if (this.proxyInterfaces != null) {
            if (this.proxyInterfaces.length == 1) {
                return this.proxyInterfaces[0];
            }
            if (this.proxyInterfaces.length > 1) {
                return this.createCompositeInterface(this.proxyInterfaces);
            }
        }
        if (this.jndiObject != null) {
            return this.jndiObject.getClass();
        }
        return this.getExpectedType();
    }

    public boolean isSingleton() {
        return true;
    }

    protected Class createCompositeInterface(Class[] interfaces) {
        return ClassUtils.createCompositeInterface(interfaces, this.beanClassLoader);
    }

    private static class JndiObjectProxyFactory {
        private JndiObjectProxyFactory() {
        }

        private static Object createJndiObjectProxy(JndiObjectFactoryBean jof) throws NamingException {
            JndiObjectTargetSource targetSource = new JndiObjectTargetSource();
            targetSource.setJndiTemplate(jof.getJndiTemplate());
            targetSource.setJndiName(jof.getJndiName());
            targetSource.setExpectedType(jof.getExpectedType());
            targetSource.setResourceRef(jof.isResourceRef());
            targetSource.setLookupOnStartup(jof.lookupOnStartup);
            targetSource.setCache(jof.cache);
            targetSource.afterPropertiesSet();
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setInterfaces(jof.proxyInterfaces);
            proxyFactory.setTargetSource(targetSource);
            return proxyFactory.getProxy(jof.beanClassLoader);
        }
    }
}

