/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.remoting.support;

import com.bea.core.repackaged.springframework.aop.framework.ProxyFactory;
import com.bea.core.repackaged.springframework.remoting.support.RemoteInvocationTraceInterceptor;
import com.bea.core.repackaged.springframework.remoting.support.RemotingSupport;
import com.bea.core.repackaged.springframework.util.ClassUtils;

public abstract class RemoteExporter
extends RemotingSupport {
    private Object service;
    private Class serviceInterface;
    private boolean registerTraceInterceptor = true;

    public void setService(Object service) {
        this.service = service;
    }

    public Object getService() {
        return this.service;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    protected boolean isRegisterTraceInterceptor() {
        return this.registerTraceInterceptor;
    }

    protected void checkService() throws IllegalArgumentException {
        if (this.getService() == null) {
            throw new IllegalArgumentException("Property 'service' is required");
        }
    }

    protected void checkServiceInterface() throws IllegalArgumentException {
        Class serviceInterface = this.getServiceInterface();
        Object service = this.getService();
        if (serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (service instanceof String) {
            throw new IllegalArgumentException("Service [" + service + "] is a String " + "rather than an actual service reference: Have you accidentally specified " + "the service bean name as value instead of as reference?");
        }
        if (!serviceInterface.isInstance(service)) {
            throw new IllegalArgumentException("Service interface [" + serviceInterface.getName() + "] needs to be implemented by service [" + service + "] of class [" + service.getClass().getName() + "]");
        }
    }

    protected Object getProxyForService() {
        this.checkService();
        this.checkServiceInterface();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(this.getServiceInterface());
        if (this.isRegisterTraceInterceptor()) {
            proxyFactory.addAdvice(new RemoteInvocationTraceInterceptor(this.getExporterName()));
        }
        proxyFactory.setTarget(this.getService());
        return proxyFactory.getProxy(this.getBeanClassLoader());
    }

    protected String getExporterName() {
        return ClassUtils.getShortName(this.getClass());
    }
}

