/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.scheduling.timer;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.DisposableBean;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.scheduling.SchedulingTaskExecutor;
import com.bea.core.repackaged.springframework.scheduling.timer.DelegatingTimerTask;
import com.bea.core.repackaged.springframework.util.Assert;
import java.util.Timer;
import java.util.TimerTask;

public class TimerTaskExecutor
implements SchedulingTaskExecutor,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Timer timer;
    private int delay = 0;
    private boolean usingAnInternalTimer = false;

    public TimerTaskExecutor() {
    }

    public TimerTaskExecutor(Timer timer) {
        Assert.notNull(timer, "Timer must not be null");
        this.timer = timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void afterPropertiesSet() {
        if (this.timer == null) {
            this.logger.info((Object)"Initializing Timer");
            this.timer = this.createTimer();
            this.usingAnInternalTimer = true;
        }
    }

    protected Timer createTimer() {
        return new Timer(true);
    }

    public void execute(Runnable task) {
        Assert.notNull(this.timer, "timer is required");
        this.timer.schedule((TimerTask)new DelegatingTimerTask(task), this.delay);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        if (this.usingAnInternalTimer) {
            this.logger.info((Object)"Cancelling Timer");
            this.timer.cancel();
        }
    }
}

