/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.scripting.support;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.scripting.ScriptSource;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.FileCopyUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ResourceScriptSource
implements ScriptSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Resource resource;
    private long lastModified = -1L;
    private final Object lastModifiedMonitor = new Object();

    public ResourceScriptSource(Resource resource) {
        Assert.notNull(resource, "Resource must not be null");
        this.resource = resource;
    }

    public final Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptAsString() throws IOException {
        InputStreamReader reader;
        block6: {
            Object object = this.lastModifiedMonitor;
            synchronized (object) {
                this.lastModified = this.retrieveLastModifiedTime();
            }
            reader = null;
            try {
                reader = new FileReader(this.getResource().getFile());
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Could not open FileReader for " + this.resource + " - falling back to InputStreamReader"), (Throwable)ex);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(this.resource.getInputStream());
        }
        return FileCopyUtils.copyToString(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            return this.lastModified < 0L || this.retrieveLastModifiedTime() > this.lastModified;
        }
    }

    protected long retrieveLastModifiedTime() {
        try {
            return this.getResource().lastModified();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getResource() + " could not be resolved in the file system - " + "current timestamp not available for script modification check"), (Throwable)ex);
            }
            return 0L;
        }
    }

    public String suggestedClassName() {
        return StringUtils.stripFilenameExtension(this.getResource().getFilename());
    }

    public String toString() {
        return this.resource.toString();
    }
}

