/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.config;

import com.bea.core.repackaged.springframework.aop.config.AopNamespaceUtils;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.config.RuntimeBeanReference;
import com.bea.core.repackaged.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.bea.core.repackaged.springframework.beans.factory.support.RootBeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.xml.BeanDefinitionParser;
import com.bea.core.repackaged.springframework.beans.factory.xml.ParserContext;
import com.bea.core.repackaged.springframework.transaction.config.TxNamespaceUtils;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    public static final String TRANSACTION_ADVISOR_BEAN_NAME = "com.bea.core.repackaged.springframework.transaction.config.internalTransactionAdvisor";
    public static final String TRANSACTION_ASPECT_BEAN_NAME = "com.bea.core.repackaged.springframework.transaction.config.internalTransactionAspect";
    private static final String TRANSACTION_ASPECT_CLASS_NAME = "com.bea.core.repackaged.springframework.transaction.aspectj.AnnotationTransactionAspect";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor;

    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerTransactionAspect(element, parserContext);
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(element, parserContext);
        }
        return null;
    }

    private void registerTransactionAspect(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition(TRANSACTION_ASPECT_BEAN_NAME)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(TRANSACTION_ASPECT_CLASS_NAME);
            def.setFactoryMethodName("aspectOf");
            AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, def);
            parserContext.registerBeanComponent(new BeanComponentDefinition(def, TRANSACTION_ASPECT_BEAN_NAME));
        }
    }

    private static void registerTransactionManager(Element element, BeanDefinition def) {
        String transactionManagerName = element.hasAttribute("transaction-manager") ? element.getAttribute("transaction-manager") : DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        def.getPropertyValues().addPropertyValue(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, new RuntimeBeanReference(transactionManagerName));
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(Element element, ParserContext parserContext) {
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary(parserContext, element);
            if (!parserContext.getRegistry().containsBeanDefinition(AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME)) {
                RootBeanDefinition interceptorDef = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = AnnotationDrivenBeanDefinitionParser.class$("com.bea.core.repackaged.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor);
                interceptorDef.setSource(parserContext.extractSource(element));
                interceptorDef.setRole(2);
                AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, interceptorDef);
                Class sourceClass = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
                interceptorDef.getPropertyValues().addPropertyValue("transactionAttributeSource", new RootBeanDefinition(sourceClass));
                RootBeanDefinition advisorDef = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor == null ? (class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor = AnnotationDrivenBeanDefinitionParser.class$("com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor")) : class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor);
                advisorDef.setSource(parserContext.extractSource(element));
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().addPropertyValue("transactionInterceptor", interceptorDef);
                if (element.hasAttribute("order")) {
                    advisorDef.getPropertyValues().addPropertyValue("order", element.getAttribute("order"));
                }
                parserContext.registerBeanComponent(new BeanComponentDefinition(advisorDef, AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME));
            }
        }
    }
}

