/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeEditor;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSource;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import com.bea.core.repackaged.springframework.util.PatternMatchUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)NameMatchTransactionAttributeSource.class);
    private Map nameMap = new HashMap();

    public void setNameMap(Map nameMap) {
        Iterator it = nameMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            TransactionAttribute attr = null;
            if (entry.getValue() instanceof TransactionAttribute) {
                attr = (TransactionAttribute)entry.getValue();
            } else {
                TransactionAttributeEditor editor = new TransactionAttributeEditor();
                editor.setAsText(entry.getValue().toString());
                attr = (TransactionAttribute)editor.getValue();
            }
            this.addTransactionalMethod(name, attr);
        }
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        Iterator<Object> it = transactionAttributes.keySet().iterator();
        while (it.hasNext()) {
            String methodName = (String)it.next();
            String value = transactionAttributes.getProperty(methodName);
            tae.setAsText(value);
            TransactionAttribute attr = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(methodName, attr);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding transactional method [" + methodName + "] with attribute [" + attr + "]"));
        }
        this.nameMap.put(methodName, attr);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr == null) {
            String bestNameMatch = null;
            Iterator it = this.nameMap.keySet().iterator();
            while (it.hasNext()) {
                String mappedName = (String)it.next();
                if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
                attr = (TransactionAttribute)this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return attr;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameMatchTransactionAttributeSource)) {
            return false;
        }
        NameMatchTransactionAttributeSource otherTas = (NameMatchTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.nameMap, otherTas.nameMap);
    }

    public int hashCode() {
        return NameMatchTransactionAttributeSource.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.nameMap;
    }
}

