/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.RollbackRuleAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasLength(text)) {
            String[] tokens = StringUtils.commaDelimitedListToStringArray(text);
            RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
            for (int i = 0; i < tokens.length; ++i) {
                String token = StringUtils.trimWhitespace(tokens[i].trim());
                if (StringUtils.containsWhitespace(token)) {
                    throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + token + "]");
                }
                if (token.startsWith("PROPAGATION_")) {
                    attr.setPropagationBehaviorName(token);
                    continue;
                }
                if (token.startsWith("ISOLATION_")) {
                    attr.setIsolationLevelName(token);
                    continue;
                }
                if (token.startsWith("timeout_")) {
                    String value = token.substring("timeout_".length());
                    attr.setTimeout(Integer.parseInt(value));
                    continue;
                }
                if (token.equals("readOnly")) {
                    attr.setReadOnly(true);
                    continue;
                }
                if (token.startsWith("+")) {
                    attr.getRollbackRules().add(new NoRollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                if (token.startsWith("-")) {
                    attr.getRollbackRules().add(new RollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Invalid transaction attribute token: [" + token + "]");
            }
            this.setValue(attr);
        } else {
            this.setValue(null);
        }
    }
}

