/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.aopalliance.intercept.MethodInterceptor;
import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.springframework.transaction.PlatformTransactionManager;
import com.bea.core.repackaged.springframework.transaction.TransactionStatus;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAspectSupport;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSource;
import com.bea.core.repackaged.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import com.bea.core.repackaged.springframework.transaction.support.TransactionCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor,
Serializable {
    public TransactionInterceptor() {
    }

    public TransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributes(attributes);
    }

    public TransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributeSource(tas);
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        final TransactionAttribute txAttr = this.getTransactionAttributeSource().getTransactionAttribute(invocation.getMethod(), targetClass);
        final String joinpointIdentification = this.methodIdentification(invocation.getMethod());
        if (txAttr == null || !(this.getTransactionManager() instanceof CallbackPreferringPlatformTransactionManager)) {
            TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(txAttr, joinpointIdentification);
            Object retVal = null;
            try {
                try {
                    retVal = invocation.proceed();
                }
                catch (Throwable ex) {
                    this.completeTransactionAfterThrowing(txInfo, ex);
                    throw ex;
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.cleanupTransactionInfo(txInfo);
                throw throwable;
            }
            this.cleanupTransactionInfo(txInfo);
            this.commitTransactionAfterReturning(txInfo);
            return retVal;
        }
        try {
            Object result = ((CallbackPreferringPlatformTransactionManager)this.getTransactionManager()).execute(txAttr, new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus status) {
                    Object object;
                    TransactionAspectSupport.TransactionInfo txInfo = TransactionInterceptor.this.prepareTransactionInfo(txAttr, joinpointIdentification, status);
                    try {
                        object = invocation.proceed();
                        Object var6_5 = null;
                    }
                    catch (Throwable ex) {
                        ThrowableHolder throwableHolder;
                        try {
                            if (txAttr.rollbackOn(ex)) {
                                if (ex instanceof RuntimeException) {
                                    throw (RuntimeException)ex;
                                }
                                throw new ThrowableHolderException(ex);
                            }
                            throwableHolder = new ThrowableHolder(ex);
                            Object var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            TransactionInterceptor.this.cleanupTransactionInfo(txInfo);
                            throw throwable;
                        }
                        TransactionInterceptor.this.cleanupTransactionInfo(txInfo);
                        return throwableHolder;
                    }
                    TransactionInterceptor.this.cleanupTransactionInfo(txInfo);
                    return object;
                }
            });
            if (result instanceof ThrowableHolder) {
                throw ((ThrowableHolder)result).getThrowable();
            }
            return result;
        }
        catch (ThrowableHolderException ex) {
            throw ex.getCause();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.setTransactionManager((PlatformTransactionManager)ois.readObject());
        this.setTransactionAttributeSource((TransactionAttributeSource)ois.readObject());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getTransactionManager());
        oos.writeObject(this.getTransactionAttributeSource());
    }

    private static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable throwable) {
            super(throwable);
        }

        public String toString() {
            return this.getCause().toString();
        }
    }

    private static class ThrowableHolder {
        private final Throwable throwable;

        public ThrowableHolder(Throwable throwable) {
            this.throwable = throwable;
        }

        public final Throwable getThrowable() {
            return this.throwable;
        }
    }
}

