/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.springframework.aop.Pointcut;
import com.bea.core.repackaged.springframework.aop.framework.AbstractSingletonProxyFactoryBean;
import com.bea.core.repackaged.springframework.aop.support.DefaultPointcutAdvisor;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryUtils;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.ListableBeanFactory;
import com.bea.core.repackaged.springframework.transaction.PlatformTransactionManager;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSource;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionInterceptor;
import java.util.Properties;

public class TransactionProxyFactoryBean
extends AbstractSingletonProxyFactoryBean
implements FactoryBean,
BeanFactoryAware {
    private final TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
    private Pointcut pointcut;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionInterceptor.setTransactionManager(transactionManager);
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.transactionInterceptor.setTransactionAttributes(transactionAttributes);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionInterceptor.setTransactionAttributeSource(transactionAttributeSource);
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.transactionInterceptor.getTransactionManager() == null && beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            PlatformTransactionManager ptm = (PlatformTransactionManager)BeanFactoryUtils.beanOfTypeIncludingAncestors(lbf, PlatformTransactionManager.class);
            this.transactionInterceptor.setTransactionManager(ptm);
        }
    }

    protected Object createMainInterceptor() {
        this.transactionInterceptor.afterPropertiesSet();
        if (this.pointcut != null) {
            return new DefaultPointcutAdvisor(this.pointcut, this.transactionInterceptor);
        }
        return new TransactionAttributeSourceAdvisor(this.transactionInterceptor);
    }
}

