/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.jta;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.transaction.jta.UserTransactionAdapter;
import com.bea.core.repackaged.springframework.transaction.support.TransactionSynchronization;
import com.bea.core.repackaged.springframework.transaction.support.TransactionSynchronizationManager;
import com.bea.core.repackaged.springframework.util.Assert;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class SpringJtaSynchronizationAdapter
implements Synchronization {
    protected static final Log logger = LogFactory.getLog((Class)SpringJtaSynchronizationAdapter.class);
    private final TransactionSynchronization springSynchronization;
    private UserTransaction jtaTransaction;
    private boolean beforeCompletionCalled = false;

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization) {
        Assert.notNull(springSynchronization, "TransactionSynchronization must not be null");
        this.springSynchronization = springSynchronization;
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, UserTransaction jtaUserTransaction) {
        this(springSynchronization);
        if (jtaUserTransaction != null && !jtaUserTransaction.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = jtaUserTransaction;
        }
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, TransactionManager jtaTransactionManager) {
        this(springSynchronization);
        if (jtaTransactionManager != null && !jtaTransactionManager.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = new UserTransactionAdapter(jtaTransactionManager);
        }
    }

    public void beforeCompletion() {
        try {
            try {
                boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                this.springSynchronization.beforeCommit(readOnly);
            }
            catch (RuntimeException ex) {
                this.setRollbackOnlyIfPossible();
                throw ex;
            }
            catch (Error err) {
                this.setRollbackOnlyIfPossible();
                throw err;
            }
            Object var3_4 = null;
            this.beforeCompletionCalled = true;
            this.springSynchronization.beforeCompletion();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.beforeCompletionCalled = true;
            this.springSynchronization.beforeCompletion();
            throw throwable;
        }
    }

    private void setRollbackOnlyIfPossible() {
        if (this.jtaTransaction != null) {
            try {
                this.jtaTransaction.setRollbackOnly();
            }
            catch (UnsupportedOperationException ex) {
                logger.debug((Object)"JTA transaction handle does not support setRollbackOnly method - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.error((Object)"Could not set JTA transaction rollback-only", ex);
            }
        } else {
            logger.debug((Object)"No JTA transaction handle available and/or running on WebLogic - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion");
        }
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.springSynchronization.beforeCompletion();
        }
        switch (status) {
            case 3: {
                this.springSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.springSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.springSynchronization.afterCompletion(2);
            }
        }
    }
}

