/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.util;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class FileCopyUtils {
    private static final Log logger = LogFactory.getLog((Class)FileCopyUtils.class);
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File in, File out) throws IOException {
        Assert.notNull(in, "No input File specified");
        Assert.notNull(out, "No output File specified");
        return FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Assert.notNull(in, "No input byte array specified");
        Assert.notNull(out, "No output File specified");
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        FileCopyUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        Assert.notNull(in, "No input File specified");
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        Assert.notNull(in, "No InputStream specified");
        Assert.notNull(out, "No OutputStream specified");
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close InputStream", (Throwable)ex);
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close InputStream", (Throwable)ex);
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull(in, "No input byte array specified");
        Assert.notNull(out, "No OutputStream specified");
        try {
            out.write(in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close OutputStream", (Throwable)ex);
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        Assert.notNull(in, "No Reader specified");
        Assert.notNull(out, "No Writer specified");
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close Reader", (Throwable)ex);
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close Writer", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close Reader", (Throwable)ex);
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close Writer", (Throwable)ex);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, Writer out) throws IOException {
        Assert.notNull(in, "No input String specified");
        Assert.notNull(out, "No Writer specified");
        try {
            out.write(in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close Writer", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            logger.warn((Object)"Could not close Writer", (Throwable)ex);
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileCopyUtils.copy(in, (Writer)out);
        return out.toString();
    }
}

