/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.validation;

import com.bea.core.repackaged.springframework.beans.ConfigurablePropertyAccessor;
import com.bea.core.repackaged.springframework.beans.PropertyAccessorUtils;
import com.bea.core.repackaged.springframework.beans.PropertyEditorRegistry;
import com.bea.core.repackaged.springframework.validation.AbstractBindingResult;
import java.beans.PropertyEditor;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getPropertyAccessor();
    }

    protected String canonicalFieldName(String field) {
        return PropertyAccessorUtils.canonicalPropertyName(field);
    }

    public Class getFieldType(String field) {
        return this.getPropertyAccessor().getPropertyType(this.fixedField(field));
    }

    protected Object getActualFieldValue(String field) {
        return this.getPropertyAccessor().getPropertyValue(field);
    }

    protected Object formatFieldValue(String field, Object value) {
        PropertyEditor customEditor = this.getCustomEditor(field);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        return value;
    }

    protected PropertyEditor getCustomEditor(String field) {
        String fixedField = this.fixedField(field);
        Class type = this.getPropertyAccessor().getPropertyType(fixedField);
        return this.getPropertyAccessor().findCustomEditor(type, fixedField);
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

