/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.validation;

import com.bea.core.repackaged.springframework.beans.PropertyAccessException;
import com.bea.core.repackaged.springframework.context.support.DefaultMessageSourceResolvable;
import com.bea.core.repackaged.springframework.validation.BindingErrorProcessor;
import com.bea.core.repackaged.springframework.validation.BindingResult;
import com.bea.core.repackaged.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), missingField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), missingField, "", true, codes, arguments, "Field '" + missingField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyChangeEvent().getPropertyName();
        Object value = ex.getPropertyChangeEvent().getNewValue();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field, value, true, codes, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        String defaultMessage = field;
        return new Object[]{new DefaultMessageSourceResolvable(codes, defaultMessage)};
    }
}

