/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.api23.HttpSessionBindingEvent;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ChainedMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Listeners;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;

public abstract class AbstractHttpSessionModel
extends Base
implements HttpSessionModel,
Externalizable,
ExternalizableLite {
    public String[] STRING_ARRAY = new String[0];
    public static final int MAGIC_V350 = 1785231208;
    private static final Logger LOGGER = Logger.getLogger(AbstractHttpSessionModel.class.getName());
    private transient AbstractHttpSessionCollection m_collection;
    private transient HttpSession m_session;
    private String m_sId;
    private String m_sNewId;
    private boolean m_fAttributeListenerOptimization;
    private long m_ldtCreationTime;
    private long m_ldtLastAccessedTime;
    private long m_ldtLastFlushedTime;
    private int m_cMaxInactiveSeconds;
    private boolean m_fNew;
    private transient boolean m_fValid;
    private transient int m_nVersion;
    private boolean m_fLocal;
    private final transient AtomicInteger f_atomicRefs = new AtomicInteger(0);
    private transient Thread m_threadOwner;
    private transient Set<Thread> m_owningThreads;
    private transient boolean m_fModified;
    private transient Map m_mapAttributes;
    private Map m_mapAttributesActual = new SegmentedHashMap();
    private transient Map m_mapAttributesLocal;
    private boolean m_fActivateAttributes;
    private static Set s_setFailedSerClassNames = new HashSet();
    private boolean m_isSessionAccessDebugLoggingEnabled;
    private String m_sessionAccessDebugLoggingFilter;
    private boolean m_optimizeModifiedSessionFlush = Config.getBoolean((String)"coherence.session.optimizeModifiedSessions");
    public static final String CTX_OPTIMIZE_MODIFIED_SESSIONS = "coherence.session.optimizeModifiedSessions";

    public AbstractHttpSessionModel() {
    }

    public AbstractHttpSessionModel(AbstractHttpSessionCollection collection, HttpSession session, String sId) {
        long ldt = collection.getCurrentTime();
        this.m_sId = sId;
        this.m_fNew = true;
        this.m_fValid = true;
        this.m_fModified = true;
        this.m_fLocal = collection.getDistributionController() != null;
        this.m_ldtCreationTime = ldt;
        this.m_ldtLastAccessedTime = ldt;
        this.m_ldtLastFlushedTime = 0L;
        this.m_cMaxInactiveSeconds = collection.getDefaultMaxInactiveInterval();
        this.m_fAttributeListenerOptimization = collection.isEnableAttributeListenerOptimization();
        this.setCollection(collection);
        this.setHttpSession(session);
        if (this.m_isSessionAccessDebugLoggingEnabled) {
            this.logDebugSessionAccess("Created", null, null);
        }
    }

    @Override
    public Object getAttribute(String sName) {
        this.checkActive();
        sName = this.qualifyAttributeName(sName);
        AttributeHolder holder = (AttributeHolder)this.getAttributeMap().get(sName);
        Object oValue = null;
        if (holder != null) {
            oValue = holder.getValue();
        }
        if (this.m_isSessionAccessDebugLoggingEnabled) {
            this.logDebugSessionAccess("Get Attribute", sName, oValue);
        }
        return oValue;
    }

    @Override
    public String[] getAttributeNameArray() {
        this.checkActive();
        String[] asName = this.getAttributeMap().keySet().toArray(this.STRING_ARRAY);
        asName = this.extractAttributeNames(asName);
        return asName;
    }

    @Override
    public long getCreationTime() {
        this.checkValid();
        return this.m_ldtCreationTime;
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    public String getNewId() {
        return this.m_sNewId;
    }

    @Override
    public long getLastAccessedTime() {
        this.checkValid();
        return this.m_ldtLastAccessedTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        this.checkValid();
        return this.m_cMaxInactiveSeconds;
    }

    @Override
    public boolean isExpired() {
        this.checkValid();
        return this.isExpiredInternal(this.getCollection().getCurrentTime());
    }

    protected boolean isExpiredInternal(long currentTime) {
        int cMaxSeconds = this.m_cMaxInactiveSeconds;
        if (cMaxSeconds < 0) {
            return false;
        }
        long ldtAccessed = this.m_ldtLastAccessedTime;
        long ldtExpires = ldtAccessed + (long)cMaxSeconds * 1000L;
        return ldtExpires < currentTime;
    }

    @Override
    public boolean isNew() {
        this.checkValid();
        return this.m_fNew;
    }

    @Override
    public boolean isUsable() {
        return this.m_collection != null;
    }

    @Override
    public boolean isValid() {
        this.checkUsable();
        return this.m_fValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String sName) {
        block11: {
            boolean fLocked = this.obtainThreadOwnership();
            if (fLocked) {
                this.getCollection().recordMapLocksState("AHSM.removeAttribute()->obtainThreadOwnership():" + this.m_sId, "locked");
            }
            try {
                this.checkActive();
                sName = this.qualifyAttributeName(sName);
                AttributeHolder holder = (AttributeHolder)this.getAttributeMap().remove(sName);
                if (holder == null) break block11;
                try {
                    if (this.m_isSessionAccessDebugLoggingEnabled) {
                        Object value = null;
                        try {
                            value = holder.getValue();
                        }
                        catch (Exception e) {
                            this.logDebugSessionAccess("While getting the attribute value, got exception: " + e.toString(), sName, value);
                        }
                        this.logDebugSessionAccess("Removed Attribute", sName, value);
                    }
                    this.unbind(holder, false);
                }
                finally {
                    this.setModified(true);
                }
            }
            finally {
                if (fLocked) {
                    this.releaseThreadOwnership();
                    this.getCollection().removeMapLocksState("AHSM.removeAttribute()->obtainThreadOwnership():" + this.m_sId);
                }
            }
        }
    }

    @Override
    public void sessionReturned() {
        boolean fLocked = this.obtainThreadOwnership();
        if (fLocked) {
            this.getCollection().recordMapLocksState("AHSM.sessionReturned()->obtainThreadOwnership():" + this.m_sId, "locked");
        }
        try {
            this.checkValid();
            this.setModified(true);
            this.m_fNew = false;
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership();
                this.getCollection().removeMapLocksState("AHSM.sessionReturned()->obtainThreadOwnership():" + this.m_sId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String sName, Object oValue) {
        boolean fLocked = this.obtainThreadOwnership();
        if (fLocked) {
            this.getCollection().recordMapLocksState("AHSM.setAttribute()->obtainThreadOwnership():" + this.m_sId, "locked");
        }
        try {
            this.checkActive();
            AbstractHttpSessionModel.azzert((oValue != null ? 1 : 0) != 0);
            sName = this.qualifyAttributeName(sName);
            Map mapAttr = this.getAttributeMap();
            AttributeHolder holderOrig = (AttributeHolder)mapAttr.get(sName);
            AttributeHolder holderNew = this.instantiateAttributeHolder(sName, oValue);
            if (holderOrig != null) {
                holderNew.setLocal(holderOrig.isLocal());
                if (this.m_isSessionAccessDebugLoggingEnabled) {
                    this.logDebugSessionAccess("Update Attribute", sName, oValue);
                }
            } else if (this.m_isSessionAccessDebugLoggingEnabled) {
                this.logDebugSessionAccess("Set Attribute", sName, oValue);
            }
            mapAttr.put(sName, holderNew);
            try {
                if (!this.skipListeners(holderOrig, holderNew)) {
                    this.bind(holderOrig, holderNew);
                }
            }
            finally {
                this.setModified(true);
            }
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership();
                this.getCollection().removeMapLocksState("AHSM.setAttribute()->obtainThreadOwnership():" + this.m_sId);
            }
        }
    }

    private boolean skipListeners(AttributeHolder holderOrig, AttributeHolder holderNew) {
        if (this.m_fAttributeListenerOptimization) {
            return holderOrig != null && (holderOrig.getValue() == holderNew.getValue() || holderOrig.getValue() != null && holderOrig.getValue().equals(holderNew.getValue()));
        }
        return false;
    }

    @Override
    public void setMaxInactiveInterval(int cSeconds) {
        boolean fLocked = this.obtainThreadOwnership();
        if (fLocked) {
            this.getCollection().recordMapLocksState("AHSM.setMaxInactiveInterval()->obtainThreadOwnership():" + this.m_sId, "locked");
        }
        try {
            this.checkValid();
            this.m_cMaxInactiveSeconds = cSeconds;
            this.setModified(true);
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership();
                this.getCollection().removeMapLocksState("AHSM.setMaxInactiveInterval()->obtainThreadOwnership():" + this.m_sId);
            }
        }
    }

    @Override
    public void touch() {
        boolean fLocked = this.obtainThreadOwnership();
        if (fLocked) {
            this.getCollection().recordMapLocksState("AHSM.touch()->obtainThreadOwnership():" + this.m_sId, "locked");
        }
        try {
            this.checkValid();
            this.setLastAccessedTime(this.getCollection().getCurrentTime());
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership();
                this.getCollection().removeMapLocksState("AHSM.touch()->obtainThreadOwnership():" + this.m_sId);
            }
        }
    }

    public String toString() {
        return "AbstractHttpSessionModel\n" + AbstractHttpSessionModel.indentString((String)this.getDescription(), (String)"  ");
    }

    protected AbstractHttpSessionCollection getCollection() {
        return this.m_collection;
    }

    protected void setCollection(AbstractHttpSessionCollection collection) {
        if (collection != null) {
            this.m_isSessionAccessDebugLoggingEnabled = collection.isEnabledSessionAccessDebugLogging();
            this.m_sessionAccessDebugLoggingFilter = collection.getSessionAccessDebugLoggingFilter();
        }
        this.m_collection = collection;
    }

    protected HttpSession getHttpSession() {
        HttpSession session = this.m_session;
        if (session == null) {
            this.m_session = session = (HttpSession)this.getCollection().getActiveCache().get((Object)this.getId());
        }
        return session;
    }

    protected void setHttpSession(HttpSession session) {
        if (session == null) {
            this.getCollection().getActiveCache().remove((Object)this.getId());
        } else {
            this.getCollection().getActiveCache().put((Object)this.getId(), (Object)session);
        }
        this.m_session = session;
    }

    protected void setId(String sId) {
        this.m_sId = sId;
    }

    protected void setNewId(String sNewId) {
        this.m_sNewId = sNewId;
    }

    protected void setValid(boolean fValid) {
        this.m_fValid = fValid;
    }

    protected int getVersion() {
        return this.m_nVersion;
    }

    protected void setVersion(int nVersion) {
        if (nVersion < 0) {
            throw new IllegalArgumentException();
        }
        this.m_nVersion = nVersion;
    }

    protected boolean isLocal() {
        return this.m_fLocal;
    }

    protected Map getAttributeMap() {
        Map map = this.m_mapAttributes;
        if (map == null) {
            if (this.isLocal()) {
                map = this.getLocalAttributeMap();
            } else if (this.getCollection().isAllowLocalAttributes()) {
                Map mapLocal = this.getLocalAttributeMap();
                Map mapActual = this.getActualAttributeMap();
                map = new ChainedMap(mapLocal, mapActual){

                    public Object put(Object oKey, Object oValue) {
                        Object oValueOld = this.remove(oKey);
                        AttributeHolder holder = (AttributeHolder)oValue;
                        Map map = holder.isLocal() ? this.m_mapFirst : this.m_mapSecond;
                        map.put(oKey, oValue);
                        return oValueOld;
                    }
                };
            } else {
                AbstractHttpSessionModel.azzert((this.getCollection().getDistributionController() == null ? 1 : 0) != 0, (String)"distribution controller must enforce the local attributes support");
                map = this.getActualAttributeMap();
            }
            this.m_mapAttributes = map;
        }
        return map;
    }

    protected Map getActualAttributeMap() {
        return this.m_mapAttributesActual;
    }

    protected Map getLocalAttributeMap() {
        Map mapLocal = this.m_mapAttributesLocal;
        if (mapLocal == null) {
            this.m_mapAttributesLocal = mapLocal = this.getCollection().ensureLocalAttributesCache(this.getId());
        }
        return mapLocal;
    }

    protected boolean isActive() {
        return this.getHttpSession() != null;
    }

    protected boolean isActivatableAttributes() {
        return this.m_fActivateAttributes;
    }

    protected void setActivatableAttributes(boolean fActivatable) {
        this.m_fActivateAttributes = fActivatable;
    }

    protected void activate(HttpSession session) {
        if (!this.isActive()) {
            Throwable eUnhandled;
            block10: {
                this.setHttpSession(session);
                eUnhandled = null;
                Map mapAttributes = this.getAttributeMap();
                if (this.isActivatableAttributes() && !mapAttributes.isEmpty()) {
                    boolean fAnyListeners = false;
                    HttpSessionEvent evt = null;
                    for (AttributeHolder holder : mapAttributes.values()) {
                        boolean fStrict;
                        Object oValue;
                        if (!holder.isActivationListener()) continue;
                        try {
                            oValue = holder.getValue();
                        }
                        catch (WrapperException e) {
                            fStrict = this.getCollection().isStrict();
                            SessionHelper.logEventException((RuntimeException)((Object)e), "sessionDidActivate(" + this.getId() + ')', !fStrict);
                            if (!fStrict) continue;
                            eUnhandled = e;
                            break block10;
                        }
                        fAnyListeners = true;
                        if (evt == null) {
                            evt = new HttpSessionEvent(session);
                        }
                        try {
                            ((HttpSessionActivationListener)oValue).sessionDidActivate(evt);
                        }
                        catch (EventDeathException e) {
                        }
                        catch (RuntimeException e) {
                            fStrict = this.getCollection().isStrict();
                            SessionHelper.logEventException(e, "sessionDidActivate(" + this.getId() + ')', !fStrict);
                            if (!fStrict) continue;
                            eUnhandled = e;
                            break block10;
                        }
                    }
                    this.setActivatableAttributes(fAnyListeners);
                }
            }
            if (eUnhandled != null) {
                throw eUnhandled;
            }
        }
    }

    protected void passivate() {
        if (this.isActive()) {
            Throwable eUnhandled;
            block10: {
                eUnhandled = null;
                Map mapAttributes = this.getAttributeMap();
                if (this.isActivatableAttributes() && !mapAttributes.isEmpty()) {
                    boolean fAnyListeners = false;
                    HttpSessionEvent evt = null;
                    for (AttributeHolder holder : mapAttributes.values()) {
                        boolean fStrict;
                        Object oValue;
                        if (!holder.isActivationListener()) continue;
                        try {
                            oValue = holder.getValue();
                        }
                        catch (WrapperException e) {
                            fStrict = this.getCollection().isStrict();
                            SessionHelper.logEventException((RuntimeException)((Object)e), "sessionWillPassivate(" + this.getId() + ')', !fStrict);
                            if (!fStrict) continue;
                            eUnhandled = e;
                            break block10;
                        }
                        fAnyListeners = true;
                        if (evt == null) {
                            evt = new HttpSessionEvent(this.getHttpSession());
                        }
                        try {
                            ((HttpSessionActivationListener)oValue).sessionWillPassivate(evt);
                        }
                        catch (EventDeathException e) {
                        }
                        catch (RuntimeException e) {
                            fStrict = this.getCollection().isStrict();
                            SessionHelper.logEventException(e, "sessionWillPassivate(" + this.getId() + ')', !fStrict);
                            if (!fStrict) continue;
                            eUnhandled = e;
                            break block10;
                        }
                    }
                    this.setActivatableAttributes(fAnyListeners);
                }
            }
            this.setHttpSession(null);
            if (eUnhandled != null) {
                throw eUnhandled;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(AttributeHolder holderOld, AttributeHolder holderNew) {
        block22: {
            try {
                RuntimeException eUnhandled;
                block24: {
                    boolean callListenerForOldValue;
                    HttpSessionBindingEvent evtNew;
                    HttpSessionBindingEvent evtOld;
                    String sName;
                    boolean fListeners;
                    Listeners listeners;
                    block25: {
                        Object oNew;
                        boolean fStrict;
                        boolean fBindingNew;
                        block23: {
                            Object oOld;
                            if (holderNew.isActivationListener()) {
                                this.setActivatableAttributes(true);
                            }
                            listeners = this.getCollection().getHttpSessionAttributeListeners();
                            boolean fBindingOld = holderOld != null && holderOld.isBindingListener();
                            fBindingNew = holderNew.isBindingListener();
                            boolean bl = fListeners = !listeners.isEmpty();
                            if (!fBindingOld && !fBindingNew && !fListeners) break block22;
                            sName = this.extractAttributeName(holderNew.getName());
                            evtOld = null;
                            evtNew = null;
                            eUnhandled = null;
                            boolean bl2 = callListenerForOldValue = (fBindingOld || fListeners) && this.shallCallListener(holderOld);
                            if (fBindingOld && callListenerForOldValue && (oOld = (evtOld = new HttpSessionBindingEvent(this.getHttpSession(), sName, holderOld)).getValue()) instanceof HttpSessionBindingListener) {
                                try {
                                    ((HttpSessionBindingListener)oOld).valueUnbound((javax.servlet.http.HttpSessionBindingEvent)evtOld);
                                }
                                catch (EventDeathException eventDeathException) {
                                }
                                catch (RuntimeException e) {
                                    fStrict = this.getCollection().isStrict();
                                    SessionHelper.logEventException(e, "HttpSessionBindingListener.valueUnbound(" + this.getId() + ", " + sName + ')', !fStrict);
                                    if (!fStrict) break block23;
                                    eUnhandled = e;
                                    break block24;
                                }
                            }
                        }
                        if (fBindingNew && (oNew = (evtNew = new HttpSessionBindingEvent(this.getHttpSession(), sName, holderNew)).getValue()) instanceof HttpSessionBindingListener) {
                            try {
                                ((HttpSessionBindingListener)oNew).valueBound((javax.servlet.http.HttpSessionBindingEvent)evtNew);
                            }
                            catch (EventDeathException e) {
                                break block24;
                            }
                            catch (RuntimeException e) {
                                fStrict = this.getCollection().isStrict();
                                SessionHelper.logEventException(e, "HttpSessionBindingListener.valueBound(" + this.getId() + ", " + sName + ')', !fStrict);
                                if (!fStrict) break block25;
                                eUnhandled = e;
                                break block24;
                            }
                        }
                    }
                    if (fListeners) {
                        HttpSessionBindingEvent evt;
                        String sAction;
                        boolean fAdded;
                        boolean bl = fAdded = holderOld == null || !callListenerForOldValue;
                        if (fAdded) {
                            sAction = "attributeAdded";
                            evt = evtNew == null ? new HttpSessionBindingEvent(this.getHttpSession(), sName, holderNew) : evtNew;
                        } else {
                            sAction = "attributeReplaced";
                            evt = evtOld == null ? new HttpSessionBindingEvent(this.getHttpSession(), sName, holderOld) : evtOld;
                        }
                        EventListener[] alisteners = listeners.listeners();
                        int c = alisteners.length;
                        for (int i = 0; i < c; ++i) {
                            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)alisteners[i];
                            try {
                                if (fAdded) {
                                    listener.attributeAdded((javax.servlet.http.HttpSessionBindingEvent)evt);
                                    continue;
                                }
                                listener.attributeReplaced((javax.servlet.http.HttpSessionBindingEvent)evt);
                                continue;
                            }
                            catch (EventDeathException e) {
                                break;
                            }
                            catch (RuntimeException e) {
                                boolean fStrict = this.getCollection().isStrict();
                                SessionHelper.logEventException(e, "HttpSessionAttributeListener." + sAction + '(' + this.getId() + ", " + sName + ')', !fStrict);
                                if (!fStrict) continue;
                                eUnhandled = e;
                                break;
                            }
                        }
                    }
                }
                if (eUnhandled != null) {
                    throw eUnhandled;
                }
            }
            finally {
                if (holderOld != null) {
                    holderOld.onUnbound(true, false);
                }
                holderNew.onBound(holderOld);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(AttributeHolder holder, boolean fAll) {
        block15: {
            try {
                RuntimeException eUnhandled;
                block16: {
                    HttpSessionBindingEvent evt;
                    String sName;
                    boolean fListeners;
                    Listeners listeners;
                    block17: {
                        Object oValue;
                        listeners = this.getCollection().getHttpSessionAttributeListeners();
                        boolean fBinding = holder.isBindingListener();
                        boolean bl = fListeners = !listeners.isEmpty();
                        if (!fBinding && !fListeners || !this.shallCallListener(holder)) break block15;
                        sName = this.extractAttributeName(holder.getName());
                        evt = new HttpSessionBindingEvent(this.getHttpSession(), sName, holder);
                        eUnhandled = null;
                        if (fBinding && (oValue = evt.getValue()) instanceof HttpSessionBindingListener) {
                            try {
                                ((HttpSessionBindingListener)oValue).valueUnbound((javax.servlet.http.HttpSessionBindingEvent)evt);
                            }
                            catch (EventDeathException e) {
                                break block16;
                            }
                            catch (RuntimeException e) {
                                AbstractHttpSessionCollection collection = this.getCollection();
                                boolean fStrict = collection.isStrict();
                                if (collection.logInvalidationExceptions()) {
                                    SessionHelper.logEventException(e, "HttpSessionBindingListener.valueUnbound(" + this.getId() + ", " + sName + ')', !fStrict);
                                }
                                if (!fStrict) break block17;
                                eUnhandled = e;
                                break block16;
                            }
                        }
                    }
                    if (fListeners) {
                        EventListener[] alisteners = listeners.listeners();
                        for (int i = alisteners.length - 1; i >= 0; --i) {
                            try {
                                ((HttpSessionAttributeListener)alisteners[i]).attributeRemoved((javax.servlet.http.HttpSessionBindingEvent)evt);
                                continue;
                            }
                            catch (EventDeathException e) {
                                break;
                            }
                            catch (RuntimeException e) {
                                AbstractHttpSessionCollection collection = this.getCollection();
                                boolean fStrict = collection.isStrict();
                                if (collection.logInvalidationExceptions()) {
                                    SessionHelper.logEventException(e, "HttpSessionAttributeListener.attributeRemoved(" + this.getId() + ", " + sName + ')', !fStrict);
                                }
                                if (!fStrict) continue;
                                eUnhandled = e;
                                break;
                            }
                        }
                    }
                }
                if (eUnhandled != null) {
                    throw eUnhandled;
                }
            }
            finally {
                holder.onUnbound(false, fAll);
            }
        }
    }

    protected void unbind() {
        RuntimeException eFirst = null;
        Map mapAttr = this.getAttributeMap();
        int cTries = mapAttr.size() + 1;
        while (!mapAttr.isEmpty() && cTries-- > 0) {
            try {
                Iterator iter = mapAttr.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    AttributeHolder holder = (AttributeHolder)entry.getValue();
                    iter.remove();
                    this.unbind(holder, true);
                }
            }
            catch (ConcurrentModificationException iter) {
            }
            catch (RuntimeException e) {
                if (eFirst != null) continue;
                eFirst = e;
            }
        }
        if (eFirst != null) {
            throw eFirst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logAttributeSerializationFailure(AttributeHolder holder, Throwable e) {
        Object o = holder.getInternalValue();
        if (o != null) {
            Set setFailedSerClassNames;
            Set set = setFailedSerClassNames = s_setFailedSerClassNames;
            synchronized (set) {
                String sClass = o.getClass().getName();
                if (setFailedSerClassNames.add(sClass) && LOGGER.isLoggable(Level.WARNING)) {
                    String sName = this.extractAttributeName(holder.getName());
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failed to serialize the ").append(sName).append(" attribute (of type \"").append(sClass);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        sb.append("\") for session ").append(this.getId());
                    }
                    if (!(e instanceof BufferOverflowException)) {
                        try {
                            String sValue = holder.getValue().toString();
                            if (sValue != null) {
                                sb.append("\nThe unserializable attribute value toString(): \"").append(AbstractHttpSessionModel.indentString((String)sValue, (String)"    ", (boolean)false)).append('\"');
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    sb.append(".\nThe following exception occurred during its serialization: ").append(e).append('\n').append(AbstractHttpSessionModel.getStackTrace((Throwable)e)).append("\n(Future serialization exceptions for this class will not be reported.)");
                    LOGGER.log(Level.WARNING, sb.toString());
                }
            }
        }
    }

    protected void discard() {
        if (this.m_isSessionAccessDebugLoggingEnabled) {
            this.logDebugSessionAccess("Invalidated", null, null);
        }
        this.setHttpSession(null);
        this.setCollection(null);
        this.f_atomicRefs.set(0);
        this.m_threadOwner = null;
        this.m_mapAttributes = null;
        this.m_mapAttributesLocal = null;
        this.m_fValid = false;
    }

    protected boolean isModified() {
        return this.m_fModified;
    }

    protected void setModified(boolean fModified) {
        this.m_fModified = fModified;
    }

    protected void setLastAccessedTime(long ldtLastAccessedTime) {
        this.m_ldtLastAccessedTime = ldtLastAccessedTime;
    }

    protected long getLastFlushedTime() {
        return this.m_ldtLastFlushedTime;
    }

    protected void setLastFlushedTime(long ldtLastFlushedTime) {
        this.m_ldtLastFlushedTime = ldtLastFlushedTime;
    }

    protected boolean isLastAccessTimeFlushRequired() {
        return !this.isModified() && this.getCollection().getCurrentTime() - this.getLastFlushedTime() > (long)Math.max(10, this.getMaxInactiveInterval() >>> 6) * 1000L;
    }

    protected Set<Thread> getEnteredThreads() {
        return this.m_owningThreads;
    }

    protected void addEnteredThread() {
        if (this.m_owningThreads == null) {
            this.m_owningThreads = Collections.synchronizedSet(new HashSet());
        }
        this.m_owningThreads.add(Thread.currentThread());
    }

    protected void removeEnteredThread() {
        this.m_owningThreads.remove(Thread.currentThread());
    }

    protected Thread getThreadOwner() {
        return this.m_threadOwner;
    }

    protected boolean obtainThreadOwnership() {
        return this.getCollection().obtainThreadOwnership(this.getId());
    }

    protected void releaseThreadOwnership() {
        if (this.getCollection() == null) {
            LOGGER.log(Level.WARNING, "releaseThreadOwnership session = " + this.getId() + " was unable to releaseThreadOwnership.");
            LOGGER.log(Level.INFO, Base.getStackTrace());
        } else {
            this.getCollection().releaseThreadOwnership(this.getId());
        }
    }

    protected boolean isOwnedByThisThread() {
        if (this.getReferenceCount() == 0) {
            return false;
        }
        if (this.getCollection().isThreadLockingEnforced()) {
            return this.m_threadOwner == Thread.currentThread();
        }
        return true;
    }

    @Override
    public int getReferenceCount() {
        return this.f_atomicRefs.get();
    }

    public void resetReferenceCount() {
        this.f_atomicRefs.set(0);
    }

    protected void enter() {
        if (this.getCollection().isThreadLockingEnforced()) {
            Thread threadCurrent = Thread.currentThread();
            if (this.m_threadOwner == null) {
                this.m_threadOwner = threadCurrent;
                this.f_atomicRefs.set(1);
            } else {
                AbstractHttpSessionModel.azzert((this.m_threadOwner == threadCurrent ? 1 : 0) != 0);
                this.f_atomicRefs.incrementAndGet();
            }
        } else {
            this.f_atomicRefs.incrementAndGet();
        }
    }

    protected void exit() {
        int cRefs = this.f_atomicRefs.get();
        while (cRefs > 0) {
            if (!this.f_atomicRefs.compareAndSet(cRefs, cRefs - 1)) continue;
            if (cRefs != 1) break;
            this.m_threadOwner = null;
            break;
        }
    }

    protected void flush() {
        AbstractHttpSessionCollection collection = this.getCollection();
        String sId = this.getId();
        boolean fLocal = this.isLocal();
        if (fLocal) {
            HttpSessionCollection.SessionDistributionController controller = collection.getDistributionController();
            AbstractHttpSessionModel.azzert((controller != null ? 1 : 0) != 0, (String)"local sessions are unsupported without a session distribution controller");
            if (controller.isSessionDistributed(this)) {
                AbstractHttpSessionCollection.removeBlind((Map)collection.getLocalCache(), sId);
                this.m_mapAttributes = null;
                this.m_fLocal = false;
                fLocal = false;
            }
        }
        if (!fLocal && !collection.isStuck(sId)) {
            this.passivate();
        }
        boolean fUpdateTimestampOnly = this.isLastAccessTimeFlushRequired();
        boolean isModified = this.getCollection().isEnableSuspectAttributes() && this.isAnyAttributeSuspect() || this.isModified();
        boolean bl = fUpdateTimestampOnly = fUpdateTimestampOnly && !isModified;
        if (fUpdateTimestampOnly || isModified) {
            this.flushAttributesAndPutModel(fLocal, fUpdateTimestampOnly);
        }
        this.m_sNewId = null;
    }

    private boolean isAnyAttributeSuspect() {
        for (AttributeHolder holder : this.getAttributeMap().values()) {
            if (!holder.isSuspect()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAttributesAndPutModel(boolean fLocal, boolean fUpdateTimestampOnly) {
        AbstractHttpSessionCollection collection = this.getCollection();
        boolean fLogFlush = false;
        Iterator iter = this.getAttributeMap().values().iterator();
        while (iter.hasNext()) {
            try {
                AttributeHolder holder = (AttributeHolder)iter.next();
                holder.flush();
                fLogFlush |= this.m_isSessionAccessDebugLoggingEnabled && this.doLogAttribute(holder.getName());
            }
            catch (Exception e) {
                iter.remove();
            }
        }
        this.setLastFlushedTime(collection.getCurrentTime());
        if (fLogFlush) {
            LOGGER.log(Level.INFO, "Flushed recent set attribute(s) on session: " + this.getId() + " at " + this.getLastFlushedTime());
        }
        try {
            if (fUpdateTimestampOnly && !fLocal) {
                collection.getCacheDelegator().updateModelTimestamp(this);
            } else if (fLocal || collection.isAppLockingEnforced() || !collection.isSessionLockingEnforced() && this.m_optimizeModifiedSessionFlush) {
                collection.getCacheDelegator().putModel(this);
            } else {
                collection.getCacheDelegator().optimisticModelUpdate(this);
            }
        }
        finally {
            this.setModified(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        throw new UnsupportedOperationException("only ExternalizableLite serialization is supported for session models");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("only ExternalizableLite serialization is supported for session models");
    }

    public void readExternal(DataInput in) throws IOException {
        if (this.m_sId != null) {
            throw new NotActiveException("deserialization cannot occur because session object is not in an initial state");
        }
        int nMagic = in.readInt();
        if (nMagic != 1785231208) {
            throw new InvalidClassException("Session management version conflict; the Coherence*Web cluster must be upgraded to a consistent version.");
        }
        this.m_ldtLastAccessedTime = in.readLong();
        this.m_nVersion = in.readInt();
        this.m_ldtLastFlushedTime = in.readLong();
        this.m_ldtCreationTime = in.readLong();
        this.m_cMaxInactiveSeconds = in.readInt();
        this.m_fLocal = in.readBoolean();
        this.m_fNew = in.readBoolean();
        this.m_sId = ExternalizableHelper.readUTF((DataInput)in);
        this.readAttributes(in);
        this.setValid(true);
    }

    public void writeExternal(DataOutput out) throws IOException {
        if (this.m_sId == null) {
            throw new NotActiveException("serialization cannot occur because session object is not configured");
        }
        WrapperDataOutputStream outWrapper = new WrapperDataOutputStream(out);
        outWrapper.writeInt(1785231208);
        outWrapper.writeLong(this.m_ldtLastAccessedTime);
        outWrapper.writeInt(this.m_nVersion);
        outWrapper.writeLong(this.m_ldtLastFlushedTime);
        outWrapper.writeLong(this.m_ldtCreationTime);
        outWrapper.writeInt(this.m_cMaxInactiveSeconds);
        outWrapper.writeBoolean(this.m_fLocal);
        outWrapper.writeBoolean(this.m_fNew);
        ExternalizableHelper.writeUTF((DataOutput)outWrapper, (String)this.m_sId);
        this.writeAttributes((DataOutput)outWrapper);
        this.setModified(false);
        this.getCollection().onModelUpdate((int)outWrapper.getBytesWritten());
    }

    protected void readAttributes(DataInput in) throws IOException {
        boolean fAnyListeners = false;
        int cEntries = ExternalizableHelper.readInt((DataInput)in);
        if (cEntries > 0) {
            HashMap<String, AttributeHolder> mapAttributes = new HashMap<String, AttributeHolder>();
            for (int i = 0; i < cEntries; ++i) {
                if (!in.readBoolean()) continue;
                AttributeHolder holder = this.instantiateAttributeHolder();
                holder.readExternal(in);
                mapAttributes.put(holder.getName(), holder);
                fAnyListeners |= holder.isActivationListener();
            }
            this.getActualAttributeMap().putAll(mapAttributes);
        }
        this.setActivatableAttributes(fAnyListeners);
    }

    protected void writeAttributes(DataOutput out) throws IOException {
        Object[] aoHolder = this.getActualAttributeMap().values().toArray();
        int cHolders = aoHolder.length;
        ExternalizableHelper.writeInt((DataOutput)out, (int)cHolders);
        for (int i = 0; i < cHolders; ++i) {
            AttributeHolder holder = (AttributeHolder)aoHolder[i];
            boolean fValid = true;
            try {
                holder.prepareWrite();
            }
            catch (Exception e) {
                this.logAttributeSerializationFailure(holder, e);
                fValid = false;
            }
            out.writeBoolean(fValid);
            if (!fValid) continue;
            try {
                holder.writeExternal(out);
                continue;
            }
            catch (IOException e) {
                this.logAttributeSerializationFailure(holder, e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDescription() {
        boolean fUsable = this.isUsable();
        boolean fLocked = false;
        if (fUsable && (fLocked = this.obtainThreadOwnership())) {
            this.getCollection().recordMapLocksState("AHSM.getDescription()->obtainThreadOwnership():" + this.m_sId, "locked");
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Collection is ").append(fUsable ? "usable" : "not usable").append("\nHttpSession is ").append(fUsable ? (this.getHttpSession() == null ? "passivated" : "active") : "not usable").append("\nId=").append(this.getId()).append("\nLocal=").append(this.isLocal()).append("\nVersion=").append(this.getVersion());
            if (fUsable) {
                sb.append("\nCreationTime=").append(AbstractHttpSessionModel.formatDateTime((long)this.getCreationTime())).append("\nLastAccessedTime=").append(this.getLastAccessedTime()).append("\nLastFlushedTime=").append(this.getLastFlushedTime()).append("\nMaxInactiveInterval=").append(this.getMaxInactiveInterval()).append("\nExpired=").append(this.isExpired()).append("\nNew=").append(this.isNew()).append("\nValid=").append(this.isValid()).append("\nActivatable Attributes=").append(this.isActivatableAttributes());
            }
            if (fUsable && this.isActive()) {
                sb.append("\nAttributes[]=");
                for (String sName : this.getAttributeNameArray()) {
                    sb.append('\n').append(AbstractHttpSessionModel.indentString((String)String.valueOf(sName), (String)"  ", (boolean)true)).append('=').append(AbstractHttpSessionModel.indentString((String)String.valueOf(this.getAttribute(sName)), (String)"    ", (boolean)false));
                }
            }
            if (fUsable) {
                sb.append("\nModified=").append(this.isModified()).append("\nThreadOwner=").append(this.m_threadOwner).append("\nReferenceCount=").append(this.f_atomicRefs.get()).append("\nOwnedByThisThread=").append(this.isOwnedByThisThread());
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership();
                this.getCollection().removeMapLocksState("AHSM.getDescription()->obtainThreadOwnership():" + this.m_sId);
            }
        }
    }

    protected void checkActive() {
        this.checkValid();
        if (!this.isActive()) {
            throw new IllegalStateException("session is not in a 'active' state (id=" + this.m_sId + ')');
        }
    }

    protected void checkValid() {
        this.checkUsable();
        if (!this.m_fValid) {
            throw new IllegalStateException("session is not in a 'valid' state (id=" + this.m_sId + ')');
        }
    }

    protected void checkUsable() {
        if (this.m_collection == null) {
            throw new IllegalStateException("session is not in a 'usable' state (id=" + this.m_sId + ')');
        }
    }

    protected String qualifyAttributeName(String sAttribute) {
        HttpSessionCollection.AttributeScopeController controller = this.getCollection().getScopeController();
        return controller == null ? sAttribute : controller.qualifyAttributeName(sAttribute);
    }

    protected String extractAttributeName(String sAttribute) {
        HttpSessionCollection.AttributeScopeController controller = this.getCollection().getScopeController();
        return controller == null ? sAttribute : controller.extractAttributeName(sAttribute);
    }

    protected String[] extractAttributeNames(String[] asAttribute) {
        HttpSessionCollection.AttributeScopeController controller;
        int cAttribute;
        int n = cAttribute = asAttribute == null ? 0 : asAttribute.length;
        if (cAttribute > 0 && (controller = this.getCollection().getScopeController()) != null) {
            int c = 0;
            for (int i = 0; i < cAttribute; ++i) {
                asAttribute[c] = controller.extractAttributeName(asAttribute[i]);
                if (asAttribute[c] == null) continue;
                ++c;
            }
            if (c < cAttribute) {
                String[] as = new String[c];
                System.arraycopy(asAttribute, 0, as, 0, c);
                asAttribute = as;
            }
        }
        return asAttribute;
    }

    private boolean shallCallListener(AttributeHolder holderOld) {
        if (this.getCollection().isStrict()) {
            return true;
        }
        try {
            return holderOld != null && holderOld.getValue() != null;
        }
        catch (WrapperException e) {
            return false;
        }
    }

    protected AttributeHolder instantiateAttributeHolder() {
        return new AttributeHolder(this);
    }

    protected AttributeHolder instantiateAttributeHolder(String sName, Object oValue) {
        return new AttributeHolder(sName, oValue, this);
    }

    public static boolean isImmutable(Object o) {
        if (o instanceof Number) {
            return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof BigDecimal || o instanceof BigInteger;
        }
        return o instanceof String || o instanceof Binary || o instanceof Boolean || o instanceof Character;
    }

    private void logDebugSessionAccess(String action, String sName, Object oValue) {
        if (sName != null && this.doLogAttribute(sName)) {
            LOGGER.log(Level.INFO, "SESSION " + action + " " + sName + "=" + oValue + " SessionId=" + this.getId());
        }
    }

    private boolean doLogAttribute(String sName) {
        String[] asAttributes = this.m_sessionAccessDebugLoggingFilter.split(",");
        boolean fInclude = false;
        boolean fMatch = false;
        int c = asAttributes.length;
        for (int i = 0; !(i >= c || fMatch && fInclude); ++i) {
            String sAttributeFilter = asAttributes[i].trim();
            if ("*".equals(sAttributeFilter)) {
                fInclude = true;
                continue;
            }
            if (fMatch || !sName.contains(sAttributeFilter)) continue;
            fMatch = true;
        }
        return fMatch == fInclude;
    }
}

