/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.DefaultCacheDelegator;
import com.tangosol.coherence.servlet.HttpSessionCollectionConfiguration;
import com.tangosol.coherence.servlet.RandomHttpSessionIdGenerator;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperConfiguration;
import com.tangosol.coherence.servlet.SplitSessionCollectionConfiguration;
import com.tangosol.coherence.servlet.ValidatingConfiguration;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.run.xml.XmlElement;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements SessionHelperConfiguration,
HttpSessionCollectionConfiguration,
SplitSessionCollectionConfiguration,
Serializable {
    private static final String INCONSISTENCY_LEAD = "Incompatibilities were detected between this configuration and that of other nodes in the system. Please check the setting of the following Coherence Web configuration parameter(s): ";
    private static final Logger LOGGER = Logger.getLogger(ConfigurationImpl.class.getName());
    private final String applicationName;
    private final int versionMajor;
    private final int versionMinor;
    private final String cacheConfigurationPath;
    private final boolean clusterOwned;
    private final boolean contextClustered;
    private final boolean sessionContextEnabled;
    private final int asyncExitDelayMillis;
    private final int shutdownDelaySeconds;
    private final boolean sessionIdCookieEnabled;
    private final String sessionIdCookieName;
    private final String sessionIdCookieDomain;
    private final String sessionIdCookiePath;
    private final int sessionIdCookieMaxAgeSeconds;
    private final boolean sessionIdCookieSecure;
    private final boolean sessionIdCookieHttpOnly;
    private final boolean sessionIdEncodingEnabled;
    private final String sessionIdEncodingName;
    private final String sessionLockingMode;
    private final boolean useDefaultSessionIdDecoding;
    private final boolean useDefaultSessionIdEncoding;
    private final String sessionIdAffinityToken;
    private final boolean sessionIdReplaceAffinityToken;
    private final boolean strict;
    private final int reaperPriority;
    private final int reaperCycleSeconds;
    private final int reaperCheckCollectionModulo;
    private final boolean reaperCheckCoordinated;
    private final boolean lazySessionAccess;
    private final boolean reaperAssumeLocality;
    private final String managementCacheName;
    private final boolean applicationNameGenerated;
    private final int daemonMaxThreads;
    private final int daemonMinThreads;
    private final boolean reaperParallel;
    private final boolean configurationConsistencyRequired;
    private final String httpSessionCollectionClassName;
    private final boolean ownershipSticky;
    private final String ownershipServiceName;
    private final String sessionCacheName;
    private final String distControllerClassName;
    private final String scopeControllerClassName;
    private final String localSessionCacheName;
    private final String localAttributesCacheName;
    private final boolean allowLocalAttributes;
    private final boolean enableSuspectAttributes;
    private final boolean enableAttributeListenerOptimization;
    private final int maxInactiveSeconds;
    private final int sessionIdLength;
    private final String cacheDelegatorClassName;
    private final String sessionIdGeneratorClassName;
    private final boolean logInvalidationExceptions;
    private final boolean sessionLocking;
    private final boolean memberLocking;
    private final boolean appLocking;
    private final boolean threadLocking;
    private final int getLockTimeout;
    private final boolean logThreadsHoldingLock;
    private final boolean enableSessionAccessDebugLogging;
    private final String sessionAccessDebugLoggingFilter;
    private String sessionExpiryFilterFactoryClassName;
    private int daemonQueueSize;
    private Level loggerLevel;
    private String overflowCacheName;
    private int overflowThreshold;
    private final String sessionReapingMechanism;

    private ConfigurationImpl(Builder builder) {
        this.applicationName = builder.applicationName;
        this.versionMajor = builder.versionMajor;
        this.versionMinor = builder.versionMinor;
        this.cacheConfigurationPath = builder.cacheConfigurationPath;
        this.clusterOwned = builder.clusterOwned;
        this.contextClustered = builder.contextClustered;
        this.sessionContextEnabled = builder.sessionContextEnabled;
        this.asyncExitDelayMillis = builder.asyncExitDelayMillis;
        this.sessionIdCookieEnabled = builder.sessionIdCookieEnabled;
        this.sessionIdCookieName = builder.sessionIdCookieName;
        this.sessionIdCookieDomain = builder.sessionIdCookieDomain;
        this.sessionIdCookiePath = builder.sessionIdCookiePath;
        this.sessionIdCookieMaxAgeSeconds = builder.sessionIdCookieMaxAgeSeconds;
        this.sessionIdCookieSecure = builder.sessionIdCookieSecure;
        this.sessionIdCookieHttpOnly = builder.sessionIdCookieHttpOnly;
        this.sessionIdEncodingEnabled = builder.sessionIdEncodingEnabled;
        this.sessionIdEncodingName = builder.sessionIdEncodingName;
        this.sessionLockingMode = builder.sessionLockingMode;
        this.sessionIdAffinityToken = builder.sessionIdAffinityToken;
        this.sessionIdReplaceAffinityToken = builder.sessionIdReplaceAffinityToken;
        this.useDefaultSessionIdDecoding = builder.useDefaultSessionIdDecoding;
        this.useDefaultSessionIdEncoding = builder.useDefaultSessionIdEncoding;
        this.strict = builder.strict;
        this.reaperPriority = builder.reaperPriority;
        this.reaperCycleSeconds = builder.reaperCycleSeconds;
        this.reaperCheckCoordinated = builder.reaperCheckCoordinated;
        this.reaperCheckCollectionModulo = builder.reaperCheckCollectionModulo;
        this.reaperAssumeLocality = builder.reaperAssumeLocality;
        this.shutdownDelaySeconds = builder.shutdownDelaySeconds;
        this.lazySessionAccess = builder.lazySessionAccess;
        this.managementCacheName = builder.managementCacheName;
        this.applicationNameGenerated = builder.applicationNameGenerated;
        this.daemonMaxThreads = builder.daemonMaxThreads;
        this.daemonMinThreads = builder.daemonMinThreads;
        this.reaperParallel = builder.reaperParallel;
        this.configurationConsistencyRequired = builder.configurationConsistencyRequired;
        this.httpSessionCollectionClassName = builder.httpSessionCollectionClassName;
        this.sessionExpiryFilterFactoryClassName = builder.sessionExpiryFilterFactoryClassName;
        this.daemonQueueSize = builder.daemonQueueSize;
        this.loggerLevel = builder.loggerLevel;
        this.sessionCacheName = builder.sessionCacheName;
        this.localSessionCacheName = builder.localSessionCacheName;
        this.localAttributesCacheName = builder.localAttributesCacheName;
        this.maxInactiveSeconds = builder.maxInactiveSeconds;
        this.sessionIdLength = builder.sessionIdLength;
        this.sessionIdGeneratorClassName = builder.sessionIdGeneratorClassName;
        this.cacheDelegatorClassName = builder.cacheDelegatorClassName;
        this.logInvalidationExceptions = builder.logInvalidationExceptions;
        this.sessionLocking = builder.sessionLocking;
        this.memberLocking = builder.memberLocking;
        this.appLocking = builder.appLocking;
        this.threadLocking = builder.threadLocking;
        this.getLockTimeout = builder.getLockTimeout;
        this.logThreadsHoldingLock = builder.logThreadsHoldingLock;
        this.distControllerClassName = builder.distControllerClassName;
        this.scopeControllerClassName = builder.scopeControllerClassName;
        this.ownershipSticky = builder.ownershipSticky;
        this.ownershipServiceName = builder.ownershipServiceName;
        this.allowLocalAttributes = builder.allowLocalAttributes;
        this.enableSuspectAttributes = builder.enableSuspectAttributes;
        this.enableAttributeListenerOptimization = builder.enableAttributeListenerOptimization;
        this.sessionReapingMechanism = builder.sessionReapingMechanism;
        this.overflowCacheName = builder.overflowCacheName;
        this.overflowThreshold = builder.overflowThreshold;
        this.enableSessionAccessDebugLogging = builder.enableSessionAccessDebugLogging;
        this.sessionAccessDebugLoggingFilter = builder.sessionAccessDebugLoggingFilter;
        assert (this.distControllerClassName != null);
        assert (this.scopeControllerClassName != null);
    }

    public ConfigurationImpl() {
        this(new Builder(null, false));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  Clustered Session Cache Name=").append(this.sessionCacheName).append("\n  Local Session Cache Name=").append(this.localSessionCacheName).append("\n  Local Session Attribute Cache Name=").append(this.localAttributesCacheName).append("\n  SessionDistributionController Class Name=").append(this.distControllerClassName).append("\n  AttributeScopeController Class Name=").append(this.scopeControllerClassName).append("\n  Maximum Session Inactive Seconds=").append(this.maxInactiveSeconds).append("\n  Session ID Character Length=").append(this.sessionIdLength).append("\n  Session Get Lock Timeout=").append(this.getLockTimeout).append("\n  Suspect Attribute Detection=").append(this.enableSuspectAttributes).append("\n  Strict \"Servlet Specification\" Exception Handling=").append(this.isStrict()).append("\n  Sticky Session Ownership=").append(this.ownershipSticky).append("\n  Sticky Session Ownership Service Name=").append(this.ownershipServiceName).append("\n  Assume Session Locality for Reaping=").append(this.reaperAssumeLocality).append("\n  Parallel Session Reaping=").append(this.reaperParallel).append("\n  Allow Local Attributes=").append(this.allowLocalAttributes).append("\n  Use Default Session ID Decoding=").append(this.useDefaultSessionIdDecoding).append("\n  Use Default Session ID Encoding=").append(this.useDefaultSessionIdEncoding).append("\n  Session ID Affinity Token=").append(this.sessionIdAffinityToken).append("\n  Session ID Replace Affinity Token=").append(this.sessionIdReplaceAffinityToken).append("\n  Session Expiry Filter Factory=").append(this.sessionExpiryFilterFactoryClassName).append("\n  Session Access Debug Logging Enabled=").append(this.enableSessionAccessDebugLogging).append("\n  Session Access Debug Logging Filter=").append(this.sessionAccessDebugLoggingFilter).append("\n  Session Locking Mode=").append(this.sessionLockingMode).append("\n  Session Reaping Mechanism=").append(this.sessionReapingMechanism);
        return sb.toString();
    }

    @Override
    public int getServletContextVersionMajor() {
        return this.versionMajor;
    }

    @Override
    public int getServletContextVersionMinor() {
        return this.versionMinor;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getCacheConfigurationPath() {
        return this.cacheConfigurationPath;
    }

    @Override
    public boolean isClusterOwned() {
        return this.clusterOwned;
    }

    @Override
    public boolean isServletContextClustered() {
        return this.contextClustered;
    }

    @Override
    public boolean isSessionContextEnabled() {
        return this.sessionContextEnabled;
    }

    @Override
    public int getAsyncExitDelayMillis() {
        return this.asyncExitDelayMillis;
    }

    @Override
    public boolean isSessionIdCookieEnabled() {
        return this.sessionIdCookieEnabled;
    }

    @Override
    public String getSessionIdCookieName() {
        return this.sessionIdCookieName;
    }

    @Override
    public String getSessionIdCookieDomain() {
        return this.sessionIdCookieDomain;
    }

    @Override
    public String getSessionIdCookiePath() {
        return this.sessionIdCookiePath;
    }

    @Override
    public int getSessionIdCookieMaxAgeSeconds() {
        return this.sessionIdCookieMaxAgeSeconds;
    }

    @Override
    public boolean isSessionIdCookieSecure() {
        return this.sessionIdCookieSecure;
    }

    @Override
    public boolean isSessionIdCookieHttpOnly() {
        return this.sessionIdCookieHttpOnly;
    }

    @Override
    public boolean isSessionIdEncodingEnabled() {
        return this.sessionIdEncodingEnabled;
    }

    @Override
    public String getSessionIdEncodingName() {
        return this.sessionIdEncodingName;
    }

    @Override
    public boolean isUseDefaultSessionIdDecoding() {
        return this.useDefaultSessionIdDecoding;
    }

    @Override
    public boolean isUseDefaultSessionIdEncoding() {
        return this.useDefaultSessionIdEncoding;
    }

    @Override
    public String getSessionIdAffinityToken() {
        return this.sessionIdAffinityToken;
    }

    @Override
    public boolean getSessionIdReplaceAffinityToken() {
        return this.sessionIdReplaceAffinityToken;
    }

    @Override
    public boolean isLogInvalidationExceptions() {
        return this.logInvalidationExceptions;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public int getReaperPriority() {
        return this.reaperPriority;
    }

    @Override
    public int getReaperCycleSeconds() {
        return this.reaperCycleSeconds;
    }

    @Override
    public boolean isReaperCheckCoordinated() {
        return this.reaperCheckCoordinated;
    }

    @Override
    public int getReaperCheckCollectionModulo() {
        return this.reaperCheckCollectionModulo;
    }

    @Override
    public boolean isReaperAssumeLocality() {
        return this.reaperAssumeLocality;
    }

    @Override
    public int getShutdownDelaySeconds() {
        return this.shutdownDelaySeconds;
    }

    @Override
    public boolean isSessionLazyAccess() {
        return this.lazySessionAccess;
    }

    @Override
    public String getManagementCacheName() {
        return this.managementCacheName;
    }

    protected boolean isApplicationNameGenerated() {
        return this.applicationNameGenerated;
    }

    @Override
    public boolean isConfigurationConsistencyRequired() {
        return this.configurationConsistencyRequired;
    }

    @Override
    public int getDaemonMaxThreads() {
        return this.daemonMaxThreads;
    }

    @Override
    public int getDaemonMinThreads() {
        return this.daemonMinThreads;
    }

    @Override
    public boolean isReapingParallel() {
        return this.reaperParallel;
    }

    @Override
    public String getHttpSessionCollectionClassName() {
        return this.httpSessionCollectionClassName;
    }

    @Override
    public boolean isOwnershipSticky() {
        return this.ownershipSticky;
    }

    @Override
    public String getOwnershipServiceName() {
        return this.ownershipServiceName;
    }

    @Override
    public String getSessionCacheName() {
        return this.sessionCacheName;
    }

    @Override
    public String getDistControllerClassName() {
        return this.distControllerClassName;
    }

    @Override
    public String getScopeControllerClassName() {
        return this.scopeControllerClassName;
    }

    @Override
    public String getLocalSessionCacheName() {
        return this.localSessionCacheName;
    }

    @Override
    public String getLocalAttributesCacheName() {
        return this.localAttributesCacheName;
    }

    @Override
    public boolean isAllowLocalAttributes() {
        return this.allowLocalAttributes;
    }

    @Override
    public boolean isEnableSuspectAttributes() {
        return this.enableSuspectAttributes;
    }

    @Override
    public boolean isEnableAttributeListenerOptimization() {
        return this.enableAttributeListenerOptimization;
    }

    @Override
    public int getMaxInactiveSeconds() {
        return this.maxInactiveSeconds;
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public String getSessionIdGeneratorClassName() {
        return this.sessionIdGeneratorClassName;
    }

    @Override
    public String getCacheDelegatorClassName() {
        return this.cacheDelegatorClassName;
    }

    @Override
    public boolean isSessionLockingEnforced() {
        return this.sessionLocking;
    }

    @Override
    public boolean isMemberLockingEnforced() {
        return this.memberLocking;
    }

    @Override
    public boolean isAppLockingEnforced() {
        return this.appLocking;
    }

    @Override
    public boolean isThreadLockingEnforced() {
        return this.threadLocking;
    }

    @Override
    public int getLockTimeout() {
        return this.getLockTimeout;
    }

    @Override
    public String getSessionExpiryFilterFactoryClassName() {
        return this.sessionExpiryFilterFactoryClassName;
    }

    @Override
    public int getOverflowThreshold() {
        return this.overflowThreshold;
    }

    @Override
    public String getOverflowCacheName() {
        return this.overflowCacheName;
    }

    @Override
    public boolean logThreadsHoldingLock() {
        return this.logThreadsHoldingLock;
    }

    @Override
    public int getDaemonQueueSize() {
        return this.daemonQueueSize;
    }

    @Override
    public Level getLoggerLevel() {
        return this.loggerLevel;
    }

    @Override
    public boolean isEnableSessionAccessDebugLogging() {
        return this.enableSessionAccessDebugLogging;
    }

    @Override
    public String getSessionAccessDebugLoggingFilter() {
        return this.sessionAccessDebugLoggingFilter;
    }

    @Override
    public String getSessionReapingMechanism() {
        return this.sessionReapingMechanism;
    }

    protected static String getStringValue(XmlElement xml, String param, String defaultValue) {
        String value = ConfigurationImpl.getStringValue(param);
        if (value != null) {
            return value;
        }
        return xml.getSafeElement(param).getString(defaultValue);
    }

    public static String getStringValue(String param) {
        String propName = param.replaceAll("-", ".");
        return System.getProperty(propName);
    }

    @Override
    public String checkCompatible(ValidatingConfiguration configuration) {
        ConfigurationImpl that = (ConfigurationImpl)configuration;
        if (!(configuration instanceof ConfigurationImpl)) {
            throw new ClassCastException();
        }
        StringBuilder errs = new StringBuilder();
        if (!this.httpSessionCollectionClassName.equals(that.httpSessionCollectionClassName)) {
            errs.append("coherence-sessioncollection-class").append(" ");
        }
        if (this.appLocking != that.appLocking) {
            errs.append("coherence-session-app-locking").append(" ");
        }
        if (this.memberLocking != that.memberLocking) {
            errs.append("coherence-session-member-locking").append(" ");
        }
        if (this.sessionLocking != that.sessionLocking) {
            errs.append("coherence-session-locking").append(" ");
        }
        if (this.threadLocking != that.threadLocking) {
            errs.append("coherence-session-thread-locking").append(" ");
        }
        if (this.ownershipSticky != that.ownershipSticky) {
            errs.append("coherence-sticky-sessions").append(" ");
        }
        return errs.length() == 0 ? null : errs.insert(0, INCONSISTENCY_LEAD).toString();
    }

    protected static boolean getBooleanValue(XmlElement xml, String param, boolean defaultValue) {
        String value = ConfigurationImpl.getStringValue(param);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return xml.getSafeElement(param).getBoolean(defaultValue);
    }

    protected static int getIntValue(XmlElement xml, String param, int defaultValue) {
        String value = ConfigurationImpl.getStringValue(param);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return xml.getSafeElement(param).getInt(defaultValue);
    }

    static class Builder {
        protected String applicationName = null;
        protected int versionMajor;
        protected int versionMinor;
        protected String cacheConfigurationPath;
        protected boolean clusterOwned = false;
        protected boolean contextClustered = false;
        protected boolean sessionContextEnabled = false;
        protected int asyncExitDelayMillis = 200;
        protected int shutdownDelaySeconds = 0;
        protected boolean sessionIdCookieEnabled = true;
        protected String sessionIdCookieName = "JSESSIONID";
        protected String sessionIdCookieDomain = null;
        protected String sessionIdCookiePath = null;
        protected int sessionIdCookieMaxAgeSeconds = -1;
        protected boolean sessionIdCookieSecure = false;
        protected boolean sessionIdCookieHttpOnly = false;
        protected boolean sessionIdEncodingEnabled = false;
        protected String sessionIdEncodingName = "jsessionid";
        protected boolean useDefaultSessionIdDecoding = true;
        protected boolean useDefaultSessionIdEncoding = false;
        protected String sessionIdAffinityToken = null;
        protected boolean sessionIdReplaceAffinityToken = false;
        protected boolean strict = true;
        protected int reaperPriority = 5;
        protected int reaperCycleSeconds = 300;
        protected int reaperCheckCollectionModulo = 4;
        protected boolean reaperCheckCoordinated = false;
        protected boolean lazySessionAccess = false;
        protected boolean reaperAssumeLocality = true;
        protected String managementCacheName = "session-management";
        protected boolean applicationNameGenerated = false;
        protected int daemonMaxThreads = 5;
        protected int daemonMinThreads = 1;
        protected int daemonQueueSize = Integer.MAX_VALUE;
        protected Level loggerLevel = Level.INFO;
        protected boolean reaperParallel = false;
        protected boolean configurationConsistencyRequired = false;
        protected String httpSessionCollectionClassName = null;
        protected boolean ownershipSticky = false;
        protected String ownershipServiceName = "SessionOwnership";
        protected String sessionCacheName = "session-storage";
        protected String distControllerClassName = "";
        protected String scopeControllerClassName = "";
        protected String localSessionCacheName = "local-session-storage";
        protected String localAttributesCacheName = "local-attribute-storage";
        protected boolean allowLocalAttributes = false;
        protected boolean enableSuspectAttributes = true;
        protected boolean enableAttributeListenerOptimization = false;
        protected int maxInactiveSeconds = 1800;
        protected int sessionIdLength = 12;
        protected String sessionIdGeneratorClassName = RandomHttpSessionIdGenerator.class.getName();
        protected String cacheDelegatorClassName = DefaultCacheDelegator.class.getName();
        protected boolean logInvalidationExceptions = true;
        protected boolean sessionLocking = false;
        protected boolean memberLocking = false;
        protected boolean appLocking = false;
        protected boolean threadLocking = false;
        protected int getLockTimeout = 300;
        protected boolean logThreadsHoldingLock = true;
        protected String sessionExpiryFilterFactoryClassName = "";
        protected boolean enableSessionAccessDebugLogging = false;
        protected String sessionLockingMode = "";
        protected String sessionAccessDebugLoggingFilter = "";
        protected String sessionReapingMechanism = "Default";
        private final ConfigurableCacheFactory ccf;
        protected final boolean checkConsistent;
        protected String overflowCacheName = "";
        protected int overflowThreshold;

        public Builder(ConfigurableCacheFactory ccf) {
            this(ccf, true);
        }

        private Builder(ConfigurableCacheFactory ccf, boolean checkConsistent) {
            this.ccf = ccf;
            this.checkConsistent = checkConsistent;
        }

        public ConfigurationImpl build() {
            if (this.checkConsistent) {
                this.ensureConsistent();
            }
            return new ConfigurationImpl(this);
        }

        protected void ensureConsistent() {
            DistributedCacheService serviceDist;
            CacheService service;
            if (this.httpSessionCollectionClassName == null) {
                throw new IllegalStateException("Missing required \"coherence-sessioncollection-class\" context parameter");
            }
            if (this.reaperCheckCoordinated && this.isExtend(this.managementCacheName)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Coordinated reaping cannot be used with Coherence*Extend; switching to uncoordinated reaping");
                }
                this.reaperCheckCoordinated = false;
            }
            if (this.applicationName == null || this.applicationName.length() == 0) {
                this.applicationNameGenerated = true;
                this.applicationName = "web-app-" + this.getClass().getClassLoader().hashCode();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "No name was configured for this web application. Generated web application name is: " + this.applicationName);
                }
            }
            if (this.applicationNameGenerated) {
                if (this.scopeControllerClassName == null || this.scopeControllerClassName.length() == 0) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Web application name and AttributeScopeController were not configured for this web application. The GlobalScopeController will be automatically configured for this application.");
                    }
                    this.scopeControllerClassName = AbstractHttpSessionCollection.GlobalScopeController.class.getName();
                } else if (!this.scopeControllerClassName.equals(AbstractHttpSessionCollection.GlobalScopeController.class.getName()) && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Configured AttributeScopeController: " + this.scopeControllerClassName + " may not share session attribute state between the same web application on multiple web containers since the web application name was not configured.");
                }
            }
            if (this.distControllerClassName != null && this.distControllerClassName.length() != 0 && !this.distControllerClassName.equals(AbstractHttpSessionCollection.DistributedController.class.getName())) {
                this.allowLocalAttributes = true;
            }
            if (this.threadLocking && !this.appLocking) {
                LOGGER.log(Level.INFO, "Thread locking was enabled, but App locking was  not enabled. Automatically enabling App locking.");
                this.appLocking = true;
            }
            if (this.appLocking && !this.memberLocking) {
                LOGGER.log(Level.INFO, "App locking was enabled, but Member locking was  not enabled. Automatically enabling Member locking.");
                this.memberLocking = true;
            }
            if (this.memberLocking && this.isExtend(this.sessionCacheName)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Session locking cannot be used with Coherence*Extend; session locking will be disabled.");
                }
                this.memberLocking = false;
                this.appLocking = false;
                this.threadLocking = false;
            }
            if (this.memberLocking && !this.sessionLocking) {
                LOGGER.log(Level.INFO, "Member locking was enabled, but Session locking was  not enabled. Automatically enabling Session locking.");
                this.sessionLocking = true;
            }
            if (this.getLockTimeout < 0) {
                this.getLockTimeout = Integer.MAX_VALUE;
            }
            if (this.ownershipSticky && !this.memberLocking) {
                throw new IllegalArgumentException("Sticky session optimization requires member locking");
            }
            if (this.reaperAssumeLocality && (service = this.getCacheService(this.sessionCacheName)) instanceof DistributedCacheService && !(serviceDist = (DistributedCacheService)service).isLocalStorageEnabled()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Session management was configured to assume locality via \"coherence-reaperdaemon-assume-locality\" but local storage is disabled; disabling \"coherence-reaperdaemon-assume-locality\".");
                }
                this.reaperAssumeLocality = false;
            }
            if (this.enableSessionAccessDebugLogging) {
                LOGGER.log(Level.INFO, "Session Access Debug Logging is Enabled");
            }
            if (this.daemonMaxThreads < this.daemonMinThreads) {
                throw new IllegalArgumentException("Daemon max threads cannot be less than daemon min threads.");
            }
            if (this.daemonMinThreads < 0) {
                throw new IllegalArgumentException("Daemon min threads must be a positive integer.");
            }
            if (this.daemonQueueSize < 1) {
                throw new IllegalArgumentException("Daemon queue size must be greater than zero.");
            }
            if (!"Default".equals(this.sessionReapingMechanism) && !"RemoteDelete".equals(this.sessionReapingMechanism)) {
                LOGGER.log(Level.INFO, "Session Reaping Mechanism should be Default or RemoteDelete. Defaulting to Default.");
                this.sessionReapingMechanism = "Default";
            }
        }

        public Builder setVersionMajor(int nVersionMajor) {
            this.versionMajor = nVersionMajor;
            return this;
        }

        public Builder setVersionMinor(int nVersionMinor) {
            this.versionMinor = nVersionMinor;
            return this;
        }

        public Builder setApplicationName(String sApplication) {
            this.applicationName = sApplication;
            return this;
        }

        public Builder setApplicationNameGenerated(boolean fApplicationNameGenerated) {
            this.applicationNameGenerated = fApplicationNameGenerated;
            return this;
        }

        public Builder setCacheConfigurationPath(String sCacheConfigurationPath) {
            this.cacheConfigurationPath = sCacheConfigurationPath == null || sCacheConfigurationPath.isEmpty() ? "session-cache-config.xml" : sCacheConfigurationPath;
            return this;
        }

        public Builder setClusterOwned(boolean fClusterOwned) {
            this.clusterOwned = fClusterOwned;
            return this;
        }

        public Builder setContextClustered(boolean fContextClustered) {
            this.contextClustered = fContextClustered;
            return this;
        }

        public Builder setSessionContextEnabled(boolean fSessionContextEnabled) {
            this.sessionContextEnabled = fSessionContextEnabled;
            return this;
        }

        public Builder setMillisAsyncExitDelay(int cMillisAsyncExitDelay) {
            this.asyncExitDelayMillis = cMillisAsyncExitDelay;
            return this;
        }

        public Builder setSessionIdCookieEnabled(boolean fSessionIdCookieEnabled) {
            this.sessionIdCookieEnabled = fSessionIdCookieEnabled;
            return this;
        }

        public Builder setSessionIdCookieName(String sSessionIdCookieName) {
            this.sessionIdCookieName = sSessionIdCookieName;
            return this;
        }

        public Builder setSessionIdCookieDomain(String sCookieDomain) {
            this.sessionIdCookieDomain = this.trim(sCookieDomain);
            return this;
        }

        public Builder setSessionIdCookiePath(String sCookiePath) {
            this.sessionIdCookiePath = this.trim(sCookiePath);
            return this;
        }

        public Builder setSessionIdCookieMaxAgeSeconds(int cCookieMaxAgeSeconds) {
            if (cCookieMaxAgeSeconds < 1) {
                cCookieMaxAgeSeconds = -1;
            }
            this.sessionIdCookieMaxAgeSeconds = cCookieMaxAgeSeconds;
            return this;
        }

        public Builder setSessionIdCookieSecure(boolean fSessionIdCookieSecure) {
            this.sessionIdCookieSecure = fSessionIdCookieSecure;
            return this;
        }

        public Builder setSessionIdCookieHttpOnly(boolean fSessionIdCookieHttpOnly) {
            this.sessionIdCookieHttpOnly = fSessionIdCookieHttpOnly;
            return this;
        }

        public Builder setSessionIdEncodingEnabled(boolean fSessionIdEncodingEnabled) {
            this.sessionIdEncodingEnabled = fSessionIdEncodingEnabled;
            return this;
        }

        public Builder setSessionIdEncodingName(String sSessionIdEncodingName) {
            this.sessionIdEncodingName = sSessionIdEncodingName;
            return this;
        }

        public Builder setUseDefaultSessionIdDecoding(boolean fUseDefaultSessionIdDecoding) {
            this.useDefaultSessionIdDecoding = fUseDefaultSessionIdDecoding;
            return this;
        }

        public Builder setUseDefaultSessionIdEncoding(boolean fUseDefaultSessionIdEncoding) {
            this.useDefaultSessionIdEncoding = fUseDefaultSessionIdEncoding;
            return this;
        }

        public Builder setSessionIdAffinityToken(String sSessionIdAffinityToken) {
            this.sessionIdAffinityToken = sSessionIdAffinityToken;
            return this;
        }

        public Builder setSessionIdReplaceAffinityToken(boolean fSessionIdReplaceAffinityToken) {
            this.sessionIdReplaceAffinityToken = fSessionIdReplaceAffinityToken;
            return this;
        }

        public Builder setStrict(boolean fStrict) {
            this.strict = fStrict;
            return this;
        }

        public Builder setReaperPriority(int nDaemonPriority) {
            this.reaperPriority = nDaemonPriority;
            return this;
        }

        public Builder setReaperCycleSeconds(int cDaemonCycleSeconds) {
            this.reaperCycleSeconds = cDaemonCycleSeconds;
            return this;
        }

        public Builder setReaperCheckCoordinated(boolean fDaemonCheckCoordinated) {
            this.reaperCheckCoordinated = fDaemonCheckCoordinated;
            return this;
        }

        public Builder setReaperCheckCollectionModulo(int cDaemonCheckCollectionModulo) {
            this.reaperCheckCollectionModulo = cDaemonCheckCollectionModulo;
            return this;
        }

        public Builder setReaperAssumeLocality(boolean fDaemonAssumeLocality) {
            this.reaperAssumeLocality = fDaemonAssumeLocality;
            return this;
        }

        public Builder setShutdownDelaySeconds(int cShutdownDelaySeconds) {
            this.shutdownDelaySeconds = cShutdownDelaySeconds;
            return this;
        }

        public Builder setLazySessionAccess(boolean fLazySessionAccess) {
            this.lazySessionAccess = fLazySessionAccess;
            return this;
        }

        public Builder setManagementCache(String sManagementCache) {
            this.managementCacheName = sManagementCache;
            return this;
        }

        public Builder setDaemonMaxThreads(int daemonMaxThreads) {
            this.daemonMaxThreads = daemonMaxThreads;
            return this;
        }

        public Builder setDaemonMinThreads(int daemonMinThreads) {
            this.daemonMinThreads = daemonMinThreads;
            return this;
        }

        public Builder setDaemonQueueSize(int daemonQueueSize) {
            this.daemonQueueSize = daemonQueueSize;
            return this;
        }

        public Builder setLoggerLevel(Level loggerLevel) {
            this.loggerLevel = loggerLevel;
            return this;
        }

        public Builder setReaperParallel(boolean reaperParallel) {
            this.reaperParallel = reaperParallel;
            return this;
        }

        public Builder setConfigurationConsistencyRequired(boolean configurationConsistencyRequired) {
            this.configurationConsistencyRequired = configurationConsistencyRequired;
            return this;
        }

        public Builder setHttpSessionCollectionClassName(String httpSessionCollectionClassName) {
            this.httpSessionCollectionClassName = this.trim(httpSessionCollectionClassName);
            return this;
        }

        public Builder setSessionCache(String sSessionCache) {
            this.sessionCacheName = sSessionCache;
            return this;
        }

        public Builder setLocalSessionCache(String sLocalSessionCache) {
            this.localSessionCacheName = sLocalSessionCache;
            return this;
        }

        public Builder setLocalAttributesCache(String sLocalAttributesCache) {
            this.localAttributesCacheName = sLocalAttributesCache;
            return this;
        }

        public Builder setMaxInactiveSeconds(int cMaxInactiveSeconds) {
            this.maxInactiveSeconds = cMaxInactiveSeconds;
            return this;
        }

        public Builder setSessionIdLength(int cchSessionId) {
            this.sessionIdLength = cchSessionId;
            return this;
        }

        public Builder setCacheDelegatorClassName(String sCacheDelegatorClassName) {
            this.cacheDelegatorClassName = sCacheDelegatorClassName;
            return this;
        }

        public Builder setSessionIdGenerator(String sSessionIdGenerator) {
            this.sessionIdGeneratorClassName = sSessionIdGenerator;
            return this;
        }

        public Builder setLogInvalidationExceptions(boolean fLogExceptions) {
            this.logInvalidationExceptions = fLogExceptions;
            return this;
        }

        public Builder setSessionLocking(boolean fSessionLocking) {
            this.sessionLocking = fSessionLocking;
            return this;
        }

        public Builder setMemberLocking(boolean fMemberLocking) {
            this.memberLocking = fMemberLocking;
            return this;
        }

        public Builder setAppLocking(boolean fAppLocking) {
            this.appLocking = fAppLocking;
            return this;
        }

        public Builder setThreadLocking(boolean fThreadLocking) {
            this.threadLocking = fThreadLocking;
            return this;
        }

        public Builder setGetLockTimeout(int cGetLockTimeout) {
            this.getLockTimeout = cGetLockTimeout;
            return this;
        }

        public Builder setLogThreadsHoldingLock(boolean fLogThreadsHoldingLock) {
            this.logThreadsHoldingLock = fLogThreadsHoldingLock;
            return this;
        }

        public Builder setDistController(String sDistController) {
            this.distControllerClassName = this.allowLocalAttributes ? AbstractHttpSessionCollection.HybridController.class.getName() : (sDistController == null ? "" : sDistController);
            return this;
        }

        public Builder setScopeController(String sScopeController) {
            this.scopeControllerClassName = sScopeController == null ? "" : sScopeController;
            return this;
        }

        public Builder setOwnershipSticky(boolean fOwnershipSticky) {
            this.ownershipSticky = fOwnershipSticky;
            return this;
        }

        public Builder setOwnershipServiceName(String sOwnershipService) {
            this.ownershipServiceName = sOwnershipService;
            return this;
        }

        public Builder setAllowLocalAttributes(boolean fAllowLocalAttributes) {
            this.allowLocalAttributes = fAllowLocalAttributes;
            return this;
        }

        public Builder setEnableSuspectAttributes(boolean fEnableSuspectAttributes) {
            this.enableSuspectAttributes = fEnableSuspectAttributes;
            return this;
        }

        public Builder setEnableAttributeListenerOptimization(boolean flag) {
            this.enableAttributeListenerOptimization = flag;
            return this;
        }

        public Builder setSessionExpiryFilterFactoryClassName(String name) {
            this.sessionExpiryFilterFactoryClassName = name;
            return this;
        }

        public Builder setSessionLockingMode(String sMode) {
            this.sessionLockingMode = sMode.toLowerCase().trim();
            if (sMode.isEmpty()) {
                this.sessionLockingMode = this.sessionLocking && !this.memberLocking ? "optimistic" : (this.memberLocking && !this.appLocking ? "member" : (this.appLocking && !this.threadLocking ? "app" : (this.threadLocking ? "thread" : "none")));
            } else {
                this.memberLocking = false;
                this.appLocking = false;
                this.threadLocking = false;
                this.sessionLocking = false;
                if (this.sessionLockingMode.equals("optimistic")) {
                    this.sessionLocking = true;
                } else if (this.sessionLockingMode.equals("member")) {
                    this.memberLocking = true;
                } else if (this.sessionLockingMode.equals("app")) {
                    this.memberLocking = true;
                    this.appLocking = true;
                } else if (this.sessionLockingMode.equals("thread")) {
                    this.memberLocking = true;
                    this.appLocking = true;
                    this.threadLocking = true;
                } else if (!this.sessionLockingMode.equals("none")) {
                    throw new RuntimeException("SessionLockingMode Configuration Error, Mode=" + sMode + " valid modes are 'none', 'optimistic', 'member', 'app' and 'thread'.");
                }
            }
            return this;
        }

        public Builder setOverflowCacheName(String cacheName) {
            this.overflowCacheName = cacheName;
            return this;
        }

        public Builder setOverflowThreshold(int threshold) {
            this.overflowThreshold = threshold;
            return this;
        }

        public Builder setEnableSessionAccessDebugLogging(boolean flag) {
            this.enableSessionAccessDebugLogging = flag;
            return this;
        }

        public Builder setSessionAccessDebugLoggingFilter(String filter) {
            this.sessionAccessDebugLoggingFilter = filter;
            return this;
        }

        public Builder setSessionReapingMechanism(String mechanism) {
            this.sessionReapingMechanism = mechanism;
            return this;
        }

        private String trim(String string) {
            if (string != null && (string = string.trim()).length() == 0) {
                string = null;
            }
            return string;
        }

        private boolean isExtend(String cacheName) {
            return "RemoteCache".equals(this.getCacheService(cacheName).getInfo().getServiceType());
        }

        private CacheService getCacheService(String cacheName) {
            ClassLoader cl = SessionHelper.class.getClassLoader();
            NamedCache cache = this.ccf.ensureCache(cacheName, cl);
            return cache.getCacheService();
        }
    }

    static class XmlElementBuilder
    extends Builder {
        XmlElementBuilder(ConfigurableCacheFactory ccf) {
            super(ccf);
        }

        Builder setXmlElement(XmlElement xml) {
            this.setApplicationName(xml);
            this.setApplicationNameGenerated(xml);
            this.setCacheConfigurationPath(xml);
            this.setClusterOwned(xml);
            this.setContextClustered(xml);
            this.setSessionContextEnabled(xml);
            this.setMillisAsyncExitDelay(xml);
            this.setSessionIdCookieEnabled(xml);
            this.setSessionIdCookieName(xml);
            this.setSessionIdCookieDomain(xml);
            this.setSessionIdCookiePath(xml);
            this.setSessionIdCookieMaxAgeSeconds(xml);
            this.setSessionIdCookieSecure(xml);
            this.setSessionIdCookieHttpOnly(xml);
            this.setSessionIdEncodingEnabled(xml);
            this.setSessionIdEncodingName(xml);
            this.setUseDefaultSessionIdDecoding(xml);
            this.setUseDefaultSessionIdEncoding(xml);
            this.setStrict(xml);
            this.setReaperPriority(xml);
            this.setReaperCycleSeconds(xml);
            this.setReaperCheckCoordinated(xml);
            this.setReaperCheckCollectionModulo(xml);
            this.setReaperAssumeLocality(xml);
            this.setShutdownDelaySeconds(xml);
            this.setLazySessionAccess(xml);
            this.setManagementCache(xml);
            this.setReaperParallel(xml);
            this.setDaemonMaxThreads(xml);
            this.setDaemonMinThreads(xml);
            this.setDaemonQueueSize(xml);
            this.setLoggerLevel(xml);
            this.setConfigurationConsistencyRequired(xml);
            this.setHttpSessionCollectionClassName(xml);
            this.setSessionIdReplaceAffinityToken(xml);
            this.setSessionIdAffinityToken(xml);
            this.setSessionCache(xml);
            this.setLocalSessionCache(xml);
            this.setLocalAttributesCache(xml);
            this.setMaxInactiveSeconds(xml);
            this.setSessionIdLength(xml);
            this.setSessionIdGenerator(xml);
            this.setLogInvalidationExceptions(xml);
            this.setCacheDelegatorClassName(xml);
            this.setSessionLocking(xml);
            this.setMemberLocking(xml);
            this.setAppLocking(xml);
            this.setThreadLocking(xml);
            this.setSessionLockingMode(xml);
            this.setGetLockTimeout(xml);
            this.setLogThreadsHoldingLock(xml);
            this.setScopeController(xml);
            this.setOwnershipSticky(xml);
            this.setOwnershipServiceName(xml);
            this.setAllowLocalAttributes(xml);
            this.setDistController(xml);
            this.setEnableSuspectAttributes(xml);
            this.setEnableAttributeListenerOptimization(xml);
            this.setSessionExpiryFilterFactoryClassName(xml);
            this.setOverflowCacheName(xml);
            this.setOverflowThreshold(xml);
            this.setEnableSessionAccessDebugLogging(xml);
            this.setSessionAccessDebugLoggingFilter(xml);
            this.setSessionReapingMechanism(xml);
            return this;
        }

        public Builder setApplicationName(XmlElement xml) {
            return this.setApplicationName(ConfigurationImpl.getStringValue(xml, "coherence-application-name", this.applicationName));
        }

        public Builder setApplicationNameGenerated(XmlElement xml) {
            return this.setApplicationNameGenerated(ConfigurationImpl.getBooleanValue(xml, "coherence-application-name-generated", this.applicationNameGenerated));
        }

        public Builder setCacheConfigurationPath(XmlElement xml) {
            return this.setCacheConfigurationPath(ConfigurationImpl.getStringValue(xml, "coherence-cache-configuration-path", this.cacheConfigurationPath));
        }

        public Builder setClusterOwned(XmlElement xml) {
            return this.setClusterOwned(ConfigurationImpl.getBooleanValue(xml, "coherence-cluster-owned", this.clusterOwned));
        }

        public Builder setContextClustered(XmlElement xml) {
            return this.setContextClustered(ConfigurationImpl.getBooleanValue(xml, "coherence-servletcontext-clustered", this.contextClustered));
        }

        public Builder setSessionContextEnabled(XmlElement xml) {
            return this.setSessionContextEnabled(ConfigurationImpl.getBooleanValue(xml, "coherence-enable-sessioncontext", this.sessionContextEnabled));
        }

        public Builder setMillisAsyncExitDelay(XmlElement xml) {
            return this.setMillisAsyncExitDelay(ConfigurationImpl.getIntValue(xml, "coherence-contextless-session-retain-millis", this.asyncExitDelayMillis));
        }

        public Builder setSessionIdCookieEnabled(XmlElement xml) {
            return this.setSessionIdCookieEnabled(ConfigurationImpl.getBooleanValue(xml, "coherence-session-cookies-enabled", this.sessionIdCookieEnabled));
        }

        public Builder setSessionIdCookieName(XmlElement xml) {
            return this.setSessionIdCookieName(ConfigurationImpl.getStringValue(xml, "coherence-session-cookie-name", this.sessionIdCookieName));
        }

        public Builder setSessionIdCookieDomain(XmlElement xml) {
            return this.setSessionIdCookieDomain(ConfigurationImpl.getStringValue(xml, "coherence-session-cookie-domain", this.sessionIdCookieDomain));
        }

        public Builder setSessionIdCookiePath(XmlElement xml) {
            return this.setSessionIdCookiePath(ConfigurationImpl.getStringValue(xml, "coherence-session-cookie-path", this.sessionIdCookiePath));
        }

        public Builder setSessionIdCookieMaxAgeSeconds(XmlElement xml) {
            return this.setSessionIdCookieMaxAgeSeconds(ConfigurationImpl.getIntValue(xml, "coherence-session-cookie-max-age", this.sessionIdCookieMaxAgeSeconds));
        }

        public Builder setSessionIdCookieSecure(XmlElement xml) {
            return this.setSessionIdCookieSecure(ConfigurationImpl.getBooleanValue(xml, "coherence-session-cookie-secure", this.sessionIdCookieSecure));
        }

        public Builder setSessionIdCookieHttpOnly(XmlElement xml) {
            return this.setSessionIdCookieHttpOnly(ConfigurationImpl.getBooleanValue(xml, "coherence-session-cookie-httponly", this.sessionIdCookieHttpOnly));
        }

        public Builder setSessionIdEncodingEnabled(XmlElement xml) {
            return this.setSessionIdEncodingEnabled(ConfigurationImpl.getBooleanValue(xml, "coherence-session-urlencode-enabled", this.sessionIdEncodingEnabled));
        }

        public Builder setSessionIdEncodingName(XmlElement xml) {
            return this.setSessionIdEncodingName(ConfigurationImpl.getStringValue(xml, "coherence-session-urlencode-name", this.sessionIdEncodingName));
        }

        public Builder setUseDefaultSessionIdDecoding(XmlElement xml) {
            return this.setUseDefaultSessionIdDecoding(ConfigurationImpl.getBooleanValue(xml, "coherence-session-urldecode-bycontainer", this.useDefaultSessionIdDecoding));
        }

        public Builder setUseDefaultSessionIdEncoding(XmlElement xml) {
            return this.setUseDefaultSessionIdEncoding(ConfigurationImpl.getBooleanValue(xml, "coherence-session-urlencode-bycontainer", this.useDefaultSessionIdEncoding));
        }

        public Builder setSessionIdAffinityToken(XmlElement xml) {
            return this.setSessionIdAffinityToken(ConfigurationImpl.getStringValue(xml, "coherence-session-affinity-token", this.sessionIdAffinityToken));
        }

        public Builder setSessionIdReplaceAffinityToken(XmlElement xml) {
            return this.setSessionIdReplaceAffinityToken(ConfigurationImpl.getBooleanValue(xml, "coherence-session-replace-affinity-token", this.sessionIdReplaceAffinityToken));
        }

        public Builder setStrict(XmlElement xml) {
            return this.setStrict(ConfigurationImpl.getBooleanValue(xml, "coherence-session-strict-spec", this.strict));
        }

        public Builder setReaperPriority(XmlElement xml) {
            return this.setReaperPriority(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-priority", this.reaperPriority));
        }

        public Builder setReaperCycleSeconds(XmlElement xml) {
            return this.setReaperCycleSeconds(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-cycle-seconds", this.reaperCycleSeconds));
        }

        public Builder setReaperCheckCoordinated(XmlElement xml) {
            return this.setReaperCheckCoordinated(ConfigurationImpl.getBooleanValue(xml, "coherence-reaperdaemon-cluster-coordinated", this.reaperCheckCoordinated));
        }

        public Builder setReaperCheckCollectionModulo(XmlElement xml) {
            return this.setReaperCheckCollectionModulo(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-sweep-modulo", this.reaperCheckCollectionModulo));
        }

        public Builder setReaperAssumeLocality(XmlElement xml) {
            return this.setReaperAssumeLocality(ConfigurationImpl.getBooleanValue(xml, "coherence-reaperdaemon-assume-locality", this.reaperAssumeLocality));
        }

        public Builder setShutdownDelaySeconds(XmlElement xml) {
            return this.setShutdownDelaySeconds(ConfigurationImpl.getIntValue(xml, "coherence-shutdown-delay-seconds", this.shutdownDelaySeconds));
        }

        public Builder setLazySessionAccess(XmlElement xml) {
            return this.setLazySessionAccess(ConfigurationImpl.getBooleanValue(xml, "coherence-session-lazy-access", this.lazySessionAccess));
        }

        public Builder setManagementCache(XmlElement xml) {
            return this.setManagementCache(ConfigurationImpl.getStringValue(xml, "coherence-session-management-cachename", this.managementCacheName));
        }

        public Builder setConfigurationConsistencyRequired(XmlElement xml) {
            return this.setConfigurationConsistencyRequired(ConfigurationImpl.getBooleanValue(xml, "coherence-configuration-consistency", this.configurationConsistencyRequired));
        }

        public Builder setHttpSessionCollectionClassName(XmlElement xml) {
            return this.setHttpSessionCollectionClassName(ConfigurationImpl.getStringValue(xml, "coherence-sessioncollection-class", this.httpSessionCollectionClassName));
        }

        public Builder setDaemonMaxThreads(XmlElement xml) {
            return this.setDaemonMaxThreads(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-max-threads", this.daemonMaxThreads));
        }

        public Builder setDaemonMinThreads(XmlElement xml) {
            return this.setDaemonMinThreads(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-min-threads", this.daemonMinThreads));
        }

        public Builder setDaemonQueueSize(XmlElement xml) {
            return this.setDaemonQueueSize(ConfigurationImpl.getIntValue(xml, "coherence-reaperdaemon-queue-size", this.daemonQueueSize));
        }

        public Builder setLoggerLevel(XmlElement xml) {
            return this.setLoggerLevel(Level.parse(ConfigurationImpl.getStringValue(xml, "coherence-session-logger-level", "INFO")));
        }

        public Builder setReaperParallel(XmlElement xml) {
            return this.setReaperParallel(ConfigurationImpl.getBooleanValue(xml, "coherence-reaperdaemon-parallel", this.reaperParallel));
        }

        public Builder setSessionCache(XmlElement xml) {
            return this.setSessionCache(ConfigurationImpl.getStringValue(xml, "coherence-session-cachename", this.sessionCacheName));
        }

        public Builder setLocalSessionCache(XmlElement xml) {
            return this.setLocalSessionCache(ConfigurationImpl.getStringValue(xml, "coherence-local-session-cachename", this.localSessionCacheName));
        }

        public Builder setLocalAttributesCache(XmlElement xml) {
            return this.setLocalAttributesCache(ConfigurationImpl.getStringValue(xml, "coherence-local-attribute-cachename", this.localAttributesCacheName));
        }

        public Builder setMaxInactiveSeconds(XmlElement xml) {
            return this.setMaxInactiveSeconds(ConfigurationImpl.getIntValue(xml, "coherence-session-expire-seconds", this.maxInactiveSeconds));
        }

        public Builder setSessionIdLength(XmlElement xml) {
            return this.setSessionIdLength(ConfigurationImpl.getIntValue(xml, "coherence-session-id-length", this.sessionIdLength));
        }

        public Builder setCacheDelegatorClassName(XmlElement xml) {
            return this.setCacheDelegatorClassName(ConfigurationImpl.getStringValue(xml, "coherence-cache-delegator-class", this.cacheDelegatorClassName));
        }

        public Builder setSessionIdGenerator(XmlElement xml) {
            return this.setSessionIdGenerator(ConfigurationImpl.getStringValue(xml, "coherence-session-id-generator-class", this.sessionIdGeneratorClassName));
        }

        public Builder setLogInvalidationExceptions(XmlElement xml) {
            return this.setLogInvalidationExceptions(ConfigurationImpl.getBooleanValue(xml, "coherence-session-log-invalidation-exceptions", this.logInvalidationExceptions));
        }

        public Builder setSessionLocking(XmlElement xml) {
            return this.setSessionLocking(ConfigurationImpl.getBooleanValue(xml, "coherence-session-locking", this.sessionLocking));
        }

        public Builder setMemberLocking(XmlElement xml) {
            return this.setMemberLocking(ConfigurationImpl.getBooleanValue(xml, "coherence-session-member-locking", this.memberLocking));
        }

        public Builder setAppLocking(XmlElement xml) {
            return this.setAppLocking(ConfigurationImpl.getBooleanValue(xml, "coherence-session-app-locking", this.appLocking));
        }

        public Builder setThreadLocking(XmlElement xml) {
            return this.setThreadLocking(ConfigurationImpl.getBooleanValue(xml, "coherence-session-thread-locking", this.threadLocking));
        }

        public Builder setGetLockTimeout(XmlElement xml) {
            return this.setGetLockTimeout(ConfigurationImpl.getIntValue(xml, "coherence-session-get-lock-timeout", this.getLockTimeout));
        }

        public Builder setLogThreadsHoldingLock(XmlElement xml) {
            return this.setLogThreadsHoldingLock(ConfigurationImpl.getBooleanValue(xml, "coherence-session-log-threads-holding-lock", this.logThreadsHoldingLock));
        }

        public Builder setDistController(XmlElement xml) {
            return this.setDistController(ConfigurationImpl.getStringValue(xml, "coherence-distributioncontroller-class", this.distControllerClassName).trim());
        }

        public Builder setScopeController(XmlElement xml) {
            return this.setScopeController(ConfigurationImpl.getStringValue(xml, "coherence-scopecontroller-class", this.scopeControllerClassName).trim());
        }

        public Builder setOwnershipSticky(XmlElement xml) {
            return this.setOwnershipSticky(ConfigurationImpl.getBooleanValue(xml, "coherence-sticky-sessions", this.ownershipSticky));
        }

        public Builder setOwnershipServiceName(XmlElement xml) {
            return this.setOwnershipServiceName(ConfigurationImpl.getStringValue(xml, "coherence-ownership-service", this.ownershipServiceName));
        }

        public Builder setAllowLocalAttributes(XmlElement xml) {
            return this.setAllowLocalAttributes(ConfigurationImpl.getBooleanValue(xml, "coherence-preserve-attributes", this.allowLocalAttributes));
        }

        public Builder setEnableSuspectAttributes(XmlElement xml) {
            return this.setEnableSuspectAttributes(ConfigurationImpl.getBooleanValue(xml, "coherence-enable-suspect-attributes", this.enableSuspectAttributes));
        }

        public Builder setEnableAttributeListenerOptimization(XmlElement xml) {
            return this.setEnableAttributeListenerOptimization(ConfigurationImpl.getBooleanValue(xml, "coherence-enable-attribute-listener-optimization", this.enableAttributeListenerOptimization));
        }

        public Builder setSessionExpiryFilterFactoryClassName(XmlElement xml) {
            return this.setSessionExpiryFilterFactoryClassName(ConfigurationImpl.getStringValue(xml, "coherence-session-expiry-filter-factory-class", this.sessionExpiryFilterFactoryClassName));
        }

        public Builder setSessionLockingMode(XmlElement xml) {
            return this.setSessionLockingMode(ConfigurationImpl.getStringValue(xml, "coherence-session-locking-mode", this.sessionLockingMode));
        }

        public Builder setOverflowCacheName(XmlElement xml) {
            return this.setOverflowCacheName(ConfigurationImpl.getStringValue(xml, "coherence-session-overflow-cachename", "session-overflow"));
        }

        public Builder setOverflowThreshold(XmlElement xml) {
            return this.setOverflowThreshold(ConfigurationImpl.getIntValue(xml, "coherence-attribute-overflow-threshold", 1024));
        }

        public Builder setEnableSessionAccessDebugLogging(XmlElement xml) {
            return this.setEnableSessionAccessDebugLogging(ConfigurationImpl.getBooleanValue(xml, "coherence-session-enable-debug-logging", this.enableSessionAccessDebugLogging));
        }

        public Builder setSessionAccessDebugLoggingFilter(XmlElement xml) {
            return this.setSessionAccessDebugLoggingFilter(ConfigurationImpl.getStringValue(xml, "coherence-session-debug-logging-filter", this.sessionAccessDebugLoggingFilter));
        }

        public Builder setSessionReapingMechanism(XmlElement xml) {
            return this.setSessionReapingMechanism(ConfigurationImpl.getStringValue(xml, "coherence-session-reaping-mechanism", this.sessionReapingMechanism));
        }
    }
}

