/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.AbstractInvocable;
import com.tangosol.net.NamedCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogThreadsHoldingLockAgent
extends AbstractInvocable
implements ExternalizableLite {
    private static final Logger LOGGER = Logger.getLogger(LogThreadsHoldingLockAgent.class.getName());
    public static final String THREAD_OWNING_MSG = "Thread holding lock to session: ";
    public static final String THREADS_OWNING_MSG = "Threads holding lock to session: ";
    static final long serialVersionUID = 2890808984171907107L;
    private String m_sId;

    public LogThreadsHoldingLockAgent() {
    }

    public LogThreadsHoldingLockAgent(String sId) {
        this.m_sId = sId;
    }

    public void run() {
        try {
            if (SessionHelper.s_collections != null) {
                Iterator i = SessionHelper.s_collections.iterator();
                while (i.hasNext()) {
                    this.logThreadStackTraces(this.m_sId, (AbstractHttpSessionCollection)i.next());
                }
            }
        }
        catch (Throwable t) {
            SessionHelper.log((Throwable)t);
        }
    }

    protected void logThreadStackTraces(String sId, AbstractHttpSessionCollection collection) {
        NamedCache ownedCache = collection.getOwnedCache();
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)ownedCache.get((Object)sId);
        if (model != null) {
            if (collection.isThreadLockingEnforced()) {
                Thread owningThread = model.getThreadOwner();
                if (owningThread != null) {
                    StringBuilder sb = new StringBuilder(THREAD_OWNING_MSG);
                    sb.append(sId).append((CharSequence)this.threadStackTrace(owningThread));
                    this.writeToLog(sb);
                }
            } else {
                Set<Thread> enteredThreads = model.getEnteredThreads();
                if (enteredThreads != null && !enteredThreads.isEmpty()) {
                    StringBuilder sb = new StringBuilder(THREADS_OWNING_MSG).append(sId);
                    for (Thread thread : enteredThreads) {
                        sb.append(this.threadStackTrace(thread).toString());
                    }
                    this.writeToLog(sb);
                }
            }
        }
    }

    protected void writeToLog(StringBuilder s) {
        LOGGER.log(Level.INFO, s.toString());
    }

    protected StringBuilder threadStackTrace(Thread t) {
        if (t != null) {
            StackTraceElement[] stackTrace;
            StringBuilder sb = new StringBuilder("\n" + t.toString());
            for (StackTraceElement element : stackTrace = t.getStackTrace()) {
                String stackTraceElementStr = element.toString();
                sb.append("\n\tat ").append(stackTraceElementStr);
            }
            return sb;
        }
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sId = in.readUTF();
        this.setResult(in.readBoolean());
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sId);
        out.writeBoolean(this.getResult() == Boolean.TRUE);
    }
}

