/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.TraditionalHttpSessionCollection;
import com.tangosol.coherence.servlet.TraditionalHttpSessionModel;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.Serializer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OptimizedHolder
extends AttributeHolder
implements ExternalizableLite {
    private Binary m_binValue;
    private static final Logger LOGGER = Logger.getLogger(OptimizedHolder.class.getName());

    public OptimizedHolder() {
    }

    public OptimizedHolder(TraditionalHttpSessionModel model) {
        super(model);
    }

    public OptimizedHolder(String sName, Object oValue, TraditionalHttpSessionModel model) {
        super(sName, oValue, model);
    }

    @Override
    public Object getValue() {
        Object oValue = this.getInternalValue();
        if (oValue == null) {
            try {
                oValue = this.deserializeValue(this.ensureInternalBinary());
            }
            catch (WrapperException e) {
                Throwable oe = e.getOriginalException();
                if ((oe instanceof IOException || oe instanceof ClassNotFoundException) && !this.getModel().getCollection().isStrict()) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "An exception was encountered while deserializing the \"" + this.getName() + "\" attribute for session \"" + this.getModel().getId() + "\n:", e.getOriginalException());
                    }
                    return null;
                }
                throw e;
            }
            this.setInternalValue(oValue);
        }
        this.setSuspect(this.isSuspect(oValue));
        return oValue;
    }

    public Binary getBinary() {
        Binary binValue = this.getInternalBinary();
        boolean fSuspect = this.isSuspect();
        if (binValue == null || fSuspect) {
            Object oValue = this.getInternalValue();
            if (oValue == null) {
                binValue = this.ensureInternalBinary();
            } else {
                binValue = this.serializeValue(oValue);
                this.setInternalBinary(binValue);
            }
        }
        return binValue;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_binValue = this.readBinary(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        Object oValue = this.getInternalValue();
        this.setInternalValue(null);
        try {
            super.writeExternal(out);
        }
        finally {
            this.setInternalValue(oValue);
        }
        this.writeBinary(out);
    }

    protected Binary getInternalBinary() {
        return this.m_binValue;
    }

    protected Binary ensureInternalBinary() {
        Binary binValue = this.getInternalBinary();
        OptimizedHolder.azzert((binValue != null ? 1 : 0) != 0);
        return binValue;
    }

    protected void setInternalBinary(Binary binValue) {
        this.m_binValue = binValue;
    }

    protected Binary serializeValue(Object o) {
        TraditionalHttpSessionCollection collection = (TraditionalHttpSessionCollection)this.getModel().getCollection();
        return ExternalizableHelper.toBinary((Object)o, (Serializer)collection.getSerializer());
    }

    protected Object deserializeValue(Binary bin) {
        TraditionalHttpSessionCollection collection = (TraditionalHttpSessionCollection)this.getModel().getCollection();
        return ExternalizableHelper.fromBinary((Binary)bin, (Serializer)collection.getSerializer());
    }

    @Override
    protected void prepareWrite() throws IOException {
        try {
            this.getBinary();
        }
        catch (WrapperException e) {
            Throwable eOrig = e.getOriginalException();
            if (eOrig instanceof IOException) {
                throw (IOException)eOrig;
            }
            throw e;
        }
        this.setSuspect(false);
    }

    protected Binary readBinary(DataInput in) throws IOException {
        Binary binValue = new Binary();
        binValue.readExternal(in);
        return binValue;
    }

    protected void writeBinary(DataOutput out) throws IOException {
        this.getBinary().writeExternal(out);
    }
}

