/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.Base;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class RequestContext
extends Base {
    private static final String REQ_ATTR_COUNT = "coherence-count";
    private SessionHelper m_helper;
    private ServletRequest m_req;
    private ServletResponse m_res;
    private transient ServletRequest m_reqUnwrapped;

    public RequestContext(SessionHelper helper, ServletRequest req, ServletResponse res) {
        this.m_helper = helper;
        this.m_req = req;
        this.m_res = res;
    }

    public SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    public ServletRequest getServletRequest() {
        return this.m_req;
    }

    public ServletResponse getServletResponse() {
        return this.m_res;
    }

    public int getReferenceCount() {
        ServletRequest req = this.unwrapServletRequest();
        Integer ICount = (Integer)req.getAttribute(REQ_ATTR_COUNT);
        if (ICount == null) {
            ICount = 0;
            req.setAttribute(REQ_ATTR_COUNT, (Object)ICount);
        }
        return ICount;
    }

    public int incReferenceCount() {
        ServletRequest req = this.unwrapServletRequest();
        Integer ICount = (Integer)req.getAttribute(REQ_ATTR_COUNT);
        if (ICount == null) {
            ICount = 0;
        }
        ICount = ICount + 1;
        req.setAttribute(REQ_ATTR_COUNT, (Object)ICount);
        return ICount;
    }

    public int decReferenceCount() {
        ServletRequest req = this.unwrapServletRequest();
        Integer ICount = (Integer)req.getAttribute(REQ_ATTR_COUNT);
        if (ICount == null || ICount == 0) {
            throw new IllegalStateException("Illegal reference count");
        }
        ICount = ICount - 1;
        req.setAttribute(REQ_ATTR_COUNT, (Object)ICount);
        return ICount;
    }

    public String toString() {
        return "RequestContext\n" + RequestContext.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==" : "!=").append("null").append("\nServletRequest=").append(RequestContext.indentString((String)String.valueOf(this.getServletRequest()), (String)"  ", (boolean)false)).append("\nServletResponse=").append(RequestContext.indentString((String)String.valueOf(this.getServletResponse()), (String)"  ", (boolean)false)).append("\nReferenceCount=").append(this.getReferenceCount());
        return sb.toString();
    }

    protected ServletRequest unwrapServletRequest() {
        ServletRequest req = this.m_reqUnwrapped;
        if (req == null) {
            this.m_reqUnwrapped = req = this.getSessionHelper().unwrapServletRequest(this.getServletRequest());
        }
        return req;
    }
}

