/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.oracle.common.base.Blocking;
import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.CacheFactoryLogHandler;
import com.tangosol.coherence.servlet.CoherenceHttpSessionCollection;
import com.tangosol.coherence.servlet.ConfigurationConsistencyVerifier;
import com.tangosol.coherence.servlet.ConfigurationImpl;
import com.tangosol.coherence.servlet.HttpRequestContext;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionModel;
import com.tangosol.coherence.servlet.IncrementalReapTask;
import com.tangosol.coherence.servlet.ParallelReapTask;
import com.tangosol.coherence.servlet.RequestContext;
import com.tangosol.coherence.servlet.ServiceHelper;
import com.tangosol.coherence.servlet.ServiceHelperDefault;
import com.tangosol.coherence.servlet.ServiceHelperLazy;
import com.tangosol.coherence.servlet.SessionHelperConfiguration;
import com.tangosol.coherence.servlet.SessionHelperFactory;
import com.tangosol.coherence.servlet.SessionReaperStatistics;
import com.tangosol.coherence.servlet.ValidatingConfiguration;
import com.tangosol.coherence.servlet.commonj.WorkManager;
import com.tangosol.coherence.servlet.commonj.impl.WorkManagerImpl;
import com.tangosol.coherence.servlet.management.HttpSessionManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.InvocationService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.management.Registry;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.TaskDaemon;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionListener;

public class SessionHelper
extends Base {
    private static final Logger LOGGER = Logger.getLogger(SessionHelper.class.getName());
    public static final String PRODUCT_BANNER = CacheFactory.PRODUCT + ' ' + CacheFactory.VERSION;
    public static final String CACHE_CONFIGURATION_PATH = "session-cache-config.xml";
    public static final String DEFAULT_CACHE_CONFIGURATION_PATH = "default-session-cache-config.xml";
    public static final int EVT_ADDED = 1;
    public static final String SESSION_AFFINITY_SUFFIX_STRIPPED = "session-affinity-suffix-stripped";
    public static final int EVT_REMOVED = 2;
    public static final int EVT_REPLACED = 3;
    public static final String CTX_INIT_CONFIGURATION_CONSISTENCY = "coherence-configuration-consistency";
    public static final String CTX_INIT_APPLICATION_NAME = "coherence-application-name";
    public static final String CTX_INIT_FACTORY = "coherence-factory-class";
    public static final String CTX_INIT_COLLECTION = "coherence-sessioncollection-class";
    public static final String CTX_INIT_CLUSTER_OWNED = "coherence-cluster-owned";
    public static final String CTX_INIT_CLUSTER = "coherence-servletcontext-clustered";
    public static final String CTX_INIT_CACHENAME_CONTEXT = "coherence-servletcontext-cachename";
    public static final String CTX_INIT_LISTENS = "coherence-eventlisteners";
    public static final String CTX_INIT_SESSIONCONTEXT_ENABLED = "coherence-enable-sessioncontext";
    public static final String CTX_INIT_SESSION_RETAIN_MILLIS = "coherence-contextless-session-retain-millis";
    public static final String CTX_INIT_COOKIES_ENABLED = "coherence-session-cookies-enabled";
    public static final String CTX_INIT_COOKIE_NAME = "coherence-session-cookie-name";
    public static final String CTX_INIT_COOKIE_DOMAIN = "coherence-session-cookie-domain";
    public static final String CTX_INIT_COOKIE_PATH = "coherence-session-cookie-path";
    public static final String CTX_INIT_COOKIE_MAX_AGE = "coherence-session-cookie-max-age";
    public static final String CTX_INIT_COOKIE_SECURE = "coherence-session-cookie-secure";
    public static final String CTX_INIT_COOKIE_HTTPONLY = "coherence-session-cookie-httponly";
    public static final String CTX_INIT_URLENCODE_ENABLED = "coherence-session-urlencode-enabled";
    public static final String CTX_INIT_URLENCODE_NAME = "coherence-session-urlencode-name";
    public static final String CTX_INIT_URLDECODE_DEFAULT = "coherence-session-urldecode-bycontainer";
    public static final String CTX_INIT_URLENCODE_DEFAULT = "coherence-session-urlencode-bycontainer";
    public static final String CTX_INIT_DAEMON_PRIORITY = "coherence-reaperdaemon-priority";
    public static final String CTX_INIT_DAEMON_CYCLE_SECS = "coherence-reaperdaemon-cycle-seconds";
    public static final String CTX_INIT_DAEMON_COORDINATED = "coherence-reaperdaemon-cluster-coordinated";
    public static final String CTX_INIT_DAEMON_ASSUME_LOCALITY = "coherence-reaperdaemon-assume-locality";
    public static final String CTX_INIT_DAEMON_SWEEP_MODULO = "coherence-reaperdaemon-sweep-modulo";
    public static final String CTX_INIT_DAEMON_PARALLEL = "coherence-reaperdaemon-parallel";
    public static final String CTX_INIT_DAEMON_MIN_THREADS = "coherence-reaperdaemon-min-threads";
    public static final String CTX_INIT_DAEMON_MAX_THREADS = "coherence-reaperdaemon-max-threads";
    public static final String CTX_INIT_DAEMON_QUEUE_SIZE = "coherence-reaperdaemon-queue-size";
    public static final String CTX_INIT_LOGGER_LEVEL = "coherence-session-logger-level";
    public static final String CTX_INIT_CACHENAME_MANAGEMENT = "coherence-session-management-cachename";
    public static final String CTX_INIT_CACHENAME_SESSIONS = "coherence-session-cachename";
    public static final String CTX_INIT_CACHENAME_OVERFLOW = "coherence-session-overflow-cachename";
    public static final String CTX_INIT_CACHENAME_LOCAL_SESSIONS = "coherence-local-session-cachename";
    public static final String CTX_INIT_CACHENAME_LOCAL_ATTRIBUTES = "coherence-local-attribute-cachename";
    public static final String CTX_INIT_SESSION_EXPIRE_SECS = "coherence-session-expire-seconds";
    public static final String CTX_INIT_SESSION_ID_LENGTH = "coherence-session-id-length";
    public static final String CTX_INIT_SESSION_ID_GENERATOR_CLASS = "coherence-session-id-generator-class";
    public static final String CTX_INIT_CACHE_DELEGATOR_CLASS = "coherence-cache-delegator-class";
    public static final String CTX_INIT_SESSION_LOG_INVALIDATION_EXCEPTIONS = "coherence-session-log-invalidation-exceptions";
    public static final String CTX_INIT_ATTR_OVERFLOW_THRESHOLD = "coherence-attribute-overflow-threshold";
    public static final String CTX_INIT_SESSION_LOCK = "coherence-session-locking";
    public static final String CTX_INIT_SESSION_MEMBER_LOCK = "coherence-session-member-locking";
    public static final String CTX_INIT_SESSION_APP_LOCK = "coherence-session-app-locking";
    public static final String CTX_INIT_SESSION_THREAD_LOCK = "coherence-session-thread-locking";
    public static final String CTX_INIT_SESSION_GET_LOCK_TIMEOUT = "coherence-session-get-lock-timeout";
    public static final String CTX_INIT_SESSION_AFFINITY_TOKEN = "coherence-session-affinity-token";
    public static final String CTX_INIT_SESSION_REPLACE_AFFINITY_TOKEN = "coherence-session-replace-affinity-token";
    public static final String CTX_INIT_SESSION_LOCKING_MODE = "coherence-session-locking-mode";
    public static final String CTX_INIT_SESSION_LOCKING_MODE_APP = "app";
    public static final String CTX_INIT_SESSION_LOCKING_MODE_MEMBER = "member";
    public static final String CTX_INIT_SESSION_LOCKING_MODE_NONE = "none";
    public static final String CTX_INIT_SESSION_LOCKING_MODE_OPTIMISTIC = "optimistic";
    public static final String CTX_INIT_SESSION_LOCKING_MODE_THREAD = "thread";
    public static final String CTX_INIT_LOG_THREADS_HOLDING_LOCK = "coherence-session-log-threads-holding-lock";
    public static final String CTX_INIT_SESSION_STRICT_SPEC = "coherence-session-strict-spec";
    public static final String CTX_INIT_SESSION_LAZY_ACCESS = "coherence-session-lazy-access";
    public static final String CTX_INIT_SHUTDOWN_DELAY_SECS = "coherence-shutdown-delay-seconds";
    public static final String CTX_INIT_SERVLET = "coherence-servlet-class";
    public static final String CTX_INIT_FILTER = "coherence-filter-class";
    public static final String CTX_INIT_DIST_CONTROLLER_CLASS = "coherence-distributioncontroller-class";
    public static final String CTX_INIT_SCOPE_CONTROLLER_CLASS = "coherence-scopecontroller-class";
    public static final String CTX_INIT_SESSION_STICKY = "coherence-sticky-sessions";
    public static final String CTX_INIT_SERVICENAME_OWNERSHIP = "coherence-ownership-service";
    public static final String CTX_INIT_ALLOW_LOCAL_ATTRIBUTES = "coherence-preserve-attributes";
    public static final String CTX_INIT_ENABLE_SUSPECT_ATTRIBUTES = "coherence-enable-suspect-attributes";
    public static final String CTX_INIT_ENABLE_ATTR_LISTENER_OPTIMIZATION = "coherence-enable-attribute-listener-optimization";
    protected static final String CTX_INIT_APPLICATION_NAME_GENERATED = "coherence-application-name-generated";
    protected static final String CTX_INIT_SESSION_EXPIRY_FILTER_FACTORY = "coherence-session-expiry-filter-factory-class";
    public static final String CTX_INIT_ENABLE_SESSION_ACCESS_DEBUG_LOGGING = "coherence-session-enable-debug-logging";
    public static final String CTX_INIT_SESSION_ACCESS_DEBUG_LOGGING_FILTER = "coherence-session-debug-logging-filter";
    public static final String CTX_INIT_CACHE_CONFIGURATION_PATH = "coherence-cache-configuration-path";
    public static final String CTX_INIT_SESSION_CACHE_FEDERATED = "coherence-session-cache-federated";
    public static final String CTX_INIT_SESSION_REAPING_MECHANISM = "coherence-session-reaping-mechanism";
    public static final String CTX_ATTR_CONTEXT = "coherence-context";
    public static final String REQ_ATTR_COUNT = "coherence-count";
    public static final String REQ_ATTR_SESSION = "coherence-session";
    public static final String REQ_ATTR_TEST = "coherence-test";
    public static final String DEFAULT_CTXNAME = "servletcontext-storage";
    public static final String DEFAULT_MGTNAME = "session-management";
    public static final String CFG_KEY_REAPER = "reaper-status";
    public static final String DEFAULT_FEDERATED_CACHE_CONFIGURATION_PATH = "default-federated-session-cache-config.xml";
    static final int SHUTDOWN_TIMEOUT = 10000;
    public static final String REMOTE_DELETE_REAPING_MECHANISM = "RemoteDelete";
    public static final String DEFAULT_REAPING_MECHANISM = "Default";
    public static final com.tangosol.util.Filter NAME_FILTER = new com.tangosol.util.Filter(){

        public boolean evaluate(Object o) {
            return !(o instanceof String) || !((String)o).startsWith("coherence-");
        }
    };
    protected ConfigurableCacheFactory m_cachefactory;
    private SessionHelperFactory m_factory;
    private ServletContext m_ctxWrapped;
    private XmlElement m_xmlConfig;
    private ServletContext m_ctxCoherence;
    private Listeners m_listeners = new Listeners();
    private Listeners m_listenersContextAttr = new Listeners();
    private Map m_mapIgnore = new SegmentedHashMap();
    private boolean m_fContextEvents;
    private int m_cContainerObjects;
    private transient NamedCache m_cacheContextAttributes;
    private transient NamedCache m_cacheConfiguration;
    private Map m_mapFilterConfig = new SegmentedHashMap();
    private Map m_mapServletConfig = new SegmentedHashMap();
    private HttpSessionContext m_ctxSessions;
    private HttpSessionCollection m_collection;
    public static List s_collections;
    private Map m_mapSession = new SegmentedHashMap();
    private SessionReaperDaemon m_daemonReaper;
    private TaskDaemon m_daemonWorker;
    private WorkManager m_workManager;
    private ReapTaskFactory m_reapTaskFactory;
    private Runnable m_taskShutdown;
    private SessionHelperConfiguration m_configuration;
    private ServiceHelper m_serviceHelper;
    private Handler m_cacheFactoryLogHandler;
    private boolean m_warnAboutSessionListenerInRemoteDelete = true;
    public static final ThreadLocal<Boolean> s_tloReaperFlag;

    public SessionHelper(SessionHelperFactory factory, ServletContext ctx) {
        this.m_factory = factory;
        this.m_ctxWrapped = ctx;
    }

    protected void configure() {
        boolean isApplicationNameGenerated;
        this.configureLogger();
        this.checkEdition();
        ServletContext ctx = this.getWrappedServletContext();
        String applicationName = ctx.getInitParameter(CTX_INIT_APPLICATION_NAME);
        if (applicationName == null) {
            applicationName = ctx.getServletContextName();
        }
        if (applicationName == null || applicationName.length() == 0) {
            isApplicationNameGenerated = true;
            applicationName = "web-app-" + ((Object)((Object)this)).getClass().getClassLoader().hashCode();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "No name was configured for this web application. Generated web application name is: " + applicationName);
            }
        } else {
            isApplicationNameGenerated = false;
        }
        SimpleElement xml = new SimpleElement("config");
        xml.ensureElement(CTX_INIT_APPLICATION_NAME).setString(applicationName);
        xml.ensureElement(CTX_INIT_APPLICATION_NAME_GENERATED).setBoolean(isApplicationNameGenerated);
        Enumeration enmr = ctx.getInitParameterNames();
        while (enmr.hasMoreElements()) {
            String sName = (String)enmr.nextElement();
            if (!XmlHelper.isNameValid((String)sName) || CTX_INIT_APPLICATION_NAME.equals(sName) || CTX_INIT_APPLICATION_NAME_GENERATED.equals(sName)) continue;
            try {
                String sValue = ctx.getInitParameter(sName).trim();
                if (sValue.length() <= 0) continue;
                xml.ensureElement(sName).setString(sValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.setConfig((XmlElement)xml);
        this.setConfiguration(new ConfigurationImpl.XmlElementBuilder(this.getConfigurableCacheFactory()).setXmlElement((XmlElement)xml).setVersionMajor(ctx.getMajorVersion()).setVersionMinor(ctx.getMajorVersion()).build());
        this.updateLogger(this.m_configuration.getLoggerLevel());
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, this.m_configuration.toString());
        }
        this.m_serviceHelper = this.createServiceHelper();
        this.m_ctxCoherence = this.getFactory().instantiateServletContext();
        ctx.setAttribute(CTX_ATTR_CONTEXT, (Object)this.m_ctxCoherence);
        if (this.m_configuration.isServletContextClustered()) {
            this.ensureServletContextAttributeCache();
        }
        CoherenceHttpSessionCollection collection = this.instantiateHttpSessionCollection();
        collection.configure((XmlElement)xml, this);
        this.m_collection = collection;
        if (this.m_configuration.isConfigurationConsistencyRequired()) {
            this.checkConfigConsistency(this.m_configuration);
        }
        this.m_daemonReaper = this.instantiateSessionReaperDaemon();
        if (this.m_configuration.isReapingParallel()) {
            this.m_workManager = this.getWorkManager();
            if (this.m_workManager != null) {
                this.m_reapTaskFactory = new ReapTaskFactory(){

                    @Override
                    public Runnable createTask(Iterator<String> iterIds, int cEstimatedSessions) {
                        return new ParallelReapTask(SessionHelper.this, SessionHelper.this.m_daemonReaper, iterIds, SessionHelper.this.m_workManager);
                    }
                };
            }
        }
        if (this.m_reapTaskFactory == null) {
            this.m_reapTaskFactory = new ReapTaskFactory(){

                @Override
                public Runnable createTask(Iterator<String> iterIds, int cEstimatedSessions) {
                    return new IncrementalReapTask(SessionHelper.this, SessionHelper.this.m_daemonReaper, iterIds, cEstimatedSessions);
                }
            };
        }
        this.m_daemonReaper.start();
        this.m_taskShutdown = new Runnable(){

            @Override
            public void run() {
                SessionHelper.this.shutdownSessionHelper();
            }

            public String toString() {
                return "Shutting down Coherence session management module.";
            }
        };
        this.registerMBean();
    }

    protected void shutdownSessionHelper() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, this.toString());
        }
        Logger logger = Logger.getLogger("com.tangosol.coherence.servlet");
        logger.removeHandler(this.m_cacheFactoryLogHandler);
        if (this.m_workManager != null) {
            this.m_workManager.shutdown(10000L);
        }
        SessionHelper helper = this;
        helper.shutdownSessionReaperDaemon();
        helper.shutdownSessionWorkerDaemon();
        helper.unregisterMBean();
        this.shutdownSessionHelperCaches(helper);
        this.m_mapSession.clear();
        this.m_cachefactory = null;
    }

    protected void shutdownSessionHelperCaches(SessionHelper helper) {
        helper.shutdownHttpSessionCollection();
        helper.shutdownServletContextAttributeCache();
        helper.shutdownConfigurationCache();
        if (helper.isClusterOwned()) {
            CacheFactory.shutdown();
        } else {
            CacheFactory.getCacheFactoryBuilder().release(this.m_cachefactory);
        }
    }

    protected void configureLogger() {
        Logger logger = Logger.getLogger("com.tangosol.coherence.servlet");
        this.m_cacheFactoryLogHandler = new CacheFactoryLogHandler();
        logger.addHandler(this.m_cacheFactoryLogHandler);
    }

    private void updateLogger(Level level) {
        Logger logger = Logger.getLogger("com.tangosol.coherence.servlet");
        logger.setLevel(level);
    }

    protected void ensureCluster() {
        CacheFactory.ensureCluster();
    }

    private void checkEdition() {
        String sEdition = CacheFactory.getEdition();
        if (!"EE".equals(sEdition) && !"GE".equals(sEdition)) {
            LOGGER.log(Level.SEVERE, "Coherence " + sEdition + " is not supported by Coherence*Web.");
            throw new RuntimeException("Coherence " + sEdition + " is not supported by Coherence*Web.");
        }
    }

    void setConfiguration(SessionHelperConfiguration config) {
        this.m_configuration = config;
    }

    protected void checkConfigConsistency(ValidatingConfiguration configuration) {
        this.getConfigurationConsistencyVerifier().checkConfigConsistency(configuration);
    }

    protected ConfigurationConsistencyVerifier getConfigurationConsistencyVerifier() {
        return new ConfigurationConsistencyVerifier(this.getConfigurationCache());
    }

    public void clearStoredConfiguration() {
        this.getConfigurationConsistencyVerifier().clearStoredConfiguration();
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public void setConfig(XmlElement xml) {
        SessionHelper.azzert((this.m_xmlConfig == null ? 1 : 0) != 0);
        SessionHelper.azzert((xml != null ? 1 : 0) != 0);
        this.m_xmlConfig = xml;
    }

    public void setConfigurableCacheFactory(ConfigurableCacheFactory cacheFactory) {
        this.m_cachefactory = cacheFactory;
    }

    public synchronized ConfigurableCacheFactory getConfigurableCacheFactory() {
        if (this.m_cachefactory == null) {
            ClassLoader cl = SessionHelper.class.getClassLoader();
            ServletContext sc = this.getServletContext();
            if (sc == null) {
                sc = this.getWrappedServletContext();
            }
            this.m_cachefactory = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(SessionHelper.getCacheConfigPath(sc, cl), cl);
        }
        return this.m_cachefactory;
    }

    public static String getCacheConfigPath(ServletContext servletContext, ClassLoader appClassLoader) {
        String cachePath = ConfigurationImpl.getStringValue(CTX_INIT_CACHE_CONFIGURATION_PATH);
        if (cachePath == null) {
            cachePath = SessionHelper.parseString(servletContext, CTX_INIT_CACHE_CONFIGURATION_PATH, null);
        }
        if (cachePath != null) {
            return cachePath;
        }
        if (appClassLoader != null && appClassLoader.getResource(CACHE_CONFIGURATION_PATH) != null) {
            return CACHE_CONFIGURATION_PATH;
        }
        return SessionHelper.parseBoolean(servletContext, CTX_INIT_SESSION_CACHE_FEDERATED, false) ? DEFAULT_FEDERATED_CACHE_CONFIGURATION_PATH : DEFAULT_CACHE_CONFIGURATION_PATH;
    }

    public NamedCache getCache(String sCacheName) {
        return this.getConfigurableCacheFactory().ensureCache(sCacheName, SessionHelper.class.getClassLoader());
    }

    public InvocationService getInvocationService(String sService) {
        InvocationService service = (InvocationService)this.getConfigurableCacheFactory().ensureService(sService);
        service.setContextClassLoader(SessionHelper.class.getClassLoader());
        return service;
    }

    protected String getApplicationName() {
        return this.m_configuration.getApplicationName();
    }

    protected String getMBeanObjectName() {
        Registry registry = this.getRegistry();
        if (registry == null) {
            return null;
        }
        return registry.ensureGlobalName("type=HttpSessionManager") + ",appId=" + this.getApplicationName();
    }

    protected Object instantiateMBean() {
        return new HttpSessionManager(this, this.m_daemonReaper);
    }

    protected void registerMBean() {
        block4: {
            Registry registry = this.getRegistry();
            if (registry != null) {
                Object oBean = this.instantiateMBean();
                String sName = this.getMBeanObjectName();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Registering MBean using object name \"" + sName + '\"');
                }
                try {
                    registry.register(sName, oBean);
                }
                catch (RuntimeException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    Throwable cause = SessionHelper.getOriginalException((RuntimeException)e);
                    LOGGER.log(Level.SEVERE, "Failed to register " + oBean + " using object name \"" + sName, cause);
                }
            }
        }
    }

    protected void unregisterMBean() {
        block4: {
            Registry registry = this.getRegistry();
            if (registry != null) {
                String sName = this.getMBeanObjectName();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unregistering MBean with object name \"" + sName + '\"');
                }
                try {
                    registry.unregister(sName);
                }
                catch (RuntimeException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    Throwable cause = SessionHelper.getOriginalException((RuntimeException)e);
                    LOGGER.log(Level.SEVERE, "Failed to unregister MBean with object name \"" + sName, cause);
                }
            }
        }
    }

    protected Registry getRegistry() {
        return CacheFactory.getCluster().getManagement();
    }

    public void contextInitialized() {
        this.m_fContextEvents = true;
    }

    public void contextDestroyed() {
        this.shutdown();
    }

    public void servletInitialized() {
        if (!this.m_fContextEvents) {
            ++this.m_cContainerObjects;
        }
    }

    public void servletDestroyed() {
        if (!this.m_fContextEvents && --this.m_cContainerObjects <= 0) {
            this.shutdown();
        }
    }

    public void filterInitialized() {
        if (!this.m_fContextEvents) {
            ++this.m_cContainerObjects;
        }
    }

    public void filterDestroyed() {
        if (!this.m_fContextEvents && --this.m_cContainerObjects <= 0) {
            this.shutdown();
        }
    }

    protected void shutdown() {
        if (this.m_taskShutdown == null) {
            return;
        }
        long cDelayMillis = this.getShutdownDelayMillis();
        if (cDelayMillis == 0L) {
            this.m_taskShutdown.run();
        } else {
            try {
                this.ensureSessionWorkerDaemon().scheduleTask(this.m_taskShutdown, SessionHelper.getSafeTimeMillis() + cDelayMillis);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to schdule shutdown task. Running shutdown task immediately", e);
                this.m_taskShutdown.run();
            }
        }
    }

    protected boolean isClusterOwned() {
        return this.m_configuration.isClusterOwned();
    }

    protected long getShutdownDelayMillis() {
        return Math.max(0L, Math.min(86400000L, (long)this.m_configuration.getShutdownDelaySeconds() * 1000L));
    }

    public ServletContext getServletContext() {
        return this.m_ctxCoherence;
    }

    public NamedCache getServletContextAttributeCache() {
        NamedCache map = this.m_cacheContextAttributes;
        if (map != null || !this.isServletContextClustered()) {
            return map;
        }
        return this.ensureServletContextAttributeCache();
    }

    protected synchronized NamedCache ensureServletContextAttributeCache() {
        NamedCache map = this.m_cacheContextAttributes;
        if (map != null || !this.isServletContextClustered()) {
            return map;
        }
        String sCache = this.getWrappedServletContext().getInitParameter(CTX_INIT_CACHENAME_CONTEXT);
        if (sCache == null || sCache.trim().length() == 0) {
            sCache = DEFAULT_CTXNAME;
        }
        this.m_cacheContextAttributes = map = this.getCache(sCache);
        return map;
    }

    protected void shutdownServletContextAttributeCache() {
        NamedCache map = this.m_cacheContextAttributes;
        if (map != null) {
            try {
                CacheFactory.releaseCache((NamedCache)map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getServletContextMajorVersion() {
        return this.m_configuration.getServletContextVersionMajor();
    }

    public int getServletContextMinorVersion() {
        return this.m_configuration.getServletContextVersionMinor();
    }

    public ServletContext getWrappedServletContext() {
        return this.m_ctxWrapped;
    }

    public boolean isServletContextClustered() {
        return this.m_configuration.isServletContextClustered();
    }

    public boolean isStrict() {
        return this.m_configuration.isStrict();
    }

    public static String parseString(ServletContext ctx, String sParam, String sDefault) {
        if (ctx == null) {
            return sDefault;
        }
        String sOpt = ctx.getInitParameter(sParam);
        if (sOpt == null) {
            return sDefault;
        }
        if ((sOpt = sOpt.trim()).length() == 0) {
            return sDefault;
        }
        return sOpt;
    }

    public static boolean parseBoolean(ServletContext ctx, String sParam, boolean fDefault) {
        switch (SessionHelper.parseString(ctx, sParam, "?").charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
            case '0': 
            case 'F': 
            case 'N': 
            case 'f': 
            case 'n': {
                return false;
            }
        }
        return fDefault;
    }

    public static int parseInt(ServletContext ctx, String sParam, int nDefault) {
        String sOpt = SessionHelper.parseString(ctx, sParam, null);
        if (sOpt == null) {
            return nDefault;
        }
        try {
            return Integer.parseInt(sOpt);
        }
        catch (NumberFormatException e) {
            return nDefault;
        }
    }

    public Listeners getListeners() {
        return this.m_listeners;
    }

    public void setListeners(Listeners listeners) {
        this.m_listeners = listeners;
        if (!listeners.isEmpty()) {
            Listeners listenersCtxAttr = this.getContextAttributeListeners();
            SessionHelper.azzert((boolean)listenersCtxAttr.isEmpty());
            HttpSessionCollection collection = this.getHttpSessionCollection();
            for (EventListener listener : listeners.listeners()) {
                if (listener instanceof ServletContextAttributeListener) {
                    listenersCtxAttr.add(listener);
                }
                if (listener instanceof HttpSessionListener) {
                    collection.addHttpSessionListener((HttpSessionListener)listener);
                }
                if (!(listener instanceof HttpSessionAttributeListener)) continue;
                collection.addHttpSessionAttributeListener((HttpSessionAttributeListener)listener);
            }
            this.logWarningIfRemoteDeleteMechanismConfigured();
        }
    }

    protected Listeners getContextAttributeListeners() {
        return this.m_listenersContextAttr;
    }

    public synchronized void addIgnoreAttributeName(String sName) {
        Map map = this.m_mapIgnore;
        Integer IRefs = (Integer)map.get(sName);
        int cRefs = IRefs == null ? 0 : IRefs;
        IRefs = ++cRefs;
        map.put(sName, IRefs);
    }

    public synchronized void removeIgnoreAttributeName(String sName) {
        Map map = this.m_mapIgnore;
        Integer IRefs = (Integer)map.get(sName);
        if (IRefs == null) {
            throw new IllegalStateException("could not decrement reference count for " + sName + " because the name is not registered as ignored");
        }
        int cRefs = IRefs;
        if (--cRefs <= 0) {
            map.remove(sName);
        } else {
            IRefs = cRefs;
            map.put(sName, IRefs);
        }
    }

    protected boolean isAttributeNameIgnored(String sName) {
        return this.m_mapIgnore.containsKey(sName);
    }

    public void dispatchAttributeEvent(int nEvent, ServletContextAttributeEvent evt) {
        if (!this.isAttributeNameIgnored(evt.getName())) {
            this.dispatchInternalAttributeEvent(nEvent, evt);
        }
    }

    public void dispatchInternalAttributeEvent(int nEvent, ServletContextAttributeEvent evt) {
        RuntimeException eFirst = null;
        Listeners listeners = this.getContextAttributeListeners();
        if (!listeners.isEmpty()) {
            ServletContext ctx = this.getServletContext();
            if (ctx == null) {
                return;
            }
            if (evt.getSource() != ctx) {
                evt = new ServletContextAttributeEvent(ctx, evt.getName(), evt.getValue());
            }
            EventListener[] alisteners = listeners.listeners();
            int c = alisteners.length;
            for (int i = 0; i < c; ++i) {
                ServletContextAttributeListener listener = (ServletContextAttributeListener)alisteners[i];
                try {
                    switch (nEvent) {
                        case 1: {
                            listener.attributeAdded(evt);
                            break;
                        }
                        case 2: {
                            listener.attributeRemoved(evt);
                            break;
                        }
                        case 3: {
                            listener.attributeReplaced(evt);
                        }
                    }
                    continue;
                }
                catch (EventDeathException e) {
                    break;
                }
                catch (RuntimeException e) {
                    ctx.log(PRODUCT_BANNER + ": ServletContextAttributeListener encountered an exception while invoking an application listener: " + listener.getClass().getName(), (Throwable)e);
                    if (eFirst != null) continue;
                    eFirst = e;
                }
            }
        }
        if (eFirst != null) {
            throw eFirst;
        }
    }

    public FilterConfig wrapFilterConfig(FilterConfig cfg) {
        FilterConfig cfgWrapper;
        FilterConfig[] acfg = (FilterConfig[])this.m_mapFilterConfig.get(cfg.getFilterName());
        if (acfg != null && acfg[0] == cfg) {
            cfgWrapper = acfg[1];
        } else {
            cfgWrapper = this.getFactory().instantiateFilterConfig(cfg);
            this.m_mapFilterConfig.put(cfg.getFilterName(), new FilterConfig[]{cfg, cfgWrapper});
        }
        return cfgWrapper;
    }

    public FilterConfig unwrapFilterConfig(FilterConfig cfg) {
        FilterConfig cfgUnwrapped = null;
        FilterConfig[] acfg = (FilterConfig[])this.m_mapFilterConfig.get(cfg.getFilterName());
        if (acfg != null && acfg[1] == cfg) {
            cfgUnwrapped = acfg[0];
        }
        return cfgUnwrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(Filter filter, ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        RequestContext ctx = this.preService(req, resp);
        try {
            filter.doFilter(ctx.getServletRequest(), ctx.getServletResponse(), chain);
        }
        finally {
            this.postService(ctx);
        }
    }

    public ServletConfig wrapServletConfig(ServletConfig cfg) {
        ServletConfig cfgWrapper;
        ServletConfig[] acfg = (ServletConfig[])this.m_mapServletConfig.get(cfg.getServletName());
        if (acfg != null && acfg[0] == cfg) {
            cfgWrapper = acfg[1];
        } else {
            cfgWrapper = this.getFactory().instantiateServletConfig(cfg);
            this.m_mapServletConfig.put(cfg.getServletName(), new ServletConfig[]{cfg, cfgWrapper});
        }
        return cfgWrapper;
    }

    public ServletConfig unwrapServletConfig(ServletConfig cfg) {
        ServletConfig cfgUnwrapped = null;
        ServletConfig[] acfg = (ServletConfig[])this.m_mapServletConfig.get(cfg.getServletName());
        if (acfg != null && acfg[1] == cfg) {
            cfgUnwrapped = acfg[0];
        }
        return cfgUnwrapped;
    }

    public boolean isServletRequestWrapped(ServletRequest req) {
        boolean fWrapped;
        while (!(fWrapped = req.getAttribute(REQ_ATTR_TEST) != null) && req instanceof ServletRequestWrapper) {
            req = ((ServletRequestWrapper)req).getRequest();
        }
        return fWrapped;
    }

    public ServletRequest wrapServletRequest(ServletRequest req, ServletResponse res) {
        if (req instanceof HttpServletRequest) {
            SessionHelperFactory factory = this.getFactory();
            HttpServletRequest httpreq = (HttpServletRequest)req;
            HttpServletResponse httpres = (HttpServletResponse)res;
            String sSessionId = null;
            boolean fCookie = false;
            boolean fUrl = false;
            if (this.isSessionIdCookieEnabled()) {
                sSessionId = this.decodeCookie(httpreq);
                boolean bl = fCookie = sSessionId != null;
            }
            if (sSessionId == null && this.isSessionIdEncodingEnabled()) {
                if (this.isUseDefaultSessionIdDecoding()) {
                    String sValue = httpreq.getRequestedSessionId();
                    if (sValue != null && sValue.length() > 0 && httpreq.isRequestedSessionIdFromURL()) {
                        sSessionId = sValue;
                        fUrl = true;
                    }
                } else {
                    sSessionId = this.decodeUrl(httpreq);
                    fUrl = sSessionId != null;
                }
            }
            req = factory.instantiateHttpServletRequest(httpreq, httpres, sSessionId, fCookie, fUrl);
        }
        return req;
    }

    public ServletRequest unwrapServletRequest(ServletRequest req) {
        while (req instanceof ServletRequestWrapper) {
            req = ((ServletRequestWrapper)req).getRequest();
        }
        return req;
    }

    public String decodeCookie(HttpServletRequest req) {
        String sCookie = this.getSessionIdCookieName();
        Cookie[] acookie = req.getCookies();
        if (acookie != null) {
            for (Cookie cookie : acookie) {
                int index;
                String sValue;
                if (!cookie.getName().equals(sCookie) || (sValue = cookie.getValue()) == null || (sValue = sValue.trim()).length() <= 0) continue;
                if (this.getSessionIdAffinityToken() != null && (index = sValue.indexOf(this.getSessionIdAffinityToken())) > 0) {
                    if (this.isSessionIdReplaceAffinityToken()) {
                        req.setAttribute(SESSION_AFFINITY_SUFFIX_STRIPPED, (Object)true);
                    }
                    return sValue.substring(0, index);
                }
                return sValue;
            }
        }
        return null;
    }

    public void encodeCookie(HttpServletRequest req, HttpServletResponse res, String sId, boolean fNew) {
        Boolean replaceCookie;
        if (req != null && this.isSessionIdReplaceAffinityToken() && (replaceCookie = (Boolean)req.getAttribute(SESSION_AFFINITY_SUFFIX_STRIPPED)) != null && replaceCookie.booleanValue()) {
            fNew = true;
            req.removeAttribute(SESSION_AFFINITY_SUFFIX_STRIPPED);
        }
        if (fNew) {
            if (res == null) {
                throw new IllegalStateException("Failed to encode session cookie because the response object is not yet available");
            }
            if (res.isCommitted() && this.isStrict()) {
                throw new IllegalStateException("Failed to encode session cookie because the response was already committed");
            }
            String sDomain = this.getSessionIdCookieDomain();
            String sPath = this.getSessionIdCookiePath();
            int cSeconds = this.getSessionIdCookieMaxAge();
            if (this.getSessionIdCookieHttpOnly()) {
                String cookieStr = this.getSessionIdCookieName() + "=" + sId;
                if (sDomain != null) {
                    cookieStr = cookieStr + "; Domain=" + sDomain;
                }
                if (sPath != null) {
                    cookieStr = cookieStr + "; Path=" + sPath;
                }
                if (cSeconds > 0) {
                    Date expireDate = new Date();
                    expireDate.setTime(expireDate.getTime() + (long)(cSeconds * 1000));
                    SimpleDateFormat header_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    header_format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                    cookieStr = cookieStr + "; Expires=" + header_format.format(expireDate);
                }
                if (this.getSessionIdCookieSecure()) {
                    cookieStr = cookieStr + "; Secure";
                }
                cookieStr = cookieStr + "; HttpOnly";
                res.setHeader("Set-Cookie", cookieStr);
            } else {
                Cookie cookie = new Cookie(this.getSessionIdCookieName(), sId);
                if (sDomain != null) {
                    cookie.setDomain(sDomain);
                }
                if (sPath != null) {
                    cookie.setPath(sPath);
                }
                if (cSeconds > 0) {
                    cookie.setMaxAge(cSeconds);
                }
                if (this.getSessionIdCookieSecure()) {
                    cookie.setSecure(true);
                }
                res.addCookie(cookie);
            }
        }
    }

    public boolean isSessionIdCookie(Cookie cookie) {
        return cookie.getName().equals(this.getSessionIdCookieName());
    }

    public RequestContext createRequestContext(ServletRequest req, ServletResponse res) {
        HttpServletResponse httpres;
        HttpServletRequest httpreq;
        if (!this.isServletRequestWrapped(req) && (req = this.wrapServletRequest(req, res)) instanceof HttpServletRequest) {
            httpreq = (HttpServletRequest)req;
            httpres = (HttpServletResponse)res;
            res = this.getFactory().instantiateHttpServletResponse(httpreq, httpres);
        }
        if (req instanceof HttpServletRequest) {
            httpreq = (HttpServletRequest)req;
            httpres = (HttpServletResponse)res;
            return new HttpRequestContext(this, httpreq, httpres);
        }
        return new RequestContext(this, req, res);
    }

    protected ServiceHelper createServiceHelper() {
        if (this.m_configuration.isSessionLazyAccess()) {
            return new ServiceHelperLazy(this);
        }
        return new ServiceHelperDefault(this);
    }

    public RequestContext preService(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        boolean fFirst;
        RequestContext ctx = this.createRequestContext(req, res);
        boolean bl = fFirst = ctx.incReferenceCount() == 1;
        if (fFirst && ctx instanceof HttpRequestContext) {
            HttpRequestContext httpctx = (HttpRequestContext)ctx;
            HttpServletRequest httpreq = httpctx.getHttpServletRequest();
            this.m_serviceHelper.enterSession(httpreq);
        }
        return ctx;
    }

    public void postService(RequestContext ctx) throws ServletException, IOException {
        boolean fLast;
        boolean bl = fLast = ctx.decReferenceCount() == 0;
        if (fLast && ctx instanceof HttpRequestContext) {
            HttpRequestContext httpctx = (HttpRequestContext)ctx;
            HttpServletRequest httpreq = httpctx.getHttpServletRequest();
            this.m_serviceHelper.exitSession(httpreq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Servlet servlet, ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        RequestContext ctx = this.preService(req, resp);
        try {
            servlet.service(ctx.getServletRequest(), ctx.getServletResponse());
        }
        finally {
            this.postService(ctx);
        }
    }

    protected CoherenceHttpSessionCollection instantiateHttpSessionCollection() {
        String sClz = this.m_configuration.getHttpSessionCollectionClassName();
        try {
            Class<?> clz = Class.forName(sClz);
            return (CoherenceHttpSessionCollection)clz.newInstance();
        }
        catch (Exception e) {
            throw SessionHelper.ensureRuntimeException((Throwable)e);
        }
    }

    public HttpSessionCollection getHttpSessionCollection() {
        return this.m_collection;
    }

    protected Map getHttpSessionMap() {
        return this.m_mapSession;
    }

    public void removeHttpSessionFromMap(String sId) {
        this.getHttpSessionMap().remove(sId);
    }

    public Set<String> getLocalSessionIds() {
        this.checkForDeadSessions();
        return this.m_mapSession.keySet();
    }

    public HttpSession createHttpSession() {
        HttpSessionCollection collection = this.getHttpSessionCollection();
        HttpSession session = this.getFactory().instantiateHttpSession(collection);
        this.getHttpSessionMap().put(session.getId(), session);
        collection.postCreate(session);
        return session;
    }

    public HttpSession getHttpSession(String sId) {
        return (HttpSession)this.getHttpSessionMap().get(sId);
    }

    public HttpSession ensureHttpSession(String sId) {
        Map map = this.getHttpSessionMap();
        HttpSession session = (HttpSession)map.get(sId);
        if (session == null) {
            session = this.getFactory().instantiateHttpSession(this.getHttpSessionCollection(), sId);
            map.put(session.getId(), session);
        }
        return session;
    }

    public String updateSessionId(String sId, String sNewId) {
        AbstractHttpSessionCollection collection = (AbstractHttpSessionCollection)this.getHttpSessionCollection();
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)collection.get(sId);
        if (model != null) {
            if (sNewId == null) {
                sNewId = collection.generateSessionId();
            }
            model.setNewId(sNewId);
            this.removeHttpSessionFromMap(sId);
            return sNewId;
        }
        return null;
    }

    public HttpSession getHttpSession(HttpServletRequest req) {
        return (HttpSession)this.unwrapServletRequest((ServletRequest)req).getAttribute(REQ_ATTR_SESSION);
    }

    public void onGetHttpSession(HttpServletRequest req) {
        this.m_serviceHelper.onGetSession(req);
    }

    public void setHttpSession(HttpServletRequest req, HttpSession session) {
        this.unwrapServletRequest((ServletRequest)req).setAttribute(REQ_ATTR_SESSION, (Object)session);
    }

    public boolean isSessionContextEnabled() {
        return this.m_configuration.isSessionContextEnabled();
    }

    public HttpSessionContext getHttpSessionContext() {
        HttpSessionContext ctx = this.m_ctxSessions;
        if (this.m_ctxSessions == null) {
            this.m_ctxSessions = ctx = this.getFactory().instantiateHttpSessionContext();
        }
        return ctx;
    }

    public boolean isSessionIdCookieEnabled() {
        return this.m_configuration.isSessionIdCookieEnabled();
    }

    public String getSessionIdCookieName() {
        return this.m_configuration.getSessionIdCookieName();
    }

    public String getSessionIdCookieDomain() {
        return this.m_configuration.getSessionIdCookieDomain();
    }

    public String getSessionIdCookiePath() {
        return this.m_configuration.getSessionIdCookiePath();
    }

    public int getSessionIdCookieMaxAge() {
        return this.m_configuration.getSessionIdCookieMaxAgeSeconds();
    }

    public boolean getSessionIdCookieSecure() {
        return this.m_configuration.isSessionIdCookieSecure();
    }

    public boolean getSessionIdCookieHttpOnly() {
        return this.m_configuration.isSessionIdCookieHttpOnly();
    }

    public boolean isSessionIdEncodingEnabled() {
        return this.m_configuration.isSessionIdEncodingEnabled();
    }

    public String getSessionIdEncodingName() {
        return this.m_configuration.getSessionIdEncodingName();
    }

    public boolean isUseDefaultSessionIdDecoding() {
        return this.m_configuration.isUseDefaultSessionIdDecoding();
    }

    public boolean isUseDefaultSessionIdEncoding() {
        return this.m_configuration.isUseDefaultSessionIdEncoding();
    }

    public String getSessionIdAffinityToken() {
        return this.m_configuration.getSessionIdAffinityToken();
    }

    public boolean isSessionIdReplaceAffinityToken() {
        return this.m_configuration.getSessionIdReplaceAffinityToken();
    }

    public String decodeUrl(HttpServletRequest request) {
        String sUri = request.getRequestURI();
        return this.decodeUri(sUri);
    }

    protected String decodeUri(String sUri) {
        String sSessionId = null;
        int cchUri = sUri.length();
        String sParam = this.getSessionIdEncodingName();
        int cchParam = sParam.length();
        int ofParam = sUri.indexOf(59);
        while (ofParam >= 0) {
            if (cchUri - ++ofParam > cchParam && sUri.regionMatches(ofParam, sParam, 0, cchParam) && sUri.charAt(ofParam + cchParam) == '=') {
                int ofId = ofParam + cchParam + 1;
                int ofNext = sUri.indexOf(59, ofId);
                if (ofNext < 0) {
                    ofNext = cchUri;
                }
                sSessionId = sUri.substring(ofId, ofNext);
                break;
            }
            ofParam = sUri.indexOf(59, ofParam + 1);
        }
        return sSessionId;
    }

    public String encodeUrl(String sUrl, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && (session.isNew() || request.isRequestedSessionIdFromURL() && !request.isRequestedSessionIdFromCookie())) {
            sUrl = this.encodeUrl(sUrl, session.getId());
        }
        return sUrl;
    }

    protected String encodeUrl(String sUrl, String sId) {
        String sParam = this.getSessionIdEncodingName();
        int cchParam = sParam.length();
        int ofEnd = sUrl.length();
        int ofQuery = sUrl.indexOf(63);
        if (ofQuery >= 0) {
            ofEnd = ofQuery;
        }
        boolean fFound = false;
        int ofParam = sUrl.indexOf(59);
        while (ofParam >= 0 && ofParam < ofEnd) {
            if (ofEnd - ++ofParam > cchParam && sUrl.regionMatches(ofParam, sParam, 0, cchParam) && sUrl.charAt(ofParam + cchParam) == '=') {
                int ofId = ofParam + cchParam + 1;
                int ofNext = sUrl.indexOf(59, ofId);
                if (ofNext < 0) {
                    ofNext = ofEnd;
                }
                if (!sUrl.regionMatches(ofId, sId, 0, sId.length())) {
                    sUrl = sUrl.substring(0, ofId) + sId + sUrl.substring(ofNext);
                }
                fFound = true;
                break;
            }
            ofParam = sUrl.indexOf(59, ofParam + 1);
        }
        if (!fFound) {
            sUrl = sUrl.substring(0, ofEnd) + ';' + sParam + '=' + sId + sUrl.substring(ofEnd);
        }
        return sUrl;
    }

    public void enterSession(String sId) {
        if (sId != null) {
            HttpSessionCollection collection = this.getHttpSessionCollection();
            collection.enter(sId, true);
            HttpSessionModel model = collection.get(sId);
            if (model != null) {
                model.touch();
            }
        }
    }

    public void exitSession(String sId, boolean fNew) {
        if (sId != null) {
            HttpSessionModel model;
            HttpSessionCollection collection = this.getHttpSessionCollection();
            if (fNew && (model = collection.get(sId)) != null) {
                model.sessionReturned();
            }
            collection.exit(sId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAsyncOwnership(final String sId) {
        Task taskEnter;
        final HttpSessionCollection collection = this.getHttpSessionCollection();
        if (!collection.isExistent(sId)) {
            return;
        }
        final TaskDaemon daemon = this.ensureSessionWorkerDaemon();
        Task task = taskEnter = new Task(){
            private int m_cTries = 60;
            private boolean m_fDone;
            private boolean m_fsucceeded;

            @Override
            public synchronized void run() {
                if (collection.enter(sId, false) || !collection.isExistent(sId)) {
                    this.setDone(true);
                    this.setSucceeded(true);
                    this.notify();
                } else if (--this.m_cTries > 0) {
                    daemon.scheduleTask((Runnable)this, Base.getSafeTimeMillis() + 500L);
                } else {
                    this.setDone(true);
                    this.notify();
                    throw new RuntimeException("Unable to asynchronously obtain ownership for session ID " + sId + " after retrying for a minimum of 30 seconds.");
                }
            }

            @Override
            public void setDone(boolean fDone) {
                this.m_fDone = fDone;
            }

            @Override
            public boolean isDone() {
                return this.m_fDone;
            }

            @Override
            public boolean isSucceeded() {
                return this.m_fsucceeded;
            }

            @Override
            public void setSucceeded(boolean succeeded) {
                this.m_fsucceeded = succeeded;
            }

            public String toString() {
                return "Runnable Task: async enter for session ID=" + sId + ", remaining tries=" + this.m_cTries;
            }
        };
        synchronized (task) {
            daemon.executeTask((Runnable)taskEnter);
            try {
                while (!taskEnter.isDone()) {
                    Blocking.wait((Object)taskEnter);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException((Throwable)e);
            }
        }
        if (collection.isExistent(sId) && taskEnter.isSucceeded()) {
            long ldtExit = SessionHelper.getSafeTimeMillis() + (long)Math.max(10, Math.min(10000, this.m_configuration.getAsyncExitDelayMillis()));
            Runnable taskExit = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            collection.exit(sId, true);
                        }
                        catch (IllegalStateException e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block2;
                            LOGGER.log(Level.FINEST, "Concurrent exit of session: " + sId, e);
                        }
                    }
                }

                public String toString() {
                    return "Runnable Task: async exit for session ID=" + sId;
                }
            };
            daemon.scheduleTask(taskExit, ldtExit);
        }
    }

    public void shutdownHttpSessionCollection() {
        this.getHttpSessionCollection().shutdown();
    }

    public String toString() {
        return "SessionHelper\n" + SessionHelper.indentString((String)this.getDescription(), (String)"  ");
    }

    public NamedCache getConfigurationCache() {
        NamedCache map = this.m_cacheConfiguration;
        if (map == null) {
            map = this.ensureConfigurationCache();
        }
        return map;
    }

    protected synchronized NamedCache ensureConfigurationCache() {
        NamedCache map = this.m_cacheConfiguration;
        if (map == null) {
            String sCache = this.m_configuration.getManagementCacheName();
            this.m_cacheConfiguration = map = this.getCache(sCache);
        }
        return map;
    }

    protected void shutdownConfigurationCache() {
        NamedCache map = this.m_cacheConfiguration;
        if (map != null) {
            try {
                CacheFactory.releaseCache((NamedCache)map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Config=").append(SessionHelper.indentString((String)String.valueOf(this.getConfig()), (String)"  ", (boolean)false)).append("\nFactory=").append(SessionHelper.indentString((String)String.valueOf(this.getFactory()), (String)"  ", (boolean)false)).append("\nWrappedServletContext=").append(SessionHelper.indentString((String)String.valueOf(this.getWrappedServletContext()), (String)"  ", (boolean)false)).append("\nServletContext=").append(SessionHelper.indentString((String)String.valueOf(this.getServletContext()), (String)"  ", (boolean)false)).append("\nServletContextMajorVersion=").append(this.getServletContextMajorVersion()).append("\nServletContextMinorVersion=").append(this.getServletContextMinorVersion()).append("\nListeners=").append(SessionHelper.formatListeners(this.getListeners())).append("\nServletContextClustered=").append(this.isServletContextClustered()).append("\nServletContextAttributeCache").append(this.m_cacheContextAttributes == null ? "==null" : "!=null").append("\nServletConfig[]=[");
        Iterator iter = this.m_mapServletConfig.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']').append("\nHttpSessionContext=").append(this.m_ctxSessions).append("\nSessionContextEnabled=").append(this.isSessionContextEnabled()).append("\nHttpSessionCollection=").append(this.getHttpSessionCollection()).append("\nHttpSessionMap[]=[");
        iter = this.getHttpSessionMap().keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']').append("\nSessionIdCookieEnabled=").append(this.isSessionIdCookieEnabled()).append("\nSessionIdCookieName=").append(this.getSessionIdCookieName()).append("\nSessionIdEncodingEnabled=").append(this.isSessionIdEncodingEnabled()).append("\nSessionIdEncodingName=").append(this.getSessionIdEncodingName()).append("\nUseDefaultSessionIdDecoding=").append(this.isUseDefaultSessionIdDecoding()).append("\nUseDefaultSessionIdEncoding=").append(this.isUseDefaultSessionIdEncoding()).append("\nSessionReaperDaemon=").append(this.getSessionReaperDaemon()).append("\nDaemonPriority (initial)=").append(this.getDaemonPriority()).append("\nDaemonCycleMillis=").append(this.getDaemonCycleMillis()).append("\nDaemonCheckCollectionModulo=").append(this.getDaemonCheckCollectionModulo());
        return sb.toString();
    }

    public SessionHelperFactory getFactory() {
        return this.m_factory;
    }

    protected SessionReaperDaemon instantiateSessionReaperDaemon() {
        String sName = "SessionReaperDaemon[" + this.getApplicationName() + ", " + new Timestamp(SessionHelper.getSafeTimeMillis()) + "]";
        SessionReaperDaemon daemon = new SessionReaperDaemon(sName, this.getDaemonPriority());
        daemon.setThreadContextClassLoader(Thread.currentThread().getContextClassLoader());
        return daemon;
    }

    protected SessionReaperDaemon getSessionReaperDaemon() {
        return this.m_daemonReaper;
    }

    protected int getDaemonPriority() {
        return this.m_configuration.getReaperPriority();
    }

    protected long getDaemonCycleMillis() {
        int cSeconds = this.m_configuration.getReaperCycleSeconds();
        if (cSeconds < 15) {
            cSeconds = 15;
        } else if (cSeconds > 86400) {
            cSeconds = 86400;
        }
        return (long)cSeconds * 1000L;
    }

    protected int getDaemonCheckCollectionModulo() {
        return this.m_configuration.getReaperCheckCollectionModulo();
    }

    protected boolean isDaemonCheckCoordinated() {
        return this.m_configuration.isReaperCheckCoordinated();
    }

    protected boolean isDaemonAssumeLocality() {
        return this.m_configuration.isReaperAssumeLocality();
    }

    protected int getWorkManagerMinThreads() {
        return this.m_configuration.getDaemonMinThreads();
    }

    protected int getWorkManagerMaxThreads() {
        return this.m_configuration.getDaemonMaxThreads();
    }

    protected WorkManager getWorkManager() {
        return new WorkManagerImpl(this.m_configuration.getDaemonMinThreads(), this.m_configuration.getDaemonMaxThreads(), this.m_configuration.getDaemonQueueSize());
    }

    protected ReapTaskFactory getReapTaskFactory() {
        return this.m_reapTaskFactory;
    }

    public String getSessionReapingMechanism() {
        return this.m_configuration.getSessionReapingMechanism();
    }

    public void logWarningIfRemoteDeleteMechanismConfigured() {
        if (REMOTE_DELETE_REAPING_MECHANISM.equals(this.getSessionReapingMechanism()) && this.m_warnAboutSessionListenerInRemoteDelete) {
            LOGGER.warning("There are session listeners/session attribute listeners attached to the application but RemoteDelete is configured as session reaping mechanism. In RemoteDelete mechanism, session listeners will not be invoked during session invalidation.");
            this.m_warnAboutSessionListenerInRemoteDelete = false;
        }
    }

    protected void cleanUpSession(String sessionId) {
        this.killSession(sessionId);
    }

    protected void checkForDeadSessions() {
        HttpSessionCollection collection = this.getHttpSessionCollection();
        Map mapSessions = this.getHttpSessionMap();
        int cMaxTries = 5;
        for (int i = 0; i < cMaxTries; ++i) {
            try {
                Iterator iter = mapSessions.keySet().iterator();
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (collection.isExistent(id)) continue;
                    ((AbstractHttpSessionCollection)collection).deleteModelFromLocalCaches(id);
                    iter.remove();
                }
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
    }

    public void killSession(String sId) {
        HttpSessionCollection collection = this.getHttpSessionCollection();
        try {
            if (collection.isExistent(sId)) {
                collection.destroy(sId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdownSessionReaperDaemon() {
        SessionReaperDaemon daemon = this.getSessionReaperDaemon();
        if (daemon != null) {
            LOGGER.log(Level.INFO, "Waiting for Reaper Daemon to finish.");
            daemon.shutdown(10000L);
        }
    }

    protected TaskDaemon instantiateSessionWorkerDaemon() {
        String sName = "SessionWorkerDaemon[" + this.getWrappedServletContext().getServletContextName() + ", " + new Timestamp(SessionHelper.getSafeTimeMillis()) + "]";
        TaskDaemon daemon = new TaskDaemon(sName);
        daemon.setThreadContextClassLoader(Thread.currentThread().getContextClassLoader());
        return daemon;
    }

    protected TaskDaemon getSessionWorkerDaemon() {
        return this.m_daemonWorker;
    }

    protected void setSessionWorkerDaemon(TaskDaemon daemon) {
        this.m_daemonWorker = daemon;
    }

    public synchronized TaskDaemon ensureSessionWorkerDaemon() {
        TaskDaemon daemon = this.getSessionWorkerDaemon();
        if (daemon == null) {
            daemon = this.instantiateSessionWorkerDaemon();
            daemon.start();
            this.setSessionWorkerDaemon(daemon);
        } else {
            if (!daemon.isRunning()) {
                throw new IllegalStateException("SessionWorkerDaemon is not running");
            }
            if (daemon.isStopping()) {
                throw new IllegalStateException("SessionWorkerDaemon is stopping");
            }
        }
        return daemon;
    }

    public void shutdownSessionWorkerDaemon() {
        TaskDaemon daemon = this.getSessionWorkerDaemon();
        if (daemon != null) {
            daemon.stop(true);
        }
    }

    public static String formatListeners(Listeners listeners) {
        if (listeners == null) {
            return "null";
        }
        if (listeners.isEmpty()) {
            return CTX_INIT_SESSION_LOCKING_MODE_NONE;
        }
        StringBuilder sb = new StringBuilder();
        EventListener[] alistener = listeners.listeners();
        int c = alistener.length;
        for (int i = 0; i < c; ++i) {
            sb.append("\n  [").append(i).append("]=").append(SessionHelper.indentString((String)String.valueOf(alistener[i]), (String)"    ", (boolean)false));
        }
        return sb.toString();
    }

    public static String formatCacheName(NamedCache cache) {
        return cache == null ? "cache=null" : String.valueOf(cache.getCacheName());
    }

    public static String formatMapKeys(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return CTX_INIT_SESSION_LOCKING_MODE_NONE;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(SessionHelper.indentString((String)String.valueOf(iter.next()), (String)"  ", (boolean)false));
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static void logEventException(RuntimeException e, String sMethod, boolean fContinue) {
        if (!LOGGER.isLoggable(Level.SEVERE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("A runtime exception occurred while dispatching the ").append(sMethod).append(" event notification:\n").append(SessionHelper.getStackTrace((Throwable)e));
        if (fContinue) {
            sb.append("\n(The exception has been logged; execution will continue.)");
        } else {
            sb.append("\n(The exception has been logged but will be propagated.)");
        }
        LOGGER.log(Level.SEVERE, sb.toString());
    }

    public static void setIsReaperThread(boolean isReaperThread) {
        s_tloReaperFlag.set(isReaperThread);
    }

    public static void unsetIsReaperThread() {
        s_tloReaperFlag.remove();
    }

    public static boolean isReaperThread() {
        return s_tloReaperFlag.get();
    }

    public static boolean isSyntheticSessionRemoveRequired() {
        return SessionHelper.isReaperThread();
    }

    static {
        s_tloReaperFlag = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    static interface ReapTaskFactory {
        public Runnable createTask(Iterator<String> var1, int var2);
    }

    protected static interface Task
    extends Runnable {
        public void setDone(boolean var1);

        public boolean isDone();

        public void setSucceeded(boolean var1);

        public boolean isSucceeded();
    }

    public class SessionReaperDaemon
    extends TaskDaemon
    implements SessionReaperStatistics {
        private int m_cReaps;
        private long m_cReapedSessions;
        private long m_cTotalReapedSessions;
        private long m_dtLastReap;
        private long m_dtNextReap;
        private int m_cWindowReapedSessions;
        private int m_cReapCycleWindow;
        private long m_cLastReapCycleTime;
        private int m_dtTotalReapDuration;
        private long m_cMaxReapedSessions;
        private long m_dtMaxReapDuration;

        public SessionReaperDaemon(String sName, int nPriority) {
            super(sName, nPriority, false);
        }

        public synchronized void scheduleTask(Runnable task, long ldt) {
            if (!this.isStopping()) {
                super.scheduleTask(task, ldt);
            }
        }

        public void run() {
            long t;
            StartReapingTask task = this.instantiateStartReapingTask();
            this.m_dtNextReap = t = SessionReaperDaemon.getSafeTimeMillis() + SessionHelper.this.getDaemonCycleMillis();
            this.scheduleTask(task, t);
            super.run();
        }

        protected void onException(Throwable e, Runnable task) {
            boolean fLog = true;
            try {
                fLog = !this.isStopping() && SessionHelper.this.m_cacheConfiguration.getCacheService().isRunning();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fLog) {
                super.onException(e, task);
            }
        }

        public int getEstimatedReaperSessionCount() {
            int cReaps = this.m_cReapCycleWindow;
            int cEstimated = 0;
            if (cReaps > 0) {
                cEstimated = this.m_cWindowReapedSessions / cReaps;
            }
            return Math.max(cEstimated, 1000);
        }

        public void setEstimatedReaperSessionCount(int c) {
            int cReaps = this.m_cReapCycleWindow;
            int cTotal = this.m_cWindowReapedSessions;
            if (cReaps > 10) {
                cTotal -= cTotal / cReaps;
                --cReaps;
            }
            this.m_cReapCycleWindow = cReaps + 1;
            this.m_cWindowReapedSessions = cTotal + c;
        }

        public int getTotalReapCycles() {
            return this.m_cReaps;
        }

        public void incTotalReapCycles() {
            ++this.m_cReaps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isFullReapDue() {
            boolean fDue = false;
            NamedCache cache = SessionHelper.this.getConfigurationCache();
            if (cache.lock((Object)SessionHelper.CFG_KEY_REAPER)) {
                try {
                    long ldtNow = SessionReaperDaemon.getSafeTimeMillis();
                    Object o = cache.get((Object)SessionHelper.CFG_KEY_REAPER);
                    if (o == null) {
                        fDue = true;
                    } else {
                        Timestamp tsPrev = null;
                        if (o instanceof Timestamp) {
                            tsPrev = (Timestamp)o;
                        } else {
                            try {
                                tsPrev = Timestamp.valueOf(o.toString());
                            }
                            catch (Exception e) {
                                fDue = true;
                            }
                        }
                        long ldtPrev = tsPrev == null ? 0L : tsPrev.getTime();
                        long ldtDue = ldtPrev + SessionHelper.this.getDaemonCycleMillis();
                        if (ldtNow > ldtDue) {
                            fDue = true;
                        }
                    }
                    if (fDue) {
                        cache.put((Object)SessionHelper.CFG_KEY_REAPER, (Object)new Timestamp(ldtNow));
                    }
                }
                finally {
                    cache.unlock((Object)SessionHelper.CFG_KEY_REAPER);
                }
            }
            return fDue;
        }

        @Override
        public long getLastReapDuration() {
            return this.m_cLastReapCycleTime;
        }

        @Override
        public void setLastReapDuration(long time) {
            this.m_cLastReapCycleTime = time;
            this.m_dtTotalReapDuration = (int)((long)this.m_dtTotalReapDuration + time);
            if (time > this.m_dtMaxReapDuration) {
                this.m_dtMaxReapDuration = time;
            }
        }

        @Override
        public long getReapedSessions() {
            return this.m_cReapedSessions;
        }

        @Override
        public void setReapedSessions(long l) {
            this.m_cReapedSessions = l;
            this.m_cTotalReapedSessions += l;
            if (l > this.m_cMaxReapedSessions) {
                this.m_cMaxReapedSessions = l;
            }
        }

        @Override
        public long getTotalReapedSessions() {
            return this.m_cTotalReapedSessions;
        }

        @Override
        public long getLastReapTime() {
            return this.m_dtLastReap;
        }

        @Override
        public void setLastReapTime(long dt) {
            this.m_dtLastReap = dt;
        }

        @Override
        public long getNextReapTime() {
            return this.m_dtNextReap;
        }

        @Override
        public void setNextReapTime(long d) {
            this.m_dtNextReap = d;
        }

        @Override
        public long getAverageReapDuration() {
            return this.m_cReaps == 0 ? 0L : (long)(this.m_dtTotalReapDuration / this.m_cReaps);
        }

        @Override
        public long getAverageReapedSessions() {
            return this.m_cReaps == 0 ? 0L : this.m_cTotalReapedSessions / (long)this.m_cReaps;
        }

        @Override
        public long getMaxReapDuration() {
            return this.m_dtMaxReapDuration;
        }

        @Override
        public long getMaxReapedSessions() {
            return this.m_cMaxReapedSessions;
        }

        @Override
        public void resetStatistics() {
            this.m_cTotalReapedSessions = 0L;
            this.m_cReapedSessions = 0L;
            this.m_cLastReapCycleTime = 0L;
            this.m_dtMaxReapDuration = 0L;
            this.m_cMaxReapedSessions = 0L;
            this.m_cReaps = 0;
        }

        public StartReapingTask instantiateStartReapingTask() {
            return new StartReapingTask();
        }

        public class IncrementalReapTask
        extends com.tangosol.coherence.servlet.IncrementalReapTask {
            public IncrementalReapTask(Iterator<String> iterIds, int cEstimatedSessions) {
                this(this$1.SessionHelper.this, iterIds, cEstimatedSessions);
            }

            public IncrementalReapTask(SessionHelper sessionHelper, Iterator<String> iterIds, int cEstimatedSessions) {
                super(sessionHelper, SessionHelper.this.m_daemonReaper, iterIds, cEstimatedSessions);
            }
        }

        public class StartReapingTask
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SessionHelper helper = SessionHelper.this;
                SessionReaperDaemon daemon = SessionReaperDaemon.this;
                Runnable task = this;
                long ldtNow = Base.getSafeTimeMillis();
                long ldtNext = ldtNow + SessionHelper.this.getDaemonCycleMillis();
                try {
                    daemon.incTotalReapCycles();
                    helper.checkForDeadSessions();
                    if (!helper.isDaemonCheckCoordinated() || daemon.isFullReapDue()) {
                        boolean remoteReap;
                        int nModulo = SessionHelper.this.getDaemonCheckCollectionModulo();
                        boolean bl = remoteReap = nModulo > 0 && daemon.getTotalReapCycles() % nModulo == 0;
                        if (SessionHelper.REMOTE_DELETE_REAPING_MECHANISM.equals(SessionHelper.this.getSessionReapingMechanism())) {
                            Set<String> setDeletedIds = null;
                            setDeletedIds = remoteReap ? helper.getHttpSessionCollection().deleteExpiredSessions() : helper.getHttpSessionCollection().deleteExpiredLocalSessions();
                            SessionReaperDaemon.this.setReapedSessions(setDeletedIds == null ? 0L : (long)setDeletedIds.size());
                            SessionReaperDaemon.this.setLastReapDuration(Base.getSafeTimeMillis() - ldtNow);
                            SessionReaperDaemon.this.setLastReapTime(Base.getSafeTimeMillis());
                            ldtNext = Base.getSafeTimeMillis() + SessionHelper.this.getDaemonCycleMillis();
                        } else {
                            Iterator ids = remoteReap ? helper.getHttpSessionCollection().iteratePotentiallyExpiredIds() : helper.getHttpSessionCollection().iteratePotentiallyExpiredLocalIds();
                            task = SessionHelper.this.getReapTaskFactory().createTask(ids, daemon.getEstimatedReaperSessionCount());
                            ldtNext = Base.getSafeTimeMillis() + 1L;
                        }
                    }
                }
                finally {
                    daemon.scheduleTask(task, ldtNext);
                }
            }
        }
    }
}

