/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.CacheDelegator;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.RemoveEntryProcessor;
import com.tangosol.net.internal.SessionLocalHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.util.Iterator;
import java.util.Set;

public class SessionLocalBackingMapCacheDelegator
implements CacheDelegator {
    @Override
    public void deleteModel(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        collection.getClusterCache().remove((Object)model.getId());
    }

    @Override
    public boolean containsKey(String sId, AbstractHttpSessionCollection collection) {
        return collection.getClusterCache().containsKey((Object)sId);
    }

    @Override
    public void optimisticModelUpdate(AbstractHttpSessionModel model) {
        this.putModel(model);
    }

    @Override
    public Iterator getIteratorForPotentiallyExpiredIds(AbstractHttpSessionCollection collection) {
        return SessionLocalHelper.getLocalKeysIterator((NamedCache)collection.getClusterCache());
    }

    @Override
    public AbstractHttpSessionModel getModel(String sId, AbstractHttpSessionCollection collection) {
        try {
            return (AbstractHttpSessionModel)SessionLocalHelper.get((NamedCache)collection.getClusterCache(), (Object)sId);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    public void putModel(AbstractHttpSessionModel model) {
        SessionLocalHelper.put((NamedCache)model.getCollection().getClusterCache(), (Object)model.getId(), (Object)model);
    }

    @Override
    public void updateModelTimestamp(AbstractHttpSessionModel model) {
        this.putModel(model);
    }

    @Override
    public Iterator getIteratorForPotentiallyExpiredLocalIds(AbstractHttpSessionCollection collection) {
        return SessionLocalHelper.getLocalKeysIterator((NamedCache)collection.getClusterCache());
    }

    @Override
    public Set<String> deleteExpiredSessions(AbstractHttpSessionCollection collection) {
        NamedCache cacheCluster = collection.getClusterCache();
        Filter filter = collection.getSessionExpiryFilter();
        return cacheCluster.invokeAll(filter, (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired())).keySet();
    }

    @Override
    public Set<String> deleteExpiredLocalSessions(AbstractHttpSessionCollection collection) {
        NamedCache cacheCluster = collection.getClusterCache();
        Filter filter = collection.getSessionExpiryFilter();
        return cacheCluster.invokeAll(filter, (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired())).keySet();
    }

    @Override
    public void flush(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        String sId = model.getId();
        if (model.getReferenceCount() == 1) {
            if (model.getNewId() != null) {
                collection.remapSessionId(model);
            }
            model.flush();
        }
    }
}

