/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SplitHttpSessionModel;
import com.tangosol.coherence.servlet.SplitSessionCollectionConfiguration;
import com.tangosol.coherence.servlet.TraditionalHttpSessionCollection;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.RemoveEntryProcessor;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.InFilter;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SplitHttpSessionCollection
extends TraditionalHttpSessionCollection {
    public static final String CTX_INIT_CACHENAME_OVERFLOW = "coherence-session-overflow-cachename";
    public static final String CTX_INIT_ATTR_OVERFLOW_THRESHOLD = "coherence-attribute-overflow-threshold";
    public static final String CACHENAME_OVERFLOW = "session-overflow";
    public static final int CTX_INIT_ATTR_OVERFLOW_THRESHOLD_DEFAULT = 1024;
    private NamedCache m_cacheExternal;
    private int m_cbMinExternalSize = 1024;
    private int m_cExternalAttributeUpdates;
    private int m_cbExternalAttributeMaxSize;
    private long m_cbExternalAttributeTotalSize;

    @Override
    public void shutdown() {
        super.shutdown();
        this.releaseCache(this.getExternalAttributeCache());
    }

    @Override
    public void configure(XmlElement xml, SessionHelper sessionHelper) {
        super.configure(xml, sessionHelper);
        SplitSessionCollectionConfiguration m_configuration = (SplitSessionCollectionConfiguration)this.getHttpSessionCollectionConfiguration();
        this.m_cbMinExternalSize = m_configuration.getOverflowThreshold();
        NamedCache cache = this.m_cacheExternal = sessionHelper.getCache(m_configuration.getOverflowCacheName());
        cache.addIndex(SplitHttpSessionModel.SESSION_ID_EXTRACTOR, true, null);
    }

    public int getMinExternalAttributeSize() {
        return this.m_cbMinExternalSize;
    }

    public NamedCache getExternalAttributeCache() {
        return this.m_cacheExternal;
    }

    @Override
    public String toString() {
        return "SplitHttpSessionCollection\n" + SplitHttpSessionCollection.indentString((String)this.getDescription(), (String)"  ");
    }

    @Override
    protected AbstractHttpSessionModel instantiateModel(HttpSession session, String sId) {
        return new SplitHttpSessionModel(this, session, sId);
    }

    public int getAverageExternalAttributeSize() {
        int cUpdates = this.m_cExternalAttributeUpdates;
        return cUpdates == 0 ? 0 : (int)(this.m_cbExternalAttributeTotalSize / (long)cUpdates);
    }

    public int getMaxExternalAttributeSize() {
        int cUpdates = this.m_cExternalAttributeUpdates;
        return cUpdates == 0 ? 0 : this.m_cbExternalAttributeMaxSize;
    }

    public int getExternalAttributeUpdates() {
        return this.m_cExternalAttributeUpdates;
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.m_cExternalAttributeUpdates = 0;
        this.m_cbExternalAttributeMaxSize = 0;
        this.m_cbExternalAttributeTotalSize = 0L;
    }

    protected void onExternalAttributeUpdate(int cb) {
        if (cb > this.m_cbExternalAttributeMaxSize) {
            this.m_cbExternalAttributeMaxSize = cb;
        }
        this.m_cbExternalAttributeTotalSize += (long)cb;
        ++this.m_cExternalAttributeUpdates;
    }

    @Override
    public Set<String> deleteExpiredSessions() {
        Set<String> result = super.deleteExpiredSessions();
        if (result == null) {
            return null;
        }
        this.getExternalAttributeCache().invokeAll((Filter)new InFilter(SplitHttpSessionModel.SESSION_ID_EXTRACTOR, result), (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired()));
        return result;
    }

    @Override
    public Set<String> deleteExpiredLocalSessions() {
        Set<String> result = super.deleteExpiredLocalSessions();
        if (result == null) {
            return null;
        }
        this.getExternalAttributeCache().invokeAll((Filter)new InFilter(SplitHttpSessionModel.SESSION_ID_EXTRACTOR, result), (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired()));
        return result;
    }
}

