/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SplitHttpSessionCollection;
import com.tangosol.coherence.servlet.SplittableHolder;
import com.tangosol.coherence.servlet.TraditionalHttpSessionModel;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.RemoveEntryProcessor;
import com.tangosol.util.Binary;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import java.util.ConcurrentModificationException;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SplitHttpSessionModel
extends TraditionalHttpSessionModel {
    public static ValueExtractor SESSION_ID_EXTRACTOR = new KeyExtractor("getPrimaryKey");
    private transient int m_cbSplit;
    private transient Map m_ExternalBinaryAttributes = new LiteMap();

    public SplitHttpSessionModel() {
    }

    public SplitHttpSessionModel(SplitHttpSessionCollection collection, HttpSession session, String sId) {
        super(collection, session, sId);
    }

    @Override
    public String toString() {
        return "SplitHttpSessionModel\n" + SplitHttpSessionModel.indentString((String)this.getDescription(), (String)"  ");
    }

    @Override
    protected void unbind() {
        try {
            super.unbind();
        }
        finally {
            this.removeExternalAttributes();
        }
    }

    @Override
    protected void flush() {
        try {
            super.flush();
            this.flushExternalAttributes();
        }
        catch (ConcurrentModificationException e) {
            if (!this.getSplitHttpSessionCollection().getClusterCache().containsKey((Object)this.getId())) {
                this.removeExternalAttributes();
            }
            throw e;
        }
    }

    @Override
    protected void setCollection(AbstractHttpSessionCollection collection) {
        if (collection != null) {
            this.m_cbSplit = ((SplitHttpSessionCollection)collection).getMinExternalAttributeSize();
        }
        super.setCollection(collection);
    }

    protected SplitHttpSessionCollection getSplitHttpSessionCollection() {
        return (SplitHttpSessionCollection)this.getCollection();
    }

    protected void removeExternalAttributes() {
        this.m_ExternalBinaryAttributes.clear();
        String sId = this.getId();
        this.getSplitHttpSessionCollection().getExternalAttributeCache().invokeAll((Filter)new KeyAssociatedFilter((Filter)new EqualsFilter(SESSION_ID_EXTRACTOR, (Object)sId), (Object)sId), (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired()));
    }

    private void flushExternalAttributes() {
        if (!this.m_ExternalBinaryAttributes.isEmpty()) {
            try {
                this.getSplitHttpSessionCollection().getExternalAttributeCache().putAll(this.m_ExternalBinaryAttributes);
            }
            finally {
                this.m_ExternalBinaryAttributes.clear();
            }
        }
    }

    protected void setExternalBinary(Object oKey, Binary binValue) {
        this.m_ExternalBinaryAttributes.put(oKey, binValue);
    }

    protected void removeExternalAttribute(Object oKey) {
        this.m_ExternalBinaryAttributes.remove(oKey);
        AbstractHttpSessionCollection.removeBlind((Map)this.getExternalCache(), oKey);
    }

    public int getMinExternalAttributeSize() {
        return this.m_cbSplit;
    }

    protected NamedCache getExternalCache() {
        return this.getSplitHttpSessionCollection().getExternalAttributeCache();
    }

    protected void remapExternalAttributes(String sIdNew) {
        NamedCache cacheExternal = this.getSplitHttpSessionCollection().getExternalAttributeCache();
        for (SplittableHolder holder : this.getAttributeMap().values()) {
            if (!holder.isExternal()) continue;
            Object oKey = holder.getExternalKey();
            Binary binValue = holder.getExternalBinary();
            cacheExternal.remove(oKey);
            Object oKeyNew = holder.assignExternalKey(sIdNew);
            cacheExternal.put(oKeyNew, (Object)binValue);
        }
    }

    @Override
    protected AttributeHolder instantiateAttributeHolder() {
        return new SplittableHolder(this);
    }

    @Override
    protected AttributeHolder instantiateAttributeHolder(String sName, Object oValue) {
        return new SplittableHolder(sName, oValue, this);
    }
}

