/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.OptimizedHolder;
import com.tangosol.coherence.servlet.SplitHttpSessionCollection;
import com.tangosol.coherence.servlet.SplitHttpSessionModel;
import com.tangosol.util.Binary;
import com.tangosol.util.CompositeKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SplittableHolder
extends OptimizedHolder {
    private transient boolean m_fExternal;
    private transient Object m_oKey;

    public SplittableHolder() {
    }

    public SplittableHolder(SplitHttpSessionModel model) {
        super(model);
    }

    public SplittableHolder(String sName, Object oValue, SplitHttpSessionModel model) {
        super(sName, oValue, model);
    }

    @Override
    public Object getValue() {
        Object oValue = super.getValue();
        this.maybeSaveSpace();
        return oValue;
    }

    @Override
    public void onBound(AttributeHolder holderOrig) {
        super.onBound(holderOrig);
        if (holderOrig instanceof SplittableHolder) {
            this.setExternal(((SplittableHolder)holderOrig).isExternal());
        }
    }

    @Override
    public void onUnbound(boolean fReplaced, boolean fAll) {
        super.onUnbound(fReplaced, fAll);
        if (!fReplaced && this.isExternal()) {
            if (fAll) {
                this.setExternal(false);
            } else {
                this.removeExternalBinary();
            }
        }
    }

    @Override
    protected void flush() throws IOException {
        boolean fExternalOld = this.isExternal();
        Binary binValueOld = this.getInternalBinary();
        super.flush();
        boolean fExternalNew = this.isExternal();
        Binary binValueNew = this.getInternalBinary();
        if (fExternalNew) {
            if (!fExternalOld || !SplittableHolder.equals((Object)binValueOld, (Object)binValueNew)) {
                this.setExternalBinary(binValueNew);
            }
        } else if (fExternalOld) {
            this.removeExternalBinary();
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        this.maybeSaveSpace();
    }

    @Override
    protected Binary ensureInternalBinary() {
        Binary binValue = this.getInternalBinary();
        if (binValue == null) {
            if (!this.isExternal()) {
                String sName = this.getModel().extractAttributeName(this.getName());
                throw new IllegalStateException("missing binary value for attribute \"" + sName + "\" of session id \"" + this.getModel().getId() + "\"");
            }
            binValue = this.getExternalBinary();
            if (binValue == null) {
                String sName = this.getModel().extractAttributeName(this.getName());
                throw new IllegalStateException("missing external value for attribute \"" + sName + "\" of session id \"" + this.getModel().getId() + "\"");
            }
            this.setInternalBinary(binValue);
        }
        return binValue;
    }

    protected boolean isExternal() {
        return this.m_fExternal;
    }

    protected void setExternal(boolean fExternal) {
        this.m_fExternal = fExternal;
    }

    protected boolean isExternalDesirable(Binary binValue) {
        if (this.isActivationListener()) {
            return false;
        }
        return binValue.length() > ((SplitHttpSessionModel)this.getModel()).getMinExternalAttributeSize();
    }

    protected Object getExternalKey() {
        Object oKey = this.m_oKey;
        if (oKey == null) {
            oKey = this.assignExternalKey(this.getModel().getId());
        }
        return oKey;
    }

    protected Object assignExternalKey(String sId) {
        this.m_oKey = new CompositeKey((Object)sId, (Object)this.getName());
        return this.m_oKey;
    }

    protected Binary getExternalBinary() {
        Binary binValue = null;
        if (this.isExternal()) {
            binValue = (Binary)((SplitHttpSessionModel)this.getModel()).getExternalCache().get(this.getExternalKey());
        }
        return binValue;
    }

    protected void setExternalBinary(Binary binValue) {
        ((SplitHttpSessionModel)this.getModel()).setExternalBinary(this.getExternalKey(), binValue);
        this.setExternal(true);
        ((SplitHttpSessionCollection)this.getModel().getCollection()).onExternalAttributeUpdate(binValue.length());
    }

    protected void removeExternalBinary() {
        ((SplitHttpSessionModel)this.getModel()).removeExternalAttribute(this.getExternalKey());
        this.setExternal(false);
    }

    private void maybeSaveSpace() {
        if (!this.isEnableSuspectAttributes() && this.isExternal()) {
            this.setInternalBinary(null);
        }
    }

    @Override
    protected void prepareWrite() throws IOException {
        if (this.getInternalValue() != null && (this.getInternalBinary() == null || this.isSuspect())) {
            try {
                super.prepareWrite();
            }
            catch (Exception e) {
                this.setExternal(false);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw SplittableHolder.ensureRuntimeException((Throwable)e);
            }
            this.setExternal(this.isExternalDesirable(this.getInternalBinary()));
        }
    }

    @Override
    protected Binary readBinary(DataInput in) throws IOException {
        Binary binValue = null;
        boolean fInternal = in.readBoolean();
        this.setExternal(!fInternal);
        if (fInternal) {
            binValue = super.readBinary(in);
        }
        return binValue;
    }

    @Override
    protected void writeBinary(DataOutput out) throws IOException {
        boolean fInternal = !this.isExternal();
        out.writeBoolean(fInternal);
        if (fInternal) {
            super.writeBinary(out);
        }
    }
}

