/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Areturn;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.Dreturn;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.Freturn;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Getfield;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.Invokespecial;
import com.tangosol.dev.assembler.Invokevirtual;
import com.tangosol.dev.assembler.Ireturn;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.Lreturn;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Putfield;
import com.tangosol.dev.assembler.Return;
import com.tangosol.engarde.ApplicationEntry;
import com.tangosol.engarde.ApplicationReader;
import com.tangosol.engarde.ApplicationWriter;
import com.tangosol.engarde.JarStorage;
import com.tangosol.run.xml.SimpleDocument;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class WebPluginInstaller
extends Base {
    public static final String OPT_INSTALL = "-install";
    public static final String OPT_UNINSTALL = "-uninstall";
    protected static final String[] EXT_CLASS_NAMES = new String[]{"com.tangosol.coherence.servlet.oracle1012.ApplyPatch", "com.tangosol.coherence.servlet.resin30.ApplyPatch", "com.tangosol.coherence.servlet.resin31.ApplyPatch", "com.tangosol.coherence.servlet.weblogic103.ApplyPatch"};

    public static void main(String[] asArgs) {
        if (asArgs.length != 2) {
            WebPluginInstaller.showInstructions();
            return;
        }
        String sPath = asArgs[0];
        if (sPath == null || sPath.length() == 0) {
            WebPluginInstaller.showInstructions();
            return;
        }
        String sOpt = asArgs[1];
        if (!sOpt.equals(OPT_INSTALL) && !sOpt.equals(OPT_UNINSTALL)) {
            WebPluginInstaller.showInstructions();
            return;
        }
        File fileDir = new File(sPath);
        if (!fileDir.isDirectory()) {
            WebPluginInstaller.out((String)("The specified path (\"" + sPath + "\") is not a directory."));
            return;
        }
        String[] asClz = EXT_CLASS_NAMES;
        ApplyPatch patch = null;
        for (String sClz : asClz) {
            try {
                patch = (ApplyPatch)((Object)Class.forName(sClz).newInstance());
            }
            catch (Exception e) {
                WebPluginInstaller.err((String)("Unable to instantiate class \"" + sClz + "\":"));
                WebPluginInstaller.err((Throwable)e);
                continue;
            }
            try {
                patch.init(fileDir);
                break;
            }
            catch (Exception e) {
                patch = null;
            }
        }
        if (patch == null) {
            WebPluginInstaller.err((String)("Unable to find a supported web container installation under \"" + fileDir.getAbsolutePath() + "\""));
            return;
        }
        WebPluginInstaller.out((String)("Detected an installation of " + patch.getContainerName() + " under \"" + fileDir.getAbsolutePath() + "\""));
        if (sOpt.equals(OPT_INSTALL)) {
            patch.install();
        } else {
            patch.uninstall();
        }
    }

    public static void showInstructions() {
        WebPluginInstaller.out();
        WebPluginInstaller.out((String)"Usage instructions:");
        WebPluginInstaller.out();
        WebPluginInstaller.out((String)("    java " + WebPluginInstaller.class.getName() + " <install dir> -operation"));
        WebPluginInstaller.out();
        WebPluginInstaller.out((String)"where operations include:");
        WebPluginInstaller.out((String)"    -install      install Coherence*Web classes into the web container");
        WebPluginInstaller.out((String)"    -uninstall    restore the web container installation to its original state");
    }

    public static abstract class ApplyPatch
    extends Base
    implements Constants {
        public static final String INSTALL_DESCRIPTOR = "coherence-web-plugin.xml";
        public static final int BLOCK_SIZE = 4096;
        public static final byte[] BLOCK_BUF = new byte[4096];
        public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
        protected File m_fileLib;

        public abstract void init(File var1);

        public abstract String getContainerName();

        public abstract String getLibraryName();

        protected abstract void processEntry(ApplicationEntry var1, ApplicationReader var2, ApplicationWriter var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void install() {
            String sFile = this.getLibraryName();
            File fileLib = this.getLibrary();
            ApplyPatch.azzert((sFile != null && sFile.length() > 0 ? 1 : 0) != 0);
            ApplyPatch.azzert((fileLib != null && fileLib.exists() && fileLib.isFile() ? 1 : 0) != 0);
            ApplyPatch.out((String)("Processing \"" + fileLib.getAbsolutePath() + "\""));
            File fileDir = fileLib.getParentFile();
            File fileDescr = new File(fileDir, INSTALL_DESCRIPTOR);
            if (fileDescr.exists()) {
                ApplyPatch.out((String)"It appears that the library has already been processed.");
                ApplyPatch.out((String)"Terminating (without making any changes)");
                return;
            }
            if (!fileLib.canRead() || !fileLib.canWrite()) {
                ApplyPatch.out((String)("The \"" + sFile + "\" file cannot be read from/written to."));
                return;
            }
            File fileOrig = null;
            for (int c = 1; c <= 999 && (fileOrig = new File(fileDir, sFile + '.' + ApplyPatch.toDecString((int)c, (int)3))).exists(); ++c) {
            }
            if (!fileLib.renameTo(fileOrig)) {
                ApplyPatch.out((String)("Failed to back up \"" + sFile + "\" to \"" + fileOrig.getName() + "\""));
                ApplyPatch.out((String)("(Make sure that \"" + fileLib + "\" is not in use or in the current CLASSPATH)"));
                ApplyPatch.out((String)"Terminating (without making any changes)");
                return;
            }
            ApplyPatch.out((String)("Backed up \"" + sFile + "\" to \"" + fileOrig.getName() + "\""));
            JarStorage reader = null;
            JarStorage writer = null;
            try {
                JarFile jfOrig = new JarFile(fileOrig);
                reader = new JarStorage(jfOrig);
                writer = new JarStorage(fileLib, jfOrig.getManifest());
                boolean fCheckMf = true;
                Enumeration entries = reader.entries();
                while (entries.hasMoreElements()) {
                    ApplicationEntry entry = (ApplicationEntry)entries.nextElement();
                    if (fCheckMf && entry.getName().equalsIgnoreCase(MANIFEST_NAME)) {
                        fCheckMf = false;
                        continue;
                    }
                    this.processEntry(entry, (ApplicationReader)reader, (ApplicationWriter)writer);
                }
                SimpleDocument xmlDescr = new SimpleDocument("coherence-web-plugin");
                XmlValue attrNS = xmlDescr.addAttribute("xmlns");
                attrNS.setString("urn:tangosol:coherence:web:plugin");
                XmlElement xmlServer = xmlDescr.addElement("server");
                xmlServer.setString(this.getContainerName());
                XmlElement xmlBackup = xmlDescr.addElement("backup-name");
                xmlBackup.setString(fileOrig.getName());
                try (PrintWriter writerXml = new PrintWriter(new FileWriter(fileDescr));){
                    xmlDescr.writeXml(writerXml, true);
                }
                ApplyPatch.out((String)("Finished processing \"" + sFile + "\""));
            }
            catch (Exception e) {
                ApplyPatch.err((String)"An unexpected exception occurred during processing:");
                ApplyPatch.err((Throwable)e);
                ApplyPatch.err((String)"(Terminating)");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void uninstall() {
            String sFile = this.getLibraryName();
            File fileLib = this.getLibrary();
            ApplyPatch.azzert((sFile != null && sFile.length() > 0 ? 1 : 0) != 0);
            ApplyPatch.azzert((fileLib != null && fileLib.exists() && fileLib.isFile() ? 1 : 0) != 0);
            ApplyPatch.out((String)("Restoring \"" + fileLib.getAbsolutePath() + "\""));
            File fileDir = fileLib.getParentFile();
            File fileDescr = new File(fileDir, INSTALL_DESCRIPTOR);
            if (!fileDescr.exists()) {
                ApplyPatch.out((String)"It appears that the library has not been processed.");
                ApplyPatch.out((String)"Terminating (without making any changes)");
                return;
            }
            FileInputStream streamXml = null;
            try {
                streamXml = new FileInputStream(fileDescr);
                XmlDocument xmlDescr = XmlHelper.loadXml((InputStream)streamXml);
                String sBackup = xmlDescr.getSafeElement("backup-name").getString();
                if (sBackup.length() == 0) {
                    ApplyPatch.out((String)"The XML descriptor is corrupted.");
                    return;
                }
                File fileBackup = new File(fileDir, sBackup);
                if (!fileBackup.exists() || !fileBackup.isFile()) {
                    ApplyPatch.out((String)("Cannot restore backup file \"" + fileBackup + "\""));
                    return;
                }
                if (!fileLib.delete()) {
                    ApplyPatch.out((String)("Failed to delete \"" + sFile + "\""));
                    ApplyPatch.out((String)("(Make sure that \"" + fileLib + "\" is not in use or in the current CLASSPATH)"));
                    ApplyPatch.out((String)"Terminating (without making any changes)");
                    return;
                }
                if (!fileBackup.renameTo(fileLib)) {
                    ApplyPatch.out((String)("Failed to rename \"" + fileBackup + "\" to \"" + fileLib + "\""));
                    return;
                }
                fileDescr.deleteOnExit();
                return;
            }
            catch (IOException e) {
                ApplyPatch.err((String)"An unexpected exception occurred:");
                ApplyPatch.err((Throwable)e);
                ApplyPatch.err((String)"(Terminating)");
                return;
            }
            finally {
                try {
                    ((InputStream)streamXml).close();
                }
                catch (Exception exception) {}
            }
        }

        protected String convertClassToEntry(String sClass) {
            return sClass.replace('.', '/') + ".class";
        }

        protected String convertEntryToClass(String sEntry) {
            return sEntry.substring(0, sEntry.length() - 6).replace('/', '.');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String readManifestAttribute(File fileJar, String sName) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(fileJar);
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String string = attributes.getValue(sName);
                return string;
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] readEntry(ApplicationEntry entry, ApplicationReader reader) throws IOException {
            try (InputStream streamIn = reader.getInputStream(entry);){
                byte[] byArray = ApplyPatch.read((InputStream)streamIn);
                return byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeEntry(ApplicationEntry entry, ApplicationWriter writer, byte[] ab) throws IOException {
            writer.createEntry(entry).setSize((long)ab.length);
            try {
                writer.writeEntryData(ab, 0, ab.length);
            }
            finally {
                writer.closeEntry();
            }
        }

        protected void copyEntry(ApplicationEntry entry, ApplicationReader reader, ApplicationWriter writer) throws IOException {
            this.copyEntry(entry, reader.getInputStream(entry), writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void copyEntry(ApplicationEntry entry, InputStream in, ApplicationWriter writer) throws IOException {
            try {
                writer.createEntry(entry);
            }
            catch (IOException e) {
                in.close();
                throw e;
            }
            try {
                long cbSize = 0L;
                try {
                    int cb;
                    while ((cb = in.read(BLOCK_BUF, 0, 4096)) >= 0) {
                        writer.writeEntryData(BLOCK_BUF, 0, cb);
                        cbSize += (long)cb;
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
                if (cbSize == 0L) {
                    writer.writeEntryData(BLOCK_BUF, 0, 0);
                }
            }
            finally {
                in.close();
                writer.closeEntry();
            }
        }

        protected void extendEntry(ApplicationEntry entry, ApplicationReader reader, ApplicationWriter writer) throws IOException {
            Method method;
            byte[] ab = this.readEntry(entry, reader);
            ClassFile classfile = new ClassFile(ab);
            ApplyPatch.out((String)("Processing " + entry.getName()));
            if (classfile.isFinal()) {
                classfile.setFinal(false);
            }
            if ((method = classfile.getMethod("<init>", "()V")) == null) {
                method = classfile.addMethod("<init>", "()V");
                method.setPublic();
                CodeAttribute code = method.getCode();
                code.add((Op)new Begin());
                Avar avarThis = new Avar("this");
                code.add((Op)avarThis);
                code.add((Op)new Aload(avarThis));
                MethodConstant methconst = new MethodConstant(classfile.getSuper(), "<init>", "()V");
                code.add((Op)new Invokespecial(methconst));
                code.add((Op)new Return());
                code.add((Op)new End());
            } else if (method.isPrivate()) {
                method.setProtected();
            }
            Enumeration enmrMeth = classfile.getMethods();
            while (enmrMeth.hasMoreElements()) {
                Method meth = (Method)enmrMeth.nextElement();
                if (meth.isPrivate() || meth.isStatic() || !meth.isFinal()) continue;
                meth.setFinal(false);
                if (!meth.isPackage()) continue;
                meth.setProtected();
            }
            this.writeEntry(entry, writer, classfile.getBytes());
        }

        protected void createDelegateEntry(ApplicationEntry entry, ApplicationReader reader, ApplicationWriter writer) throws IOException {
            String sEntry = entry.getName();
            String sClass = this.convertEntryToClass(sEntry);
            String sClassSimple = ClassHelper.getSimpleName((String)sClass);
            String sClassSig = 'L' + sClass.replace('.', '/') + ';';
            String sClassD = ClassHelper.getPackageName((String)sClass) + "Coherence" + sClassSimple + "Delegate";
            String sEntryD = this.convertClassToEntry(sClassD);
            ApplicationEntry entryD = writer.createEntry(sEntryD);
            ApplyPatch.out((String)("Generating " + entryD.getName()));
            ClassFile classfileD = new ClassFile(sClassD, sClass, false);
            classfileD.setPublic();
            Field field = classfileD.addField("m_delegate", sClassSig);
            field.setProtected();
            FieldConstant fieldconstD = classfileD.getFieldConstant("m_delegate");
            Method methodInit = classfileD.addMethod("<init>", '(' + sClassSig + ")V");
            methodInit.setPublic();
            CodeAttribute code = methodInit.getCode();
            code.add((Op)new Begin());
            Avar avarThis = new Avar("this");
            Avar avarD = new Avar("delegate");
            code.add((Op)avarThis);
            code.add((Op)avarD);
            code.add((Op)new Aload(avarThis));
            MethodConstant methconst = new MethodConstant(classfileD.getSuper(), "<init>", "()V");
            code.add((Op)new Invokespecial(methconst));
            code.add((Op)new Aload(avarThis));
            code.add((Op)new Aload(avarD));
            code.add((Op)new Putfield(fieldconstD));
            code.add((Op)new Return());
            code.add((Op)new End());
            Method methodGet = classfileD.addMethod("get" + sClassSimple, "()" + sClassSig);
            methodGet.setProtected();
            CodeAttribute code2 = methodGet.getCode();
            code2.add((Op)new Begin());
            Avar avarThis2 = new Avar("this");
            code2.add((Op)avarThis2);
            code2.add((Op)new Aload(avarThis2));
            code2.add((Op)new Getfield(fieldconstD));
            code2.add((Op)new Areturn());
            code2.add((Op)new End());
            HashMap<String, Object[]> mapMethods = new HashMap<String, Object[]>();
            byte[] ab = this.readEntry(entry, reader);
            ClassFile classfile = new ClassFile(ab);
            String sClassSup = classfile.getSuper().replace('/', '.');
            if (sClassSup != null && !sClassSup.equals(Object.class.getName())) {
                String sEntrySup = this.convertClassToEntry(sClassSup);
                ApplicationEntry entrySup = reader.getEntry(sEntrySup);
                byte[] abSup = this.readEntry(entrySup, reader);
                ClassFile classfileSup = new ClassFile(abSup);
                Enumeration enmrMeth = classfileSup.getMethods();
                while (enmrMeth.hasMoreElements()) {
                    Method method = (Method)enmrMeth.nextElement();
                    mapMethods.put(method.getName() + method.getType(), new Object[]{method, sClassSup});
                }
            }
            Enumeration enmrMeth = classfile.getMethods();
            while (enmrMeth.hasMoreElements()) {
                Method method = (Method)enmrMeth.nextElement();
                mapMethods.put(method.getName() + method.getType(), new Object[]{method, sClass});
            }
            for (Map.Entry mapEntry : mapMethods.entrySet()) {
                Object[] ao = (Object[])mapEntry.getValue();
                Method method = (Method)ao[0];
                if (method.getName().equals("<init>") || method.isPrivate() || method.isStatic()) continue;
                this.createDelegateMethod(classfileD, method, (String)ao[1], methodGet);
            }
            this.writeEntry(entryD, writer, classfileD.getBytes());
        }

        protected void createDelegateMethod(ClassFile classfile, Method method, String sClass, Method methodGet) {
            Ireturn opReturn;
            Method delegate = classfile.addMethod(method.getName(), method.getType());
            int nAccess = method.getAccess();
            if (nAccess == 0) {
                nAccess = 4;
            } else {
                ApplyPatch.azzert((nAccess != 2 ? 1 : 0) != 0);
            }
            delegate.setAccess(nAccess);
            CodeAttribute code = delegate.getCode();
            code.add((Op)new Begin());
            String[] asTypes = method.getTypes();
            int cTypes = asTypes.length;
            LinkedList<Iload> listLoad = new LinkedList<Iload>();
            Avar avarThis = new Avar("this");
            code.add((Op)avarThis);
            for (int i = 1; i < cTypes; ++i) {
                Iload opLoad;
                Ivar opDecl;
                String sName = String.valueOf((char)(97 + i));
                switch (asTypes[i].charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        opDecl = new Ivar(sName);
                        opLoad = new Iload(opDecl);
                        break;
                    }
                    case 'J': {
                        opDecl = new Lvar(sName);
                        opLoad = new Lload((Lvar)opDecl);
                        break;
                    }
                    case 'F': {
                        opDecl = new Fvar(sName);
                        opLoad = new Fload((Fvar)opDecl);
                        break;
                    }
                    case 'D': {
                        opDecl = new Dvar(sName);
                        opLoad = new Dload((Dvar)opDecl);
                        break;
                    }
                    default: {
                        opDecl = new Avar(sName);
                        opLoad = new Aload((Avar)opDecl);
                    }
                }
                code.add((Op)opDecl);
                listLoad.add(opLoad);
            }
            MethodConstant methconst = classfile.getMethodConstant(methodGet.getName() + methodGet.getType());
            code.add((Op)new Aload(avarThis));
            code.add((Op)new Invokevirtual(methconst));
            Iterator iterLoad = listLoad.iterator();
            while (iterLoad.hasNext()) {
                code.add((Op)iterLoad.next());
            }
            methconst = new MethodConstant(sClass, method.getName(), method.getType());
            code.add((Op)new Invokevirtual(methconst));
            switch (asTypes[0].charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opReturn = new Ireturn();
                    break;
                }
                case 'J': {
                    opReturn = new Lreturn();
                    break;
                }
                case 'F': {
                    opReturn = new Freturn();
                    break;
                }
                case 'D': {
                    opReturn = new Dreturn();
                    break;
                }
                case 'V': {
                    opReturn = new Return();
                    break;
                }
                default: {
                    opReturn = new Areturn();
                }
            }
            code.add((Op)opReturn);
            code.add((Op)new End());
        }

        public File getLibrary() {
            return this.m_fileLib;
        }

        protected void setLibrary(File fileLib) {
            this.m_fileLib = fileLib;
        }
    }
}

