/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.util.Base;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterWrapper
extends Base
implements Filter {
    private SessionHelper m_helper;
    private FilterConfig m_cfg;
    private Filter m_filter;

    public void init(FilterConfig cfg) throws ServletException {
        Filter filter;
        FilterWrapper.azzert((cfg != null ? 1 : 0) != 0);
        String sClass = cfg.getInitParameter("coherence-filter-class");
        if (sClass == null || (sClass = sClass.trim()).length() == 0) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Filter initialization could not proceed because the wrapped filter class name was not available");
        }
        SessionHelper helper = SessionHelperManager.ensureSessionHelper(cfg.getServletContext());
        cfg = helper.wrapFilterConfig(cfg);
        try {
            filter = (Filter)Class.forName(sClass).newInstance();
        }
        catch (Exception e) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Filter initialization encountered an exception while initializing the wrapped filter class: " + sClass, (Throwable)e);
        }
        filter.init(cfg);
        this.m_helper = helper;
        this.m_cfg = cfg;
        this.m_filter = filter;
        helper.filterInitialized();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        this.getSessionHelper().filter(this.getFilter(), req, res, chain);
    }

    public void destroy() {
        SessionHelper helper;
        Filter filter = this.getFilter();
        if (filter != null) {
            filter.destroy();
        }
        if ((helper = this.getSessionHelper()) != null) {
            helper.filterDestroyed();
        }
    }

    public String toString() {
        return "FilterWrapper (2.3)\n" + FilterWrapper.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nFilter=").append(FilterWrapper.indentString((String)String.valueOf(this.getFilter()), (String)"  ", (boolean)false)).append("\nFilterConfig=").append(FilterWrapper.indentString((String)String.valueOf(this.getFilterConfig()), (String)"  ", (boolean)false));
        return sb.toString();
    }

    protected FilterConfig getFilterConfig() {
        return this.m_cfg;
    }

    protected Filter getFilter() {
        return this.m_filter;
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }
}

