/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.Base;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.NullImplementation;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionContextImpl
extends Base
implements HttpSessionContext {
    private SessionHelper m_helper;
    private boolean m_fStrict = true;

    public HttpSessionContextImpl(SessionHelper helper, boolean fStrict) {
        this.m_helper = helper;
        this.m_fStrict = fStrict;
    }

    public Enumeration getIds() {
        Enumeration enmr = this.isStrict() ? NullImplementation.getEnumeration() : new IteratorEnumerator(this.getSessionHelper().getHttpSessionCollection().iterateIds());
        return enmr;
    }

    public HttpSession getSession(String sId) {
        HttpSession session = this.isStrict() ? null : this.getSessionHelper().ensureHttpSession(sId);
        return session;
    }

    public String toString() {
        return "HttpSessionContextImpl (2.3)\n" + HttpSessionContextImpl.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nStrict (disallows session enumeration)=").append(this.isStrict());
        return sb.toString();
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected boolean isStrict() {
        return this.m_fStrict;
    }
}

