/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.Base;
import com.tangosol.util.SimpleEnumerator;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
extends Base
implements HttpSession {
    private SessionHelper m_helper;
    private HttpSessionCollection m_collection;
    private String m_sId;
    private static final Logger LOGGER = Logger.getLogger(HttpSessionImpl.class.getName());

    public HttpSessionImpl(SessionHelper helper, HttpSessionCollection collection) {
        this.m_helper = helper;
        this.m_collection = collection;
        this.m_sId = collection.create(this).getId();
    }

    public HttpSessionImpl(SessionHelper helper, HttpSessionCollection collection, String sId) {
        this.m_helper = helper;
        this.m_collection = collection;
        this.m_sId = sId;
    }

    public Object getAttribute(String sName) {
        this.enter();
        try {
            Object object = this.ensureActiveModel().getAttribute(sName);
            return object;
        }
        finally {
            this.exit();
        }
    }

    public Enumeration getAttributeNames() {
        this.enter();
        try {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator((Object[])this.ensureActiveModel().getAttributeNameArray());
            return simpleEnumerator;
        }
        finally {
            this.exit();
        }
    }

    public long getCreationTime() {
        this.enter();
        try {
            long l = this.ensureActiveModel().getCreationTime();
            return l;
        }
        finally {
            this.exit();
        }
    }

    public String getId() {
        return this.m_sId;
    }

    public long getLastAccessedTime() {
        this.enter();
        try {
            long l = this.ensureUsableModel().getLastAccessedTime();
            return l;
        }
        finally {
            this.exit();
        }
    }

    public int getMaxInactiveInterval() {
        this.enter();
        try {
            int n = this.ensureUsableModel().getMaxInactiveInterval();
            return n;
        }
        finally {
            this.exit();
        }
    }

    public ServletContext getServletContext() {
        this.enter();
        try {
            ServletContext servletContext = this.getSessionHelper().getServletContext();
            return servletContext;
        }
        finally {
            this.exit();
        }
    }

    public HttpSessionContext getSessionContext() {
        this.enter();
        try {
            HttpSessionContext httpSessionContext = this.getSessionHelper().getHttpSessionContext();
            return httpSessionContext;
        }
        finally {
            this.exit();
        }
    }

    public Object getValue(String sName) {
        return this.getAttribute(sName);
    }

    public String[] getValueNames() {
        this.enter();
        try {
            String[] stringArray = this.ensureActiveModel().getAttributeNameArray();
            return stringArray;
        }
        finally {
            this.exit();
        }
    }

    public void invalidate() {
        String sId = null;
        this.enter();
        try {
            sId = this.ensureActiveModel().getId();
            this.getCollection().destroy(sId);
            this.m_helper.removeHttpSessionFromMap(sId);
        }
        finally {
            try {
                this.exit();
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.FINEST, "Warning: Attempt to exit session " + sId + " when it was not owned during invalidation");
            }
        }
    }

    public boolean isNew() {
        this.enter();
        try {
            boolean bl = this.ensureUsableModel().isNew();
            return bl;
        }
        finally {
            this.exit();
        }
    }

    public void putValue(String sName, Object oValue) {
        this.setAttribute(sName, oValue);
    }

    public void removeAttribute(String sName) {
        this.enter();
        try {
            this.ensureActiveModel().removeAttribute(sName);
        }
        finally {
            this.exit();
        }
    }

    public void removeValue(String sName) {
        this.removeAttribute(sName);
    }

    public void setAttribute(String sName, Object oValue) {
        this.enter();
        try {
            if (oValue == null) {
                this.ensureActiveModel().removeAttribute(sName);
            } else {
                this.ensureActiveModel().setAttribute(sName, oValue);
            }
        }
        finally {
            this.exit();
        }
    }

    public void setMaxInactiveInterval(int cSeconds) {
        this.enter();
        try {
            this.ensureUsableModel().setMaxInactiveInterval(cSeconds);
        }
        finally {
            this.exit();
        }
    }

    public String toString() {
        return "HttpSessionImpl (2.3)\n" + HttpSessionImpl.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nCollection").append(this.getCollection() == null ? "==null" : "!=null " + this.getCollection().getClass().getName()).append("\nId=").append(this.getId()).append("\nModel=").append(HttpSessionImpl.indentString((String)String.valueOf(this.getCollection().get(this.getId())), (String)"  ", (boolean)false));
        return sb.toString();
    }

    protected HttpSessionModel ensureUsableModel() {
        HttpSessionModel model = this.getCollection().get(this.getId());
        if (model == null || !model.isUsable()) {
            throw new IllegalStateException("no usable session model for id=" + this.getId());
        }
        return model;
    }

    protected HttpSessionModel ensureActiveModel() {
        HttpSessionModel model = this.ensureUsableModel();
        String sId = model.getId();
        HttpSessionCollection collection = this.getCollection();
        if (!collection.isActive(sId)) {
            collection.activate(sId, this);
        }
        return model;
    }

    protected void enter() {
        boolean fSticky;
        HttpSessionCollection collection = this.getCollection();
        String sId = this.getId();
        boolean bl = fSticky = collection instanceof AbstractHttpSessionCollection && ((AbstractHttpSessionCollection)collection).isOwnershipSticky();
        if (!collection.isOwned(sId) && !fSticky) {
            this.getSessionHelper().requestAsyncOwnership(sId);
        }
        collection.enter(sId, true);
    }

    protected void exit() {
        this.getCollection().exit(this.getId(), false);
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected HttpSessionCollection getCollection() {
        return this.m_collection;
    }
}

