/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletException;

public class ServletContextWrapper
implements ServletContext {
    private SessionHelper m_helper;
    private ServletContext m_ctx;
    private int m_nVersionMajor;
    private int m_nVersionMinor;
    private boolean m_fClustered;
    private NamedCache m_cacheAttributes;
    private static final Logger LOGGER = Logger.getLogger(ServletContextWrapper.class.getName());

    public ServletContextWrapper(SessionHelper helper, ServletContext ctx) {
        this.m_helper = helper;
        this.m_ctx = ctx;
        this.m_nVersionMajor = helper.getServletContextMajorVersion();
        this.m_nVersionMinor = helper.getServletContextMinorVersion();
        this.m_fClustered = helper.isServletContextClustered();
    }

    public Object getAttribute(String sName) {
        this.ensureCluster();
        return this.getServletContext().getAttribute(sName);
    }

    public Enumeration getAttributeNames() {
        this.ensureCluster();
        return new FilterEnumerator(this.getServletContext().getAttributeNames(), SessionHelper.NAME_FILTER);
    }

    public ServletContext getContext(String sUriPath) {
        SessionHelper helper = this.getSessionHelper();
        ServletContext ctxServer = this.getServletContext().getContext(sUriPath);
        ServletContext ctxWrapper = SessionHelperManager.getWrappedServletContext(ctxServer);
        if (ctxWrapper == null) {
            if (ctxServer != null && ctxServer.getInitParameter("coherence-sessioncollection-class") != null) {
                String sMsg;
                String string = sMsg = LOGGER.isLoggable(Level.WARNING) ? "An attempt was made to retrieve the ServletContext with URI '" + sUriPath + "'. It appears that this web application has Coherence*Web installed but has not been initialized. " : null;
                if (helper.isStrict()) {
                    if (sMsg != null) {
                        sMsg = sMsg + "Access to this ServletContext will not be allowed until it is fully initialized by the web container.";
                    }
                    ctxServer = null;
                } else if (sMsg != null) {
                    sMsg = sMsg + "Any attempt to forward to or include resources in this application prior to its initialization may result in an exception being thrown. To prevent this from happening, modify the configuration of this web application so that it is initialized when it is loaded by the web container.";
                }
                if (sMsg != null) {
                    LOGGER.log(Level.WARNING, sMsg);
                }
            }
            return ctxServer;
        }
        return ctxWrapper;
    }

    public String getInitParameter(String sName) {
        return this.getServletContext().getInitParameter(sName);
    }

    public Enumeration getInitParameterNames() {
        return new FilterEnumerator(this.getServletContext().getInitParameterNames(), SessionHelper.NAME_FILTER);
    }

    public int getMajorVersion() {
        return this.m_nVersionMajor;
    }

    public String getMimeType(String sFile) {
        return this.getServletContext().getMimeType(sFile);
    }

    public int getMinorVersion() {
        return this.m_nVersionMinor;
    }

    public RequestDispatcher getNamedDispatcher(String sName) {
        return this.getServletContext().getNamedDispatcher(sName);
    }

    public String getRealPath(String sPath) {
        return this.getServletContext().getRealPath(sPath);
    }

    public RequestDispatcher getRequestDispatcher(String sPath) {
        return this.getServletContext().getRequestDispatcher(sPath);
    }

    public URL getResource(String sPath) throws MalformedURLException {
        return this.getServletContext().getResource(sPath);
    }

    public InputStream getResourceAsStream(String sPath) {
        return this.getServletContext().getResourceAsStream(sPath);
    }

    public Set getResourcePaths(String sPath) {
        return this.getServletContext().getResourcePaths(sPath);
    }

    public String getServerInfo() {
        String sDetails;
        int ofParen;
        String sInfo = this.getServletContext().getServerInfo();
        if (sInfo == null) {
            sInfo = "unknown " + this.getMajorVersion() + "." + this.getMinorVersion();
        }
        String sServer = (ofParen = sInfo.indexOf(40)) < 0 ? sInfo : sInfo.substring(0, ofParen);
        String string = sDetails = ofParen < 0 ? "" : sInfo.substring(ofParen);
        if (sDetails.endsWith(")")) {
            sDetails = sDetails.substring(0, sDetails.length() - 1);
        }
        String sSep = sDetails.length() > 0 ? "; " : "";
        String sAppend = SessionHelper.PRODUCT_BANNER;
        return sServer + " (" + sDetails + sSep + sAppend + ")";
    }

    public Servlet getServlet(String sName) throws ServletException {
        return this.getServletContext().getServlet(sName);
    }

    public String getServletContextName() {
        return this.getServletContext().getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.getServletContext().getServletNames();
    }

    public Enumeration getServlets() {
        return this.getServletContext().getServlets();
    }

    public void log(String sMsg) {
        this.getServletContext().log(sMsg);
    }

    public void log(Exception e, String sMsg) {
        this.getServletContext().log(e, sMsg);
    }

    public void log(String sMsg, Throwable e) {
        this.getServletContext().log(sMsg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String sName) {
        SessionHelper helper = this.getSessionHelper();
        helper.addIgnoreAttributeName(sName);
        try {
            Object oOrig = this.getAttribute(sName);
            if (oOrig != null) {
                this.ensureCluster();
                this.getServletContext().removeAttribute(sName);
                if (this.isClustered()) {
                    this.getAttributeMap().remove((Object)sName);
                }
                ServletContextAttributeEvent evt = new ServletContextAttributeEvent((ServletContext)this, sName, oOrig);
                helper.dispatchInternalAttributeEvent(2, evt);
            }
        }
        finally {
            helper.removeIgnoreAttributeName(sName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String sName, Object oValue) {
        if (oValue == null) {
            this.removeAttribute(sName);
            return;
        }
        SessionHelper helper = this.getSessionHelper();
        helper.addIgnoreAttributeName(sName);
        try {
            Object oOrig;
            block9: {
                oOrig = this.getAttribute(sName);
                this.ensureCluster();
                this.getServletContext().setAttribute(sName, oValue);
                if (this.isClustered() && ExternalizableHelper.isSerializable((Object)oValue) && SessionHelper.NAME_FILTER.evaluate((Object)sName)) {
                    try {
                        this.getAttributeMap().put((Object)sName, oValue);
                    }
                    catch (RuntimeException e) {
                        if (Base.getOriginalException((RuntimeException)e) instanceof IOException) break block9;
                        throw e;
                    }
                }
            }
            if (oOrig == null) {
                ServletContextAttributeEvent evt = new ServletContextAttributeEvent((ServletContext)this, sName, oValue);
                helper.dispatchInternalAttributeEvent(1, evt);
            } else {
                ServletContextAttributeEvent evt = new ServletContextAttributeEvent((ServletContext)this, sName, oOrig);
                helper.dispatchInternalAttributeEvent(3, evt);
            }
        }
        finally {
            helper.removeIgnoreAttributeName(sName);
        }
    }

    public int hashCode() {
        return this.getServletContext().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServletContextWrapper && this.getServletContext().equals(((ServletContextWrapper)obj).getServletContext());
    }

    public String toString() {
        return "ServletContextWrapper (2.3)\n" + Base.indentString((String)this.getDescription(), (String)"  ");
    }

    public String getContextPath() {
        return null;
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nMajorVersion=").append(this.getMajorVersion()).append("\nMinorVersion=").append(this.getMinorVersion()).append("\nClustered=").append(this.isClustered()).append("\nServletContext (wrapped)=").append(Base.indentString((String)String.valueOf(this.getServletContext()), (String)"  ", (boolean)false)).append("\nAttributeMap=");
        NamedCache cache = this.getAttributeMap();
        if (cache == null) {
            sb.append("null");
        } else {
            sb.append('(').append(cache.getCacheName()).append(')');
            for (Map.Entry entry : cache.entrySet()) {
                sb.append('\n').append(Base.indentString((String)String.valueOf(entry.getKey()), (String)"  ", (boolean)true)).append('=').append(Base.indentString((String)String.valueOf(entry.getValue()), (String)"    ", (boolean)false));
            }
        }
        sb.append("\n").append(SessionHelper.PRODUCT_BANNER);
        return sb.toString();
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected ServletContext getServletContext() {
        return this.m_ctx;
    }

    protected boolean isClustered() {
        return this.m_fClustered;
    }

    protected synchronized void ensureCluster() {
        if (this.isClustered() && this.m_cacheAttributes == null) {
            NamedCache cache = this.getSessionHelper().getServletContextAttributeCache();
            MapListener listener = this.instantiateServletContextMapListener();
            cache.addMapListener(listener);
            ServletContext ctx = this.getServletContext();
            for (Map.Entry entry : cache.entrySet()) {
                String sKey = (String)entry.getKey();
                Object oValue = entry.getValue();
                try {
                    ctx.setAttribute(sKey, oValue);
                }
                catch (Exception exception) {}
            }
            this.m_cacheAttributes = cache;
        }
    }

    protected NamedCache getAttributeMap() {
        this.ensureCluster();
        return this.m_cacheAttributes;
    }

    protected MapListener instantiateServletContextMapListener() {
        return new ServletContextMapListener();
    }

    public class ServletContextMapListener
    extends Base
    implements MapListener {
        private ServletContext m_ctx;

        public ServletContextMapListener() {
            this.m_ctx = ServletContextWrapper.this.getServletContext();
        }

        public void entryInserted(MapEvent evt) {
            ServletContext ctx = this.getServletContext();
            String sName = (String)evt.getKey();
            Object oValue = evt.getNewValue();
            if (!ServletContextMapListener.equals((Object)ctx.getAttribute(sName), (Object)oValue)) {
                ctx.setAttribute(sName, oValue);
            }
        }

        public void entryUpdated(MapEvent evt) {
            ServletContext ctx = this.getServletContext();
            String sName = (String)evt.getKey();
            Object oValue = evt.getNewValue();
            if (!ServletContextMapListener.equals((Object)ctx.getAttribute(sName), (Object)oValue)) {
                ctx.setAttribute(sName, oValue);
            }
        }

        public void entryDeleted(MapEvent evt) {
            String sName;
            ServletContext ctx = this.getServletContext();
            if (ctx.getAttribute(sName = (String)evt.getKey()) != null) {
                ctx.removeAttribute(sName);
            }
        }

        protected ServletContext getServletContext() {
            return this.m_ctx;
        }
    }
}

