/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.commonj.impl;

import com.tangosol.coherence.servlet.commonj.Work;
import com.tangosol.coherence.servlet.commonj.WorkException;
import com.tangosol.coherence.servlet.commonj.WorkItem;
import com.tangosol.coherence.servlet.commonj.WorkListener;
import com.tangosol.coherence.servlet.commonj.impl.WorkEventImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkItemImpl
implements WorkItem,
Runnable {
    private final Work mWork;
    private int mStatus = -1;
    private final WorkListener mListener;
    private WorkException mWorkException;
    private static final Logger LOGGER = Logger.getLogger(WorkItemImpl.class.getName());

    public WorkItemImpl(Work work, WorkListener listener) {
        this.mWork = work;
        this.mListener = listener;
    }

    @Override
    public Work getResult() throws WorkException {
        return this.mWork;
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    synchronized void setStatus(int status) {
        switch (status) {
            case 1: {
                if (this.mStatus != -1) break;
                this.setAccepted();
                break;
            }
            case 3: {
                if (this.mStatus != -1) break;
                this.setRejected();
                break;
            }
            case 4: {
                if (this.mStatus == -1) {
                    this.setAccepted();
                }
                if (this.mStatus != 1) break;
                this.setStarted();
                break;
            }
            case 2: {
                if (this.mStatus == -1) {
                    this.setAccepted();
                }
                if (this.mStatus == 1) {
                    this.setStarted();
                }
                if (this.mStatus != 4) break;
                this.setCompleted();
            }
        }
    }

    private void setAccepted() {
        this.mStatus = 1;
        if (this.mListener != null) {
            try {
                this.mListener.workAccepted(new WorkEventImpl(null, this.mStatus, this));
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.SEVERE, "Work listener threw RuntimeException.", re);
            }
        }
    }

    private void setRejected() {
        this.mStatus = 3;
        if (this.mListener != null) {
            try {
                this.mListener.workRejected(new WorkEventImpl(null, this.mStatus, this));
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.SEVERE, "Work listener threw RuntimeException.", re);
            }
        }
    }

    private void setStarted() {
        this.mStatus = 4;
        if (this.mListener != null) {
            try {
                this.mListener.workStarted(new WorkEventImpl(null, this.mStatus, this));
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.SEVERE, "Work listener threw RuntimeException.", re);
            }
        }
    }

    private void setCompleted() {
        this.mStatus = 2;
        if (this.mListener != null) {
            try {
                this.mListener.workCompleted(new WorkEventImpl(this.mWorkException, this.mStatus, this));
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.SEVERE, "Work listener threw RuntimeException.", re);
            }
        }
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("compareTo has not been implemented.");
    }

    @Override
    public void run() {
        try {
            this.setStatus(4);
            this.mWork.run();
        }
        catch (Throwable e) {
            this.mWorkException = new WorkException("Work Failed.", e);
        }
        finally {
            this.setStatus(2);
        }
    }
}

