/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.liberty85;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperFactory;
import com.tangosol.net.cache.LocalCache;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieHelper
extends SessionHelper {
    private LocalCache m_cacheFailover = new LocalCache(128);
    private String m_sAffinitySuffix;
    private String m_sSuffixSeparator;
    private boolean m_fUseAffinity;
    private String m_sSessionIdPrefix;

    public CookieHelper(SessionHelperFactory factory, ServletContext ctx) {
        super(factory, ctx);
    }

    @Override
    protected void configure() {
        super.configure();
        this.configurePrefixAndSuffix();
    }

    @Override
    public String decodeCookie(HttpServletRequest req) {
        String sSessionId = super.decodeCookie(req);
        int sessionIdPrefixLength = this.getSessionIdPrefix().length();
        if (sSessionId != null && sSessionId.length() > sessionIdPrefixLength) {
            int ofSeparator;
            sSessionId = sSessionId.substring(sessionIdPrefixLength);
            if (this.isAffinityConfigured() && (ofSeparator = sSessionId.indexOf(this.getSuffixSeparator())) >= 0) {
                String sServerSuffix = this.getAffinitySuffix();
                String sSessionSuffix = sSessionId.substring(ofSeparator + 1);
                sSessionId = sSessionId.substring(0, ofSeparator);
                if (!sSessionSuffix.equals(sServerSuffix)) {
                    this.m_cacheFailover.put((Object)sSessionId, (Object)sSessionSuffix);
                }
            }
        }
        return sSessionId;
    }

    @Override
    public void encodeCookie(HttpServletRequest req, HttpServletResponse resp, String sId, boolean fNew) {
        sId = this.getSessionIdPrefix() + sId;
        if (this.isAffinityConfigured() && this.m_cacheFailover.remove((Object)(sId = sId + this.getSuffixSeparator() + this.getAffinitySuffix())) != null) {
            fNew = true;
        }
        super.encodeCookie(req, resp, sId, fNew);
    }

    @Override
    protected String decodeUri(String uri) {
        String sSessionId = super.decodeUri(uri);
        int sessionIdPrefixLength = this.getSessionIdPrefix().length();
        if (sSessionId != null && sSessionId.length() > sessionIdPrefixLength) {
            int ofSeparator;
            sSessionId = sSessionId.substring(sessionIdPrefixLength);
            if (this.isAffinityConfigured() && (ofSeparator = sSessionId.indexOf(this.getSuffixSeparator())) >= 0) {
                sSessionId = sSessionId.substring(0, ofSeparator);
            }
        }
        return sSessionId;
    }

    @Override
    protected String encodeUrl(String sUrl, String sId) {
        sId = this.getSessionIdPrefix() + sId;
        if (this.isAffinityConfigured()) {
            sId = sId + this.getSuffixSeparator() + this.getAffinitySuffix();
        }
        return super.encodeUrl(sUrl, sId);
    }

    protected void configurePrefixAndSuffix() {
        this.m_sSessionIdPrefix = System.getProperty("coherence.web.liberty.sessionid.prefix", "0000");
        this.m_sSuffixSeparator = System.getProperty("coherence.web.liberty.suffix.separator", ":");
        this.m_sAffinitySuffix = System.getProperty("coherence.web.liberty.suffix", System.getProperty("cloneId"));
        this.m_fUseAffinity = this.m_sSuffixSeparator != null && this.m_sAffinitySuffix != null;
    }

    public String getAffinitySuffix() {
        return this.m_sAffinitySuffix;
    }

    public String getSuffixSeparator() {
        return this.m_sSuffixSeparator;
    }

    public boolean isAffinityConfigured() {
        return this.m_fUseAffinity;
    }

    public String getSessionIdPrefix() {
        return this.m_sSessionIdPrefix;
    }
}

