/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Timeout;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;

public class Blocking {
    public static boolean interrupted() {
        Timeout.isTimedOut();
        return Thread.interrupted();
    }

    public static void wait(Object oMonitor) throws InterruptedException {
        Blocking.wait(oMonitor, 0L, 0);
    }

    public static void wait(Object oMonitor, long cMillis) throws InterruptedException {
        Blocking.wait(oMonitor, cMillis, 0);
    }

    public static void wait(Object oMonitor, long cMillis, int cNanos) throws InterruptedException {
        long cMillisBlock = Math.min(Timeout.remainingTimeoutMillis(), cMillis == 0L ? Long.MAX_VALUE : cMillis);
        oMonitor.wait(cMillisBlock == Long.MAX_VALUE ? 0L : cMillisBlock, cNanos);
    }

    public static void sleep(long cMillis) throws InterruptedException {
        Blocking.sleep(cMillis, 0);
    }

    public static void sleep(long cMillis, int cNanos) throws InterruptedException {
        Thread.sleep(Math.min(Timeout.remainingTimeoutMillis(), cMillis), cNanos);
    }

    public static void park(Object oBlocker) {
        Blocking.parkNanos(oBlocker, Long.MAX_VALUE);
    }

    public static void parkNanos(Object oBlocker, long cNanos) {
        long cNanosTimeout;
        long cMillisTimeout = Timeout.remainingTimeoutMillis();
        long l = cNanosTimeout = cMillisTimeout >= 9223372036854L ? Long.MAX_VALUE : cMillisTimeout * 1000000L;
        if (cMillisTimeout == Long.MAX_VALUE && cNanos == Long.MAX_VALUE) {
            LockSupport.park(oBlocker);
        } else {
            LockSupport.parkNanos(oBlocker, Math.min(cNanos, Math.min(cNanos, cNanosTimeout)));
        }
    }

    public static void lockInterruptibly(Lock lock) throws InterruptedException {
        while (!Blocking.tryLock(lock, Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
        }
    }

    public static boolean tryLock(Lock lock, long time, TimeUnit unit) throws InterruptedException {
        long cMillisTimeout = Timeout.remainingTimeoutMillis();
        long cMillis = unit.toMillis(time);
        if (cMillis == 0L) {
            return lock.tryLock(time, unit);
        }
        return lock.tryLock(Math.min(cMillisTimeout, cMillis), TimeUnit.MILLISECONDS);
    }

    public static void await(Condition cond) throws InterruptedException {
        Blocking.await(cond, Long.MAX_VALUE);
    }

    public static void await(Condition cond, long cNanos) throws InterruptedException {
        Blocking.await(cond, cNanos, TimeUnit.NANOSECONDS);
    }

    public static void await(Condition cond, long time, TimeUnit unit) throws InterruptedException {
        long cMillisTimeout = Timeout.remainingTimeoutMillis();
        long cMillis = unit.toMillis(time);
        if (cMillis == 0L) {
            cond.await(time, unit);
        } else {
            cond.await(Math.min(cMillisTimeout, cMillis), TimeUnit.MILLISECONDS);
        }
    }

    public static int select(Selector selector) throws IOException {
        return Blocking.select(selector, 0L);
    }

    public static int select(Selector selector, long cMillis) throws IOException {
        long cMillisBlock = Math.min(Timeout.remainingTimeoutMillis(), cMillis == 0L ? Long.MAX_VALUE : cMillis);
        return selector.select(cMillisBlock == Long.MAX_VALUE ? 0L : cMillisBlock);
    }

    public static void connect(Socket socket, SocketAddress addr) throws IOException {
        Blocking.connect(socket, addr, 0);
    }

    public static void connect(Socket socket, SocketAddress addr, int cMillis) throws IOException {
        long cMillisBlock = Math.min(Timeout.remainingTimeoutMillis(), cMillis == 0 ? Long.MAX_VALUE : (long)cMillis);
        socket.connect(addr, cMillisBlock >= Integer.MAX_VALUE ? 0 : (int)cMillisBlock);
    }
}

