/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.util.SafeClock;
import java.util.concurrent.TimeUnit;

public class Timeout
implements AutoCloseable {
    protected final boolean f_fTloCreator;
    protected final MutableLong f_mlTimeout;
    protected final long f_cMillisTimeout;
    protected final long f_lTimeoutOrig;
    protected static final ThreadLocal<MutableLong> s_tloTimeout = new ThreadLocal();

    protected Timeout(long cMillis, boolean fForceOverride) {
        MutableLong mlTimeout = s_tloTimeout.get();
        if (mlTimeout == null) {
            mlTimeout = new MutableLong(Long.MAX_VALUE);
            s_tloTimeout.set(mlTimeout);
            this.f_fTloCreator = true;
        } else {
            this.f_fTloCreator = false;
        }
        this.f_mlTimeout = mlTimeout;
        this.f_lTimeoutOrig = this.f_mlTimeout.get();
        if (this.f_lTimeoutOrig == Long.MAX_VALUE) {
            this.f_cMillisTimeout = cMillis;
            this.f_mlTimeout.set(-cMillis);
        } else if (this.f_lTimeoutOrig < 0L) {
            if (fForceOverride || cMillis < -this.f_lTimeoutOrig) {
                this.f_cMillisTimeout = cMillis;
                this.f_mlTimeout.set(-cMillis);
            } else {
                this.f_cMillisTimeout = this.f_lTimeoutOrig;
            }
        } else {
            long ldtTimeout = SafeClock.INSTANCE.getSafeTimeMillis() + cMillis;
            if (fForceOverride || ldtTimeout < this.f_lTimeoutOrig) {
                this.f_cMillisTimeout = cMillis;
                this.f_mlTimeout.set(ldtTimeout);
            } else {
                this.f_cMillisTimeout = this.f_lTimeoutOrig;
            }
        }
    }

    @Override
    public void close() throws InterruptedException {
        if (this.f_fTloCreator) {
            s_tloTimeout.set(null);
        } else if (this.f_lTimeoutOrig < 0L) {
            long lTimeoutCurr = this.f_mlTimeout.get();
            if (lTimeoutCurr < 0L || lTimeoutCurr == Long.MAX_VALUE) {
                this.f_mlTimeout.set(this.f_lTimeoutOrig);
            } else {
                this.f_mlTimeout.set(lTimeoutCurr + (-this.f_lTimeoutOrig - this.f_cMillisTimeout));
            }
        } else {
            this.f_mlTimeout.set(this.f_lTimeoutOrig);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static Timeout after(long time, TimeUnit unit) {
        return Timeout.after(Math.max(unit.toMillis(time), 1L));
    }

    public static Timeout after(long cMillis) {
        return new Timeout(cMillis, false);
    }

    public static Timeout override(long cMillis) {
        return new Timeout(cMillis, true);
    }

    public static long remainingTimeoutMillis() {
        MutableLong mlTimeout = s_tloTimeout.get();
        if (mlTimeout == null) {
            return Long.MAX_VALUE;
        }
        long lTimeout = mlTimeout.get();
        long ldtNow = SafeClock.INSTANCE.getSafeTimeMillis();
        if (lTimeout < 0L) {
            mlTimeout.set(ldtNow - lTimeout);
            return -lTimeout;
        }
        long cMillis = lTimeout - ldtNow;
        if (cMillis <= 0L) {
            Thread.currentThread().interrupt();
            return 0L;
        }
        return cMillis;
    }

    public static boolean isTimedOut() {
        return Timeout.remainingTimeoutMillis() == 0L;
    }
}

