/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class Arrays {
    private static final Random s_rand = new Random();

    public static void shuffle(Object[] ao, int of, int c) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = c; i > 1; --i) {
            int r = ((Random)rand).nextInt(i);
            Object o = ao[of + i - 1];
            ao[of + i - 1] = ao[of + r];
            ao[of + r] = o;
        }
    }

    public static void shuffle(Object[] ao) {
        Arrays.shuffle(ao, 0, ao.length);
    }

    public static int[] binaryInsert(int[] an, int n) {
        if (an == null) {
            return new int[]{n};
        }
        int of = java.util.Arrays.binarySearch(an, n);
        if (of < 0) {
            of = -of;
            int[] anNew = new int[an.length + 1];
            System.arraycopy(an, 0, anNew, 0, of - 1);
            anNew[of - 1] = n;
            System.arraycopy(an, of - 1, anNew, of, an.length - of + 1);
            return anNew;
        }
        return an;
    }
}

