/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.internal.net.WrapperSocketChannel;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public final class InterruptibleChannels {
    private static final Field s_fieldInterruptor;
    private static final Object s_interruptibleNoOp;

    public static boolean setInterruptible(AbstractInterruptibleChannel chan, boolean fInterruptible) {
        if (s_fieldInterruptor == null || !fInterruptible && s_interruptibleNoOp == null) {
            return false;
        }
        try {
            while (chan instanceof WrapperSocketChannel) {
                chan = ((WrapperSocketChannel)chan).f_delegate;
            }
            s_fieldInterruptor.set(chan, fInterruptible ? null : s_interruptibleNoOp);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        Field field = null;
        try {
            if (System.getProperty("java.vm.specification.version").startsWith("1.")) {
                Field fieldTmp = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
                fieldTmp.setAccessible(true);
                field = fieldTmp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_fieldInterruptor = field;
        s_interruptibleNoOp = field == null ? null : new InterruptibleFetcher().fetch();
    }

    private static class InterruptibleFetcher
    extends AbstractInterruptibleChannel {
        private InterruptibleFetcher() {
        }

        Object fetch() {
            try {
                this.begin();
                Object object = s_fieldInterruptor.get(this);
                return object;
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    this.end(true);
                    this.close();
                }
                catch (Throwable throwable) {}
            }
            return null;
        }

        @Override
        protected void implCloseChannel() throws IOException {
        }
    }
}

