/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.socketbus;

import com.oracle.coherence.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.internal.util.HeapDump;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.util.SimpleEvent;
import com.oracle.coherence.common.net.exabus.util.UrlEndPoint;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.common.util.SafeClock;
import java.io.DataInput;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.zip.CRC32;

public abstract class BufferedSocketBus
extends AbstractSocketBus {
    protected static final int MIGRATION_LIMIT_BEFORE_DUMP = 4;
    protected static final byte MSG_RECEIPT = 1;
    protected static final byte MSG_SYNC = 2;
    protected static final byte SYNC_CMD_NONE = 0;
    protected static final byte SYNC_CMD_DUMP = 1;
    protected static final Object RECEIPT_MSG_MARKER = new Object();
    protected static final Object RECEIPT_HEADER_RECYCLE = new Object();
    protected static final Object RECEIPT_MSG_MARKER_HEADER_RECYCLE = new Object();
    protected static final Object RECEIPT_ACKREQ_MARKER = new Object();
    protected static final Object RECEIPT_ACKREQ_MARKER_RECYCLE = new Object();
    protected static final Object RECEIPT_NO_EMIT = new Object();
    protected static final ByteBuffer[] EMPTY_BUFFER_ARRAY = new ByteBuffer[0];

    public BufferedSocketBus(SocketBusDriver driver, UrlEndPoint pointLocal) throws IOException {
        super(driver, pointLocal);
    }

    @Override
    protected void onOpen() {
        final long cMillisFlush = this.f_driver.getDependencies().getMaximumReceiptDelayMillis();
        if (cMillisFlush > 0L) {
            this.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    BufferedSocketBus.this.scheduleTask(this, cMillisFlush);
                    for (AbstractSocketBus.Connection conn : BufferedSocketBus.this.getRegisteredConnections()) {
                        if (!((BufferedConnection)conn).isReceiptFlushRequired()) continue;
                        conn.optimisticFlush();
                    }
                }
            }, cMillisFlush);
        }
        super.onOpen();
    }

    public abstract class BufferedConnection
    extends AbstractSocketBus.Connection {
        protected WriteBatch m_batchWriteTail;
        protected WriteBatch m_batchWriteSendHead;
        protected WriteBatch m_batchWriteResendHead;
        protected final AtomicLong f_cbQueued;
        protected long m_cbHeartbeatLast;
        protected boolean m_fIdle;
        protected long m_cbAutoFlushThreshold;
        protected long m_cbForceAckThreshold;
        protected long m_cbBacklogExcessiveThreshold;
        protected int m_nInterestOpsLast;
        protected volatile WriteBatch m_batchWriteUnflushed;
        protected int m_cWritersBatch;
        protected long m_lWritersBatchBitSet;
        protected boolean m_fBacklog;
        protected final AtomicBoolean m_fBacklogScheduled;
        protected int m_cReceiptsUnflushed;
        protected final AtomicInteger m_cReceiptsReturn;
        protected final AtomicLong f_cBytesUnacked;
        protected ByteBuffer m_bufferRecycleOutboundReceipts;
        protected final AtomicInteger m_cWritersWaiting;
        protected long m_cMsgIn;
        protected long m_cMsgInSkip;
        protected long m_cReceiptsEmitted;
        protected long m_cMsgOutDelivered;
        protected long m_cbReadLastCheck;
        protected long m_cbWriteLastCheck;
        protected long m_ldtAckTimeout;
        protected long m_ldtForceHeartbeat;
        protected int m_nIdUnackLast;
        protected int m_cUnackLast;
        protected long m_ldtAckFatalTimeout;
        protected final Object[] f_aoReceiptTmp;

        public BufferedConnection(UrlEndPoint peer) {
            super(peer);
            this.m_batchWriteSendHead = this.m_batchWriteTail = new WriteBatch(false);
            this.m_batchWriteResendHead = this.m_batchWriteTail;
            this.f_cbQueued = new AtomicLong();
            this.m_batchWriteUnflushed = this.m_batchWriteTail;
            this.m_fBacklogScheduled = new AtomicBoolean();
            this.m_cReceiptsReturn = new AtomicInteger();
            this.f_cBytesUnacked = new AtomicLong();
            this.m_cWritersWaiting = new AtomicInteger();
            this.f_aoReceiptTmp = new Object[16];
        }

        protected long getAutoFlushThreshold() {
            long cb = this.m_cbAutoFlushThreshold;
            if (cb <= 0L) {
                try {
                    cb = BufferedSocketBus.this.f_driver.getDependencies().getAutoFlushThreshold();
                    if (cb <= 0L) {
                        cb = Math.min(this.getPacketSize() * 9, this.getSendBufferSize() / 4);
                    }
                    this.m_cbAutoFlushThreshold = cb;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 65536L;
                }
            }
            return cb;
        }

        protected long getForceAckThreshold() {
            long cb = this.m_cbForceAckThreshold;
            if (cb <= 0L) {
                cb = BufferedSocketBus.this.f_driver.getDependencies().getReceiptRequestThreshold();
                try {
                    if (cb <= 0L) {
                        cb = this.getSendBufferSize() * 3;
                    }
                    this.m_cbForceAckThreshold = cb;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 196608L;
                }
            }
            return cb;
        }

        protected long getBacklogExcessiveThreshold() {
            long cb = this.m_cbBacklogExcessiveThreshold;
            if (cb <= 0L) {
                try {
                    this.m_cbBacklogExcessiveThreshold = cb = (long)this.getSendBufferSize();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 0x100000L;
                }
            }
            return cb;
        }

        @Override
        public BufferedConnection ensureValid() {
            super.ensureValid();
            return this;
        }

        protected int getConcurrentWriters() {
            return this.m_cWritersWaiting.get() + this.m_cWritersBatch;
        }

        protected void evaluateAutoFlush(boolean fFlushInProg, boolean fFlushPending, long cbPending) {
            if (!fFlushInProg) {
                if (cbPending > this.getAutoFlushThreshold()) {
                    if (!this.flush(true)) {
                        if (!fFlushPending) {
                            BufferedSocketBus.this.addFlushable(this);
                        }
                    } else if (fFlushPending) {
                        BufferedSocketBus.this.removeFlushable(this);
                    }
                } else if (!fFlushPending) {
                    BufferedSocketBus.this.addFlushable(this);
                }
            }
        }

        protected void addWriter() {
            long lBitId = 1L << (int)Thread.currentThread().getId();
            if ((this.m_lWritersBatchBitSet & lBitId) == 0L) {
                this.m_lWritersBatchBitSet |= lBitId;
                ++this.m_cWritersBatch;
            }
        }

        @Override
        public void flush() {
            if (this.flush(false)) {
                BufferedSocketBus.this.removeFlushable(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean flush(boolean fAuto) {
            WriteBatch batch;
            block16: {
                SocketBusDriver.Dependencies deps = BufferedSocketBus.this.getSocketDriver().getDependencies();
                batch = this.m_batchWriteUnflushed;
                int cRecReq = this.m_cReceiptsUnflushed;
                int cRecRet = this.m_cReceiptsReturn.getAndSet(0);
                long cUnackedBytes = this.f_cBytesUnacked.get();
                if (cRecReq > 0 && cUnackedBytes > this.getForceAckThreshold()) {
                    cRecReq = -cRecReq;
                    this.f_cBytesUnacked.set(0L);
                }
                if (cRecReq != 0 || cRecRet != 0 || this.m_fIdle) {
                    this.m_fIdle = false;
                    if (batch == null) {
                        this.m_batchWriteUnflushed = batch = new WriteBatch();
                    }
                    int cbReceipt = this.getReceiptSize();
                    ByteBuffer bufferMsgReceipt = this.m_bufferRecycleOutboundReceipts;
                    if (bufferMsgReceipt == null) {
                        bufferMsgReceipt = this.m_bufferRecycleOutboundReceipts = deps.getBufferManager().acquire(cbReceipt * 1024);
                        int cbCap = bufferMsgReceipt.capacity();
                        bufferMsgReceipt.limit(cbCap - cbCap % cbReceipt);
                    }
                    if (bufferMsgReceipt.remaining() > cbReceipt) {
                        ByteBuffer buffReceipt = bufferMsgReceipt.slice();
                        this.writeMsgReceipt(buffReceipt, cRecReq, cRecRet);
                        bufferMsgReceipt.position(bufferMsgReceipt.position() + cbReceipt);
                        batch.append(buffReceipt, false, null, cRecReq == 0 ? null : RECEIPT_ACKREQ_MARKER);
                    } else {
                        bufferMsgReceipt.mark();
                        this.writeMsgReceipt(bufferMsgReceipt, cRecReq, cRecRet);
                        batch.append(bufferMsgReceipt, true, null, cRecReq == 0 ? null : RECEIPT_ACKREQ_MARKER_RECYCLE);
                        this.m_bufferRecycleOutboundReceipts = null;
                    }
                    this.m_cReceiptsUnflushed = 0;
                }
                if (batch == null) {
                    return true;
                }
                if (this.f_cbQueued.get() == 0L && this.getConcurrentWriters() <= deps.getDirectWriteThreadThreshold()) {
                    this.m_batchWriteSendHead = batch;
                    try {
                        WriteBatch cbReceipt = batch;
                        synchronized (cbReceipt) {
                            if (batch.write()) {
                                this.m_cWritersBatch = 0;
                                this.m_lWritersBatchBitSet = 0L;
                                return true;
                            }
                            break block16;
                        }
                    }
                    catch (IOException e) {
                        this.m_batchWriteUnflushed = null;
                        this.enqueueWriteBatch(batch);
                        this.onException(e);
                        return true;
                    }
                }
                if (this.m_state == AbstractSocketBus.ConnectionState.DEFUNCT) {
                    this.scheduleDisconnect(null);
                }
            }
            if (fAuto && batch.getLength() < this.getBacklogExcessiveThreshold() * 2L) {
                return false;
            }
            this.m_batchWriteUnflushed = null;
            this.m_cWritersBatch = 0;
            this.m_lWritersBatchBitSet = 0L;
            this.enqueueWriteBatch(batch);
            return true;
        }

        @Override
        protected boolean heartbeat() {
            long cbHeartbeat = this.m_cbWrite;
            boolean fResult = false;
            if (cbHeartbeat == this.m_cbHeartbeatLast && this.f_cbQueued.get() == 0L) {
                this.m_fIdle = true;
                this.optimisticFlush();
                fResult = true;
            }
            this.m_cbHeartbeatLast = cbHeartbeat;
            return fResult;
        }

        public void enqueueWriteBatch(WriteBatch batch) {
            long cbExcessive;
            long cbBatch = batch.getLength();
            long cbQueuedNow = this.f_cbQueued.addAndGet(cbBatch);
            if (cbQueuedNow == cbBatch) {
                try {
                    this.wakeup();
                }
                catch (IOException e) {
                    this.onException(e);
                }
            }
            if (cbQueuedNow > (cbExcessive = this.getBacklogExcessiveThreshold()) * 2L && this.m_fBacklogScheduled.compareAndSet(false, true)) {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        BufferedConnection.this.m_fBacklogScheduled.set(false);
                        if (BufferedConnection.this.isValid() && !BufferedConnection.this.m_fBacklog && BufferedConnection.this.f_cbQueued.get() > cbExcessive) {
                            BufferedConnection.this.m_fBacklog = true;
                            BufferedSocketBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_EXCESSIVE, BufferedConnection.this.getPeer()));
                        }
                    }
                });
            }
        }

        protected ByteBuffer writeMsgReceipt(ByteBuffer buff, int cRecReq, int cRecRet) {
            int nProt = this.getProtocolVersion();
            int nPos0 = buff.position();
            if (nProt > 4) {
                buff.putLong(-9L).position(nPos0 + 16);
            } else {
                buff.putInt(-9);
            }
            buff.put((byte)1).putInt(cRecReq).putInt(cRecRet);
            buff.limit(buff.position()).position(nPos0);
            if (nProt > 4) {
                this.populateCtrlMsgHeaderCrc(buff);
            }
            return buff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processReceipt(DataInput in) throws IOException {
            int cReturned;
            int cReceiptsRequested = in.readInt();
            if (cReceiptsRequested < 0 || BufferedSocketBus.this.getSocketDriver().getDependencies().getMaximumReceiptDelayMillis() == 0L) {
                this.m_cReceiptsReturn.addAndGet(cReceiptsRequested < 0 ? -cReceiptsRequested : cReceiptsRequested);
                if (this.isReceiptFlushRequired()) {
                    this.optimisticFlush();
                }
            } else {
                this.m_cReceiptsReturn.addAndGet(cReceiptsRequested);
            }
            if ((cReturned = in.readInt()) > 0) {
                EndPoint epPeer = this.getPeer();
                WriteBatch batchResend = this.m_batchWriteResendHead;
                WriteBatch batchNext = batchResend.next();
                while (true) {
                    int cEmit;
                    if (batchNext == null && this.m_batchWriteUnflushed == batchResend) {
                        WriteBatch writeBatch = batchResend;
                        synchronized (writeBatch) {
                            cEmit = batchResend.ack(cReturned, this.f_aoReceiptTmp);
                            cReturned -= cEmit;
                        }
                    } else {
                        cEmit = batchResend.ack(cReturned, this.f_aoReceiptTmp);
                        cReturned -= cEmit;
                    }
                    for (int i = 0; i < cEmit; ++i) {
                        Object oReceipt = this.f_aoReceiptTmp[i];
                        this.f_aoReceiptTmp[i] = null;
                        if (oReceipt == RECEIPT_NO_EMIT) continue;
                        BufferedSocketBus.this.addEvent(new SimpleEvent(Event.Type.RECEIPT, epPeer, oReceipt));
                        ++this.m_cReceiptsEmitted;
                    }
                    if (cReturned == 0) break;
                    if (cEmit >= this.f_aoReceiptTmp.length) continue;
                    WriteBatch batchSend = this.m_batchWriteSendHead;
                    if (batchSend.m_ofAck != batchSend.m_ofAdd) {
                        batchResend.m_next = null;
                    }
                    batchResend = batchNext;
                    batchNext = batchResend.next();
                }
                this.m_batchWriteResendHead = batchResend;
                this.f_cBytesUnacked.set(0L);
            }
        }

        protected void processSync(DataInput in) throws IOException {
            byte nCmdSync;
            long cMsgOut = this.m_cMsgOutDelivered;
            long cMsgIn = this.m_cMsgIn;
            long cMsgAcked = in.readLong();
            long cMsgReceived = in.readLong();
            byte by = nCmdSync = this.getProtocolVersion() < 3 ? (byte)0 : in.readByte();
            if ((nCmdSync & 1) != 0) {
                String sDump = HeapDump.dumpHeapForBug("Bug-27585336-tmb-migration");
                BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.WARNING, "{0} migration with {1} appears to not be progressing on {2}; {3} collected for analysis", BufferedSocketBus.this.getLocalEndPoint(), this.getPeer(), this, sDump));
            }
            if (cMsgAcked > cMsgIn || cMsgOut > cMsgReceived) {
                this.scheduleDisconnect(new IOException("out of sync during migration in " + cMsgAcked + "/" + cMsgIn + ", out " + cMsgOut + "/" + cMsgReceived));
            } else {
                long cSkip = this.m_cMsgInSkip = cMsgIn - cMsgAcked;
                long cRedeliver = cMsgReceived - cMsgOut;
                BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.FINE, "{0} synchronizing migrated connection with {1} will result in {2} skips and {3} re-deliveries: {4}", BufferedSocketBus.this.getLocalEndPoint(), this.getPeer(), cSkip, cRedeliver, this));
            }
        }

        protected boolean isReceiptFlushRequired() {
            return (this.m_cReceiptsReturn.get() > 0 || this.m_fIdle) && !this.isFlushRequired();
        }

        protected boolean isFlushRequired() {
            WriteBatch batch = this.m_batchWriteUnflushed;
            return batch != null && batch.m_ofSend < batch.m_ofAdd;
        }

        @Override
        public int onReadySafe(int nOps) throws IOException {
            this.m_nInterestOpsLast = this.processReads((nOps & 1) != 0) | this.processWrites((nOps & 4) != 0);
            return this.m_nInterestOpsLast;
        }

        @Override
        protected void checkHealth(long ldtNow) {
            boolean fReadHealthy;
            WriteBatch batchUnacked;
            int ofReceiptUnacked;
            Object oReceiptUnacked;
            long cbRead;
            long ldtAckTimeout;
            boolean fWriteHealthy;
            long cbWrite;
            block21: {
                if (this.m_state == null || this.m_state.ordinal() > AbstractSocketBus.ConnectionState.ACTIVE.ordinal()) {
                    return;
                }
                cbWrite = this.m_cbWrite;
                long cbWriteLast = this.m_cbWriteLastCheck;
                fWriteHealthy = cbWrite > cbWriteLast || this.f_cbQueued.get() == 0L;
                ldtAckTimeout = this.m_ldtAckTimeout;
                cbRead = this.m_cbRead;
                oReceiptUnacked = null;
                ofReceiptUnacked = 0;
                batchUnacked = null;
                this.f_cBytesUnacked.get();
                fReadHealthy = true;
                if (cbRead == this.m_cbReadLastCheck) {
                    for (WriteBatch batchResend = this.m_batchWriteResendHead; batchResend != null; batchResend = batchResend.next()) {
                        Object[] aReceipt = batchResend.m_aReceipt;
                        int ofSafe = aReceipt.length;
                        int e = Math.min(ofSafe, batchResend.m_ofSend);
                        for (int i = Math.min(ofSafe, batchResend.m_ofAck); i < e; ++i) {
                            Object oReceipt = aReceipt[i];
                            if (oReceiptUnacked == null) {
                                if (oReceipt == null || oReceipt == RECEIPT_MSG_MARKER || oReceipt == RECEIPT_HEADER_RECYCLE || oReceipt == RECEIPT_MSG_MARKER_HEADER_RECYCLE || oReceipt == RECEIPT_ACKREQ_MARKER || oReceipt == RECEIPT_ACKREQ_MARKER_RECYCLE) continue;
                                oReceiptUnacked = oReceipt;
                                ofReceiptUnacked = i;
                                batchUnacked = batchResend;
                                continue;
                            }
                            if (oReceipt != RECEIPT_ACKREQ_MARKER && oReceipt != RECEIPT_ACKREQ_MARKER_RECYCLE) continue;
                            fReadHealthy = false;
                            break block21;
                        }
                    }
                } else {
                    fReadHealthy = true;
                    if ((this.m_nInterestOpsLast & OP_EAGER) == 0) {
                        this.m_ldtForceHeartbeat = 0L;
                    } else if (this.m_ldtForceHeartbeat == 0L || ldtNow > this.m_ldtForceHeartbeat && this.heartbeat()) {
                        this.m_ldtForceHeartbeat = ldtNow + BufferedSocketBus.this.f_driver.getDependencies().getAckTimeoutMillis() / 3L;
                    }
                }
            }
            if (fReadHealthy && fWriteHealthy) {
                this.m_ldtAckTimeout = 0L;
                this.m_ldtAckFatalTimeout = 0L;
                this.m_cbWriteLastCheck = cbWrite;
                this.m_cbReadLastCheck = cbRead;
            } else if (ldtAckTimeout == 0L) {
                long cMillisTimeout = BufferedSocketBus.this.f_driver.getDependencies().getAckTimeoutMillis();
                this.m_ldtAckTimeout = cMillisTimeout == 0L || this.getProtocolVersion() == 0 ? Long.MAX_VALUE : ldtNow + cMillisTimeout;
                cMillisTimeout = BufferedSocketBus.this.f_driver.getDependencies().getAckFatalTimeoutMillis();
                this.m_ldtAckFatalTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : ldtNow + cMillisTimeout;
            } else if (ldtNow >= this.m_ldtAckFatalTimeout) {
                long cMillisTimeout = BufferedSocketBus.this.f_driver.getDependencies().getAckFatalTimeoutMillis();
                Duration dur = new Duration(cMillisTimeout, Duration.Magnitude.MILLI);
                BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.WARNING, "{0} dropping connection with {1} after {2} fatal ack timeout health(read={3}, write={4}), receiptWait={5}: {6}", BufferedSocketBus.this.getLocalEndPoint(), this.getPeer(), dur, fReadHealthy, fWriteHealthy, oReceiptUnacked, this));
                this.scheduleDisconnect(new IOException("fatal ack timeout after " + dur));
            } else if (ldtNow >= ldtAckTimeout) {
                int cMultCap = 10;
                long cMillisTimeout = BufferedSocketBus.this.f_driver.getDependencies().getAckTimeoutMillis();
                Duration dur = new Duration(cMillisTimeout * (long)Math.min(10, this.m_cUnackLast + 1), Duration.Magnitude.MILLI);
                BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.WARNING, "{0} initiating connection migration with {1} after {2} ack timeout health(read={3}, write={4}), receiptWait={5}: {6}", BufferedSocketBus.this.getLocalEndPoint(), this.getPeer(), dur, fReadHealthy, fWriteHealthy, oReceiptUnacked, this));
                if (oReceiptUnacked == null) {
                    this.m_nIdUnackLast = 0;
                    this.m_cUnackLast = 0;
                } else {
                    int nId = System.identityHashCode(oReceiptUnacked) ^ System.identityHashCode(batchUnacked) ^ ofReceiptUnacked;
                    if (nId == this.m_nIdUnackLast) {
                        int cStuck = ++this.m_cUnackLast;
                        cMillisTimeout *= (long)Math.min(10, cStuck + 1);
                        if (cStuck == 4) {
                            String sName = HeapDump.dumpHeapForBug("Bug-27585336-tmb-migration");
                            BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.WARNING, "{0} has failed to deliver {1} to {2} after {3} attempts, {4} has been collected for analysis", BufferedSocketBus.this.getLocalEndPoint(), oReceiptUnacked, this, cStuck, sName));
                            ldtNow = SafeClock.INSTANCE.getSafeTimeMillis();
                        }
                    } else {
                        this.m_cUnackLast = 0;
                    }
                    this.m_nIdUnackLast = nId;
                }
                this.m_ldtAckTimeout = ldtNow + cMillisTimeout;
                this.migrate(new IOException("ack timeout after " + dur));
            }
        }

        @Override
        public void onMigration() {
            WriteBatch batchResendHead;
            super.onMigration();
            BufferedSocketBus.this.getLogger().log(BufferedSocketBus.this.makeRecord(Level.FINER, "{0} migrating connection with {1}", BufferedSocketBus.this.getLocalEndPoint(), this));
            this.m_cMsgInSkip = 0L;
            WriteBatch batchWriteUnflushed = this.m_batchWriteUnflushed;
            if (batchWriteUnflushed != null) {
                this.m_batchWriteUnflushed = null;
                this.f_cbQueued.addAndGet(batchWriteUnflushed.getLength());
            }
            for (WriteBatch batch = this.m_batchWriteSendHead; batch != null && batch.m_ofAck == batch.m_ofAdd; batch = batch.next()) {
                batch.m_ofSend = batch.m_ofAdd;
                this.f_cbQueued.addAndGet(-batch.getLength());
            }
            for (WriteBatch batch = batchResendHead = this.m_batchWriteResendHead; batch != null; batch = batch.next()) {
                this.f_cbQueued.addAndGet(batch.rewind());
            }
            int nProt = this.getProtocolVersion();
            if (nProt > 0) {
                WriteBatch batchWriteSync = this.m_batchWriteSendHead = new WriteBatch(false);
                int cbHead = nProt < 5 ? 4 : 16;
                int cbBody = 17 + (nProt < 3 ? 0 : 1);
                ByteBuffer bufSync = ByteBuffer.allocate(cbHead + cbBody);
                if (nProt > 4) {
                    bufSync.putLong(-cbBody).position(16);
                } else {
                    bufSync.putInt(-cbBody);
                }
                bufSync.put((byte)2).putLong(this.m_cMsgOutDelivered).putLong(this.m_cMsgIn);
                if (nProt > 2) {
                    bufSync.put(this.m_cUnackLast == 4 ? (byte)1 : 0);
                }
                bufSync.flip();
                if (nProt > 4) {
                    this.populateCtrlMsgHeaderCrc(bufSync);
                }
                batchWriteSync.append(bufSync, false, null, null);
                batchWriteSync.m_ofAck = batchWriteSync.m_ofAdd;
                batchWriteSync.m_next = batchResendHead;
                this.f_cbQueued.addAndGet(batchWriteSync.getLength());
            } else if (this.m_state == AbstractSocketBus.ConnectionState.ACTIVE) {
                this.scheduleDisconnect(new IOException("protocol error; sync at protocol=" + nProt + ", with in=" + this.m_cMsgIn + ", out=" + this.m_cMsgOutDelivered));
            } else {
                this.m_batchWriteSendHead = batchResendHead;
            }
        }

        protected void populateCtrlMsgHeaderCrc(ByteBuffer bufHead) {
            int cbHeader = 16;
            int nPos = bufHead.position();
            int nLimit = bufHead.limit();
            int lCrc = 0;
            CRC32 crc32 = this.f_crcTx;
            if (crc32 != null) {
                crc32.reset();
                bufHead.position(nPos + cbHeader);
                lCrc = Buffers.updateCrc(crc32, bufHead);
                lCrc = lCrc == 0 ? 1 : lCrc;
            }
            bufHead.putInt(nPos + 8, lCrc);
            if (crc32 != null) {
                crc32.reset();
                bufHead.position(nPos).limit(nPos + cbHeader - 4);
                lCrc = Buffers.updateCrc(crc32, bufHead);
                lCrc = lCrc == 0 ? 1 : lCrc;
                bufHead.limit(nLimit);
            }
            bufHead.putInt(nPos + 12, lCrc);
            bufHead.position(nPos);
        }

        protected abstract int processReads(boolean var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int processWrites(boolean fReady) throws IOException {
            long cbBacklog = this.f_cbQueued.get();
            if (fReady) {
                WriteBatch batch = this.m_batchWriteSendHead;
                long cbBundle = this.getAutoFlushThreshold();
                long cbExcessive = this.getBacklogExcessiveThreshold();
                boolean fBacklog = this.m_fBacklog;
                long cbWritten = 0L;
                try {
                    for (int i = 0; cbBacklog > 0L && i < 16 && (cbBacklog <= cbExcessive || fBacklog); ++i) {
                        long cbBatch = batch.getLength();
                        while (cbBatch != 0L && cbBatch < cbBundle && cbBacklog > cbBatch && batch.m_ofAck < batch.m_ofAdd) {
                            cbBatch = batch.bundle();
                        }
                        if (cbBatch == 0L || batch.write()) {
                            cbWritten += cbBatch;
                            if ((cbBacklog -= cbBatch) == 0L) {
                                cbBacklog = this.f_cbQueued.addAndGet(-cbWritten);
                                cbWritten = 0L;
                                if (cbBacklog == 0L) {
                                    break;
                                }
                            }
                        } else {
                            cbWritten += cbBatch - batch.getLength();
                            break;
                        }
                        batch = batch.next();
                    }
                }
                finally {
                    cbBacklog = this.f_cbQueued.addAndGet(-cbWritten);
                    this.m_batchWriteSendHead = batch;
                }
                if (fBacklog) {
                    if (cbBacklog < cbExcessive / 2L) {
                        this.m_fBacklog = false;
                        BufferedSocketBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_NORMAL, this.getPeer()));
                    }
                } else if (cbBacklog > cbExcessive) {
                    this.m_fBacklog = true;
                    BufferedSocketBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_EXCESSIVE, this.getPeer()));
                }
            }
            return cbBacklog > 0L ? 4 : 0;
        }

        @Override
        public void dispose() {
            ByteBuffer bufferMsgReceipt = this.m_bufferRecycleOutboundReceipts;
            if (bufferMsgReceipt != null) {
                BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager().release(bufferMsgReceipt);
                this.m_bufferRecycleOutboundReceipts = null;
            }
            super.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drainReceipts() {
            BufferedConnection bufferedConnection = this;
            synchronized (bufferedConnection) {
                WriteBatch batch = this.m_batchWriteUnflushed;
                this.m_batchWriteUnflushed = null;
                if (batch != null) {
                    this.enqueueWriteBatch(batch);
                }
                for (batch = this.m_batchWriteResendHead; batch != null; batch = batch.next()) {
                    int cEmit;
                    batch.m_ofSend = batch.m_ofAdd;
                    this.f_cbQueued.addAndGet(-batch.getLength());
                    while ((cEmit = batch.ack(Integer.MAX_VALUE, this.f_aoReceiptTmp)) > 0) {
                        for (int i = 0; i < cEmit; ++i) {
                            Object oReceipt = this.f_aoReceiptTmp[i];
                            this.f_aoReceiptTmp[i] = null;
                            if (oReceipt == RECEIPT_NO_EMIT) continue;
                            BufferedSocketBus.this.addEvent(new SimpleEvent(Event.Type.RECEIPT, this.getPeer(), oReceipt));
                        }
                    }
                }
                this.m_batchWriteSendHead = this.m_batchWriteTail = new WriteBatch(false);
                this.m_batchWriteResendHead = this.m_batchWriteTail;
            }
        }

        protected void populateMessageHeader(ByteBuffer buffHead, ByteBuffer[] aBuff, int of, int cBuffers, long cbBuffer) {
        }

        protected abstract int getReceiptSize();

        @Override
        public String toString() {
            String sTimeout;
            WriteBatch batch = this.m_batchWriteUnflushed;
            long ldtAckTimeout = this.m_ldtAckTimeout;
            if (ldtAckTimeout == 0L) {
                sTimeout = "n/a";
            } else {
                long ldtNow = SafeClock.INSTANCE.getSafeTimeMillis();
                long ldtAckFatal = this.m_ldtAckFatalTimeout;
                sTimeout = "ack=" + new Duration(ldtAckTimeout - ldtNow, Duration.Magnitude.MILLI) + (ldtAckFatal == Long.MAX_VALUE ? "" : ", conn=" + new Duration(ldtAckFatal - ldtNow, Duration.Magnitude.MILLI));
            }
            return super.toString() + ", bufferedOut=" + new MemorySize(this.f_cbQueued.get()) + ", unflushed=" + new MemorySize(batch == null ? 0L : batch.getLength()) + ", delivered(in=" + this.m_cMsgIn + ", out=" + this.m_cMsgOutDelivered + "), timeout(" + sTimeout + "), interestOps=" + this.m_nInterestOpsLast + ", unflushed receipt=" + this.m_cReceiptsUnflushed + ", receiptReturn " + this.m_cReceiptsReturn + ", isReceiptFlushRequired " + this.isReceiptFlushRequired();
        }

        public class WriteBatch {
            protected long m_cbBatch;
            protected ByteBuffer[] m_aBuffer = new ByteBuffer[16];
            protected Object[] m_aReceipt = new Object[this.m_aBuffer.length];
            protected int m_ofAdd;
            protected int m_ofSend;
            protected int m_ofAck;
            protected volatile WriteBatch m_next;

            public WriteBatch() {
                this(true);
            }

            public WriteBatch(boolean fLink) {
                if (fLink) {
                    BufferedConnection.this.m_batchWriteTail = BufferedConnection.this.m_batchWriteTail.m_next = this;
                }
            }

            public long getLength() {
                return this.m_cbBatch;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public synchronized long append(ByteBuffer bufHead, boolean fRecycleHead, BufferSequence bufseqBody, Object receipt) {
                BufferedConnection.this.addWriter();
                int cBufferAdd = 1 + (bufseqBody == null ? 0 : bufseqBody.getBufferCount());
                int ofAdd = this.ensureAdditionalBufferCapacity(cBufferAdd);
                Object[] aoReceipt = this.m_aReceipt;
                ByteBuffer[] aBuffer = this.m_aBuffer;
                long cbBody = 0L;
                if (bufseqBody != null) {
                    bufseqBody.getBuffers(0, cBufferAdd - 1, aBuffer, ofAdd + 1);
                    cbBody = bufseqBody.getLength();
                    BufferedConnection.this.populateMessageHeader(bufHead, aBuffer, ofAdd + 1, cBufferAdd, cbBody);
                }
                aBuffer[ofAdd] = bufHead;
                long cb = (long)bufHead.remaining() + cbBody;
                long cbUnacked = cbBody;
                if (fRecycleHead) {
                    aoReceipt[ofAdd] = RECEIPT_HEADER_RECYCLE;
                } else {
                    cbUnacked += (long)bufHead.remaining();
                }
                int eOf = ofAdd + cBufferAdd;
                for (int of = ofAdd; of < eOf; ++of) {
                    aBuffer[of].mark();
                }
                if (receipt == null && this.m_cbBatch == 0L && cBufferAdd > 1) {
                    receipt = RECEIPT_NO_EMIT;
                }
                if (receipt == null) {
                    aoReceipt[ofAdd + cBufferAdd - 1] = fRecycleHead && cBufferAdd == 1 ? RECEIPT_MSG_MARKER_HEADER_RECYCLE : RECEIPT_MSG_MARKER;
                } else if (cBufferAdd == 1) {
                    if (receipt != RECEIPT_ACKREQ_MARKER && receipt != RECEIPT_ACKREQ_MARKER_RECYCLE) throw new IllegalStateException();
                    aoReceipt[ofAdd] = receipt;
                } else {
                    aoReceipt[ofAdd + cBufferAdd - 1] = receipt;
                    ++BufferedConnection.this.m_cReceiptsUnflushed;
                }
                this.m_ofAdd = ofAdd + cBufferAdd;
                BufferedConnection.this.f_cBytesUnacked.addAndGet(cbUnacked);
                return this.m_cbBatch += cb;
            }

            public long bundle() {
                WriteBatch batchSrc = this.m_next;
                int ofAckSrc = batchSrc.m_ofAck;
                int ofSndSrc = batchSrc.m_ofSend;
                int ofSrc = Math.min(ofAckSrc, ofSndSrc);
                int cBufferSrc = batchSrc.m_ofAdd - ofSrc;
                int ofAdd = this.ensureAdditionalBufferCapacity(cBufferSrc);
                System.arraycopy(batchSrc.m_aBuffer, ofSrc, this.m_aBuffer, ofAdd, cBufferSrc);
                System.arraycopy(batchSrc.m_aReceipt, ofSrc, this.m_aReceipt, ofAdd, cBufferSrc);
                this.m_ofAdd = ofAdd + cBufferSrc;
                WriteBatch batchNext = batchSrc.m_next;
                if (batchNext != null) {
                    this.m_next = batchNext;
                }
                if (ofAckSrc > ofSndSrc) {
                    this.m_ofAck += ofAckSrc - ofSndSrc;
                }
                long cbBatch = this.m_cbBatch += batchSrc.getLength();
                batchSrc.m_aBuffer = EMPTY_BUFFER_ARRAY;
                batchSrc.m_aReceipt = EMPTY_BUFFER_ARRAY;
                batchSrc.m_ofAdd = 0;
                batchSrc.m_ofSend = 0;
                batchSrc.m_ofAck = 0;
                batchSrc.m_cbBatch = 0L;
                return cbBatch;
            }

            public boolean write() throws IOException {
                ByteBuffer[] aBuffer = this.m_aBuffer;
                int ofSend = this.m_ofSend;
                int ofAdd = this.m_ofAdd;
                long cb = BufferedConnection.this.write(aBuffer, ofSend, ofAdd - ofSend);
                if (cb > 0L) {
                    while (ofSend < ofAdd && !aBuffer[ofSend].hasRemaining()) {
                        ++ofSend;
                    }
                    this.m_cbBatch -= cb;
                    this.m_ofSend = ofSend;
                }
                return ofSend == ofAdd;
            }

            public int ack(int cReceipts, Object[] aoReceipt) {
                int ofAck;
                BufferManager manager = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager();
                int cMsg = 0;
                ByteBuffer[] aBuff = this.m_aBuffer;
                Object[] aReceipt = this.m_aReceipt;
                int ofSend = this.m_ofSend;
                int ofAdd = this.m_ofAdd;
                int ofReceipt = 0;
                for (ofAck = this.m_ofAck; ofAck < ofAdd && cReceipts > 0; ++ofAck) {
                    Object oReceipt = aReceipt[ofAck];
                    ByteBuffer buff = aBuff[ofAck];
                    aBuff[ofAck] = null;
                    aReceipt[ofAck] = null;
                    if (ofAck >= ofSend) {
                        ByteBuffer buffNew = ByteBuffer.allocate(buff.remaining());
                        buffNew.put(buff).flip();
                        aBuff[ofAck] = buffNew;
                    }
                    if (oReceipt == RECEIPT_HEADER_RECYCLE) {
                        manager.release(buff);
                        continue;
                    }
                    if (oReceipt == RECEIPT_MSG_MARKER_HEADER_RECYCLE || oReceipt == RECEIPT_ACKREQ_MARKER_RECYCLE) {
                        ++cMsg;
                        manager.release(buff);
                        continue;
                    }
                    if (oReceipt != RECEIPT_MSG_MARKER && oReceipt != RECEIPT_ACKREQ_MARKER) continue;
                    ++cMsg;
                }
                this.m_ofAck = ofAck;
                BufferedConnection.this.m_cMsgOutDelivered += (long)cMsg;
                return ofReceipt;
            }

            public long rewind() {
                int ofSend;
                int ofAck = this.m_ofAck;
                ByteBuffer[] aBuffer = this.m_aBuffer;
                long cbDelta = 0L;
                if (ofSend < ofAck) {
                    for (ofSend = this.m_ofSend; ofSend < ofAck; ++ofSend) {
                        cbDelta -= (long)aBuffer[ofSend].remaining();
                    }
                }
                this.m_ofSend = ofAck;
                int ofAdd = this.m_ofAdd;
                while (ofAck < ofAdd) {
                    ByteBuffer buff = aBuffer[ofAck];
                    cbDelta -= (long)buff.remaining();
                    buff.reset();
                    cbDelta += (long)buff.remaining();
                    ++ofAck;
                }
                this.m_cbBatch += cbDelta;
                return cbDelta;
            }

            protected int ensureAdditionalBufferCapacity(int cBufferAdd) {
                Object[] aBuffer = this.m_aBuffer;
                Object[] aReceipt = this.m_aReceipt;
                int ce = aBuffer.length;
                int ofAdd = this.m_ofAdd;
                int ofSrc = Math.min(this.m_ofAck, this.m_ofSend);
                int cBufferUsed = ofAdd - ofSrc;
                if (cBufferUsed + cBufferAdd > ce) {
                    ByteBuffer[] aBufferNew = new ByteBuffer[(ce + cBufferAdd) * 2];
                    System.arraycopy(aBuffer, ofSrc, aBufferNew, 0, cBufferUsed);
                    Object[] aReceiptNew = new Object[aBufferNew.length];
                    System.arraycopy(aReceipt, ofSrc, aReceiptNew, 0, cBufferUsed);
                    this.m_aBuffer = aBufferNew;
                    this.m_aReceipt = aReceiptNew;
                    this.m_ofAck -= ofSrc;
                    this.m_ofSend -= ofSrc;
                    ofAdd = this.m_ofAdd -= ofSrc;
                } else if (ofSrc + cBufferUsed + cBufferAdd > ce) {
                    System.arraycopy(aBuffer, ofSrc, aBuffer, 0, cBufferUsed);
                    Arrays.fill(aBuffer, cBufferUsed, ce, null);
                    System.arraycopy(aReceipt, ofSrc, aReceipt, 0, cBufferUsed);
                    Arrays.fill(aReceipt, cBufferUsed, ce, null);
                    this.m_ofAck -= ofSrc;
                    this.m_ofSend -= ofSrc;
                    ofAdd = this.m_ofAdd -= ofSrc;
                }
                return ofAdd;
            }

            public WriteBatch next() {
                return this.m_next;
            }

            public boolean hasNext() {
                return this.m_next != null;
            }
        }
    }
}

