/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.socketbus;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Holder;
import com.oracle.coherence.common.io.BufferSequence;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class SharedBuffer
implements Holder<ByteBuffer>,
Disposable {
    protected final ByteBuffer m_buffer;
    protected final Disposer m_disposer;
    protected volatile int m_cRefs = 1;
    protected volatile Exception m_stackDispose;
    private static final AtomicIntegerFieldUpdater REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SharedBuffer.class, "m_cRefs");
    private static final boolean TRACK_DISPOSE = Boolean.getBoolean(BufferSequence.class.getName() + ".trackDispose");

    public SharedBuffer(ByteBuffer buffer, Disposer disposer) {
        this.m_buffer = buffer;
        this.m_disposer = disposer;
    }

    public Segment getSegment(int of, int cb) {
        return new Segment(of, cb);
    }

    public Segment getSegment() {
        return new Segment();
    }

    public SharedBuffer attach() {
        this.safeAdjust(true);
        return this;
    }

    public void detach() {
        if (this.safeAdjust(false) == 0) {
            this.m_disposer.dispose(this.m_buffer);
        }
    }

    @Override
    public void set(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ByteBuffer get() {
        return this.m_buffer;
    }

    @Override
    public void dispose() {
        this.detach();
    }

    protected final int safeAdjust(boolean fIncrement) {
        int cNew;
        int cCurr;
        do {
            if ((cCurr = this.m_cRefs) <= 0) {
                throw new IllegalStateException("already disposed during " + (fIncrement ? "attach" : "detach") + "; refCount=" + cCurr + " (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
            }
            cNew = cCurr + (fIncrement ? 1 : -1);
            if (cCurr != Integer.MAX_VALUE) continue;
            return cCurr;
        } while (!REF_COUNT_UPDATER.compareAndSet(this, cCurr, cNew));
        if (TRACK_DISPOSE && !fIncrement && cNew == 0) {
            this.m_stackDispose = new Exception("disposed at");
        }
        return cNew;
    }

    public static interface Disposer {
        public void dispose(ByteBuffer var1);
    }

    public class Segment
    implements Holder<ByteBuffer>,
    Disposable {
        protected final ByteBuffer m_bufferSegment;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment() {
            SharedBuffer sharedBuffer = SharedBuffer.this;
            synchronized (sharedBuffer) {
                this.m_bufferSegment = SharedBuffer.this.m_buffer.slice();
            }
            SharedBuffer.this.safeAdjust(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment(int of, int cb) {
            SharedBuffer sharedBuffer = SharedBuffer.this;
            synchronized (sharedBuffer) {
                ByteBuffer buff = SharedBuffer.this.m_buffer;
                buff.limit(of + cb).position(of);
                this.m_bufferSegment = buff.slice();
            }
            SharedBuffer.this.safeAdjust(true);
        }

        @Override
        public void set(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer get() {
            return this.m_bufferSegment;
        }

        @Override
        public void dispose() {
            SharedBuffer.this.detach();
        }
    }
}

